/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir.gui.typesystem.remote;

import org.jacorb.ir.gui.typesystem.AbstractContainer;
import org.jacorb.ir.gui.typesystem.ModelParticipant;
import org.jacorb.ir.gui.typesystem.TypeSystemNode;
import org.jacorb.ir.gui.typesystem.remote.IRException;
import org.jacorb.ir.gui.typesystem.remote.IRNodeWithType;
import org.jacorb.ir.gui.typesystem.remote.IRParameter;
import org.jacorb.ir.gui.typesystem.remote.RemoteTypeSystem;
import org.omg.CORBA.ExceptionDef;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.OperationDef;
import org.omg.CORBA.OperationDefHelper;
import org.omg.CORBA.ParameterDescription;

public class IROperation
extends IRNodeWithType
implements AbstractContainer {
    protected IRParameter[] parameters;
    protected IRException[] exceptions;
    private String instanceNodeTypeName;
    private OperationDef operationDef;

    public IROperation() {
    }

    public IROperation(IRObject iRObject) {
        super(iRObject);
        this.operationDef = OperationDefHelper.narrow(iRObject);
        this.setAssociatedTypeSystemNode(RemoteTypeSystem.createTypeSystemNode(this.operationDef.result_def()));
        String string = super.getInstanceNodeTypeName();
        if (this.operationDef.mode().value() == 1) {
            string = "oneway " + string;
        }
        this.instanceNodeTypeName = string;
    }

    @Override
    public ModelParticipant[] contents() {
        OperationDef operationDef = OperationDefHelper.narrow(this.irObject);
        ParameterDescription[] parameterDescriptionArray = operationDef.params();
        ModelParticipant[] modelParticipantArray = new TypeSystemNode[parameterDescriptionArray.length];
        for (int i = 0; i < parameterDescriptionArray.length; ++i) {
            modelParticipantArray[i] = RemoteTypeSystem.createTypeSystemNode(parameterDescriptionArray[i]);
        }
        return modelParticipantArray;
    }

    @Override
    public String getInstanceNodeTypeName() {
        return this.instanceNodeTypeName;
    }

    public static String nodeTypeName() {
        return "operation";
    }

    @Override
    public String description() {
        String string = super.description();
        if (this.exceptions == null) {
            ExceptionDef[] exceptionDefArray = this.operationDef.exceptions();
            this.exceptions = new IRException[exceptionDefArray.length];
            for (int i = 0; i < exceptionDefArray.length; ++i) {
                this.exceptions[i] = (IRException)RemoteTypeSystem.createTypeSystemNode(exceptionDefArray[i]);
            }
        }
        if (this.exceptions.length > 0) {
            string = string + "\nExceptions:\t ";
            for (int i = 0; i < this.exceptions.length; ++i) {
                string = string + ((TypeSystemNode)this.exceptions[i]).getAbsoluteName();
                if (i == this.exceptions.length - 1) continue;
                string = string + ", ";
            }
        } else {
            string = string + "\nExceptions:\t:none";
        }
        return string;
    }
}

