/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir.gui.typesystem;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jacorb.ir.gui.typesystem.AbstractContainer;
import org.jacorb.ir.gui.typesystem.ModelParticipant;
import org.jacorb.ir.gui.typesystem.NodeMapper;
import org.jacorb.ir.gui.typesystem.TypeAssociator;
import org.jacorb.ir.gui.typesystem.TypeSystemNode;

public class ModelBuilder
implements Runnable,
TreeExpansionListener,
TreeModelListener {
    private Hashtable threadArguments = new Hashtable();
    protected Hashtable expandedModParts = new Hashtable();
    protected Hashtable treeViewsToUpdate = new Hashtable();
    protected Hashtable treeNodesAndTableModels = new Hashtable();
    private Hashtable treeModelsListenedTo = new Hashtable();
    private static ModelBuilder singleton = new ModelBuilder();

    public DefaultTreeModel buildTreeModel(ModelParticipant modelParticipant) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(modelParticipant);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        defaultTreeModel.setAsksAllowsChildren(true);
        modelParticipant.buildTree(defaultTreeModel, null);
        return defaultTreeModel;
    }

    public DefaultTreeModel buildTreeModelAsync(ModelParticipant modelParticipant) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(modelParticipant);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        defaultTreeModel.setAsksAllowsChildren(true);
        Thread thread = new Thread(this);
        this.threadArguments.put(thread.getName(), defaultTreeModel);
        thread.start();
        return defaultTreeModel;
    }

    public DefaultTreeModel createTreeModelRoot(ModelParticipant modelParticipant) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(modelParticipant);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        modelParticipant.addToParent(defaultTreeModel, null);
        defaultTreeModel.setAsksAllowsChildren(true);
        return defaultTreeModel;
    }

    private synchronized void expandModPart(ModelParticipant modelParticipant, DefaultTreeModel defaultTreeModel) {
        modelParticipant.expand(defaultTreeModel);
    }

    public static ModelBuilder getSingleton() {
        return singleton;
    }

    public synchronized DefaultTableModel getTableModel(DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        Object[] objectArray = new Object[]{"Item", "Type", "Name"};
        defaultTableModel.setColumnIdentifiers(objectArray);
        if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof AbstractContainer) {
            Vector vector;
            if (!this.treeModelsListenedTo.containsKey(defaultTreeModel)) {
                defaultTreeModel.addTreeModelListener(this);
                this.treeModelsListenedTo.put(defaultTreeModel, defaultTreeModel);
            }
            if (this.treeNodesAndTableModels.containsKey(defaultMutableTreeNode)) {
                vector = (Vector)this.treeNodesAndTableModels.get(defaultMutableTreeNode);
                vector.addElement(defaultTableModel);
            } else {
                vector = new Vector();
                vector.addElement(defaultTableModel);
                this.treeNodesAndTableModels.put(defaultMutableTreeNode, vector);
            }
            if (!this.expandedModParts.containsKey(defaultMutableTreeNode)) {
                this.startExpandNode(defaultTreeModel, defaultMutableTreeNode);
            } else {
                for (int i = 0; i < defaultTreeModel.getChildCount(defaultMutableTreeNode); ++i) {
                    this.insertTableRow(defaultTableModel, (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), i);
                }
            }
        }
        return defaultTableModel;
    }

    public TreeExpansionListener getTreeExpansionListener(TreeModel treeModel) {
        return this;
    }

    private void insertTableRow(DefaultTableModel defaultTableModel, DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        TypeSystemNode typeSystemNode = (TypeSystemNode)defaultMutableTreeNode.getUserObject();
        String string = "";
        if (typeSystemNode instanceof TypeAssociator) {
            string = ((TypeAssociator)((Object)typeSystemNode)).getAssociatedType();
        }
        Object[] objectArray = new Object[]{new NodeMapper(typeSystemNode, typeSystemNode.getInstanceNodeTypeName()), new NodeMapper(typeSystemNode, string), new NodeMapper(typeSystemNode, typeSystemNode.getName())};
        defaultTableModel.insertRow(n, objectArray);
    }

    @Override
    public void run() {
        Object object;
        Object[] objectArray;
        Object v = this.threadArguments.get(Thread.currentThread().getName());
        if (v instanceof DefaultTreeModel) {
            objectArray = (Object[])v;
            object = (ModelParticipant)((DefaultMutableTreeNode)objectArray.getRoot()).getUserObject();
            ((ModelParticipant)object).buildTree((DefaultTreeModel)objectArray, null);
        }
        if (v instanceof Object[]) {
            objectArray = (Object[])v;
            object = (DefaultTreeModel)objectArray[0];
            ModelParticipant modelParticipant = (ModelParticipant)objectArray[1];
            this.expandModPart(modelParticipant, (DefaultTreeModel)object);
        }
    }

    private void startExpandNode(DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode) {
        ModelParticipant modelParticipant = (ModelParticipant)defaultMutableTreeNode.getUserObject();
        if (!this.expandedModParts.containsKey(defaultMutableTreeNode)) {
            System.out.println("expanding node: " + defaultMutableTreeNode);
            Thread thread = new Thread(this);
            Object[] objectArray = new Object[]{defaultTreeModel, modelParticipant};
            this.threadArguments.put(thread.getName(), objectArray);
            thread.start();
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    @Override
    public synchronized void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        JTree jTree = (JTree)treeExpansionEvent.getSource();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        TreePath treePath = treeExpansionEvent.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
        this.treeViewsToUpdate.put(defaultMutableTreeNode, jTree);
        this.startExpandNode(defaultTreeModel, defaultMutableTreeNode);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)treeModelEvent.getSource();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
        Vector vector = (Vector)this.treeNodesAndTableModels.get(defaultMutableTreeNode);
        Object[] objectArray = treeModelEvent.getChildren();
        int[] nArray = treeModelEvent.getChildIndices();
        if (vector != null) {
            for (int i = 0; i < nArray.length; ++i) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    DefaultTableModel defaultTableModel = (DefaultTableModel)enumeration.nextElement();
                    this.insertTableRow(defaultTableModel, (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(nArray[i]), nArray[i]);
                }
            }
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }
}

