/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr.util;

import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.jacorb.imr.ServerInfo;
import org.jacorb.imr.util.ImRModel;

public class ImRServerTableModel
extends AbstractTableModel {
    private ImRModel m_model;
    private static final String[] m_columns = new String[]{"Name", "Host", "Command", "active", "holding"};
    private ServerInfo[] m_servers;

    public ImRServerTableModel(ImRModel imRModel) {
        this.m_model = imRModel;
    }

    public void setServers(ServerInfo[] serverInfoArray) {
        this.m_servers = serverInfoArray;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void serverRefreshed(int n) {
        this.fireTableRowsUpdated(n, n);
    }

    @Override
    public int getRowCount() {
        return this.m_servers.length;
    }

    @Override
    public int getColumnCount() {
        return m_columns.length;
    }

    @Override
    public String getColumnName(int n) {
        return m_columns[n];
    }

    public Class getColumnClass(int n) {
        if (n == 0 || n == 1 || n == 2) {
            return String.class;
        }
        if (n == 3 || n == 4) {
            return Boolean.class;
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.m_servers[n].name;
        }
        if (n2 == 1) {
            return this.m_servers[n].host;
        }
        if (n2 == 2) {
            return this.m_servers[n].command;
        }
        if (n2 == 3) {
            return new Boolean(this.m_servers[n].active);
        }
        if (n2 == 4) {
            return new Boolean(this.m_servers[n].holding);
        }
        return new Object();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 >= 1;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.m_model.updateServer(n, m_columns[n2], object);
    }
}

