/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imr.HostInfo;
import org.jacorb.imr.Registration;
import org.jacorb.imr.RegistrationHelper;
import org.jacorb.imr.ServerStartupDaemon;
import org.jacorb.imr.ServerStartupDaemonHelper;
import org.jacorb.imr.ServerStartupDaemonPOA;
import org.jacorb.imr.ServerStartupFailed;
import org.jacorb.util.threadpool.Consumer;
import org.jacorb.util.threadpool.ConsumerFactory;
import org.jacorb.util.threadpool.ThreadPool;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class ServerStartupDaemonImpl
extends ServerStartupDaemonPOA {
    private ORB orb = null;
    private static final String out_prefix = ">> ";
    private ThreadPool stdout_pool = null;
    private ThreadPool stderr_pool = null;
    private Logger logger;

    public ServerStartupDaemonImpl(ORB oRB) {
        this.orb = oRB;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.imr");
        try {
            Registration registration = null;
            registration = RegistrationHelper.narrow(this.orb.resolve_initial_references("ImplementationRepository"));
            if (registration == null) {
                throw new ConfigurationException("ImR not found");
            }
            POA pOA = POAHelper.narrow(this.orb.resolve_initial_references("RootPOA"));
            pOA.the_POAManager().activate();
            ServerStartupDaemon serverStartupDaemon = ServerStartupDaemonHelper.narrow(pOA.servant_to_reference(this));
            HostInfo hostInfo = new HostInfo(InetAddress.getLocalHost().getHostName(), serverStartupDaemon, this.orb.object_to_string(serverStartupDaemon));
            registration.register_host(hostInfo);
        }
        catch (Exception exception) {
            throw new ConfigurationException("Caught Exception", exception);
        }
        this.stdout_pool = new ThreadPool(new OutputForwarderFactory(new InputStreamSelector(){

            @Override
            public InputStream getInputStream(Process process) {
                return process.getInputStream();
            }
        }), 100, 10);
        this.stderr_pool = new ThreadPool(new OutputForwarderFactory(new InputStreamSelector(){

            @Override
            public InputStream getInputStream(Process process) {
                return process.getErrorStream();
            }
        }), 100, 10);
    }

    @Override
    public int get_system_load() {
        return 0;
    }

    @Override
    public void start_server(String string) throws ServerStartupFailed {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Starting: " + string);
            }
            Process process = Runtime.getRuntime().exec(string);
            this.stdout_pool.putJob(process);
            this.stderr_pool.putJob(process);
        }
        catch (Exception exception) {
            this.logger.debug("Caught Exception", exception);
            throw new ServerStartupFailed(exception.toString());
        }
    }

    public static void main(String[] stringArray) {
        try {
            ORB oRB = ORB.init(stringArray, null);
            ServerStartupDaemonImpl serverStartupDaemonImpl = new ServerStartupDaemonImpl(oRB);
            serverStartupDaemonImpl.configure(((org.jacorb.orb.ORB)oRB).getConfiguration());
            oRB.run();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private class OutputForwarderFactory
    implements ConsumerFactory {
        private InputStreamSelector selector = null;

        public OutputForwarderFactory(InputStreamSelector inputStreamSelector) {
            this.selector = inputStreamSelector;
        }

        @Override
        public Consumer create() {
            return new OutputForwarder(this.selector);
        }
    }

    private static interface InputStreamSelector {
        public InputStream getInputStream(Process var1);
    }

    private class OutputForwarder
    implements Consumer {
        private InputStreamSelector selector = null;

        public OutputForwarder(InputStreamSelector inputStreamSelector) {
            this.selector = inputStreamSelector;
        }

        @Override
        public void doWork(Object object) {
            Process process = (Process)object;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.selector.getInputStream(process)));
            String string = null;
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    System.out.println(ServerStartupDaemonImpl.out_prefix + string);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                ServerStartupDaemonImpl.this.logger.debug("Caught Exception", exception);
            }
            ServerStartupDaemonImpl.this.logger.debug("A server process exited");
        }
    }
}

