/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.jms;

import alma.acs.container.ContainerServicesBase;
import alma.acs.exceptions.AcsJException;
import alma.acs.nc.SimpleSupplier;
import com.cosylab.acs.jms.ACSJMSMessage;
import com.cosylab.acs.jms.ACSJMSProducer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.omg.CORBA.portable.IDLEntity;

public class ACSJMSTopicPublisher
extends ACSJMSProducer
implements TopicPublisher {
    private String topicName;
    private static HashMap<String, PublisherPoolItem> publishersPool = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ACSJMSTopicPublisher(Topic topic, ContainerServicesBase containerServicesBase) throws JMSException {
        super((Destination)topic, containerServicesBase);
        if (topic != null) {
            if (topic.getTopicName() == null || topic.getTopicName().isEmpty()) {
                throw new IllegalArgumentException("Invalid topic name");
            }
            this.topicName = topic.getTopicName();
            Object object = publishersPool;
            synchronized (object) {
                if (publishersPool.containsKey(topic.getTopicName())) {
                    return;
                }
            }
            try {
                object = new PublisherPoolItem(topic.getTopicName(), containerServicesBase);
                HashMap<String, PublisherPoolItem> hashMap = publishersPool;
                synchronized (hashMap) {
                    publishersPool.put(topic.getTopicName(), (PublisherPoolItem)object);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                throw new JMSException("Excepion building a PublisherPoolItem " + exception.getMessage());
            }
        }
    }

    public Topic getTopic() throws JMSException {
        return (Topic)this.destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Message message) throws JMSException {
        PublisherPoolItem publisherPoolItem;
        if (message == null) {
            throw new IllegalArgumentException("The message can't be null");
        }
        HashMap<String, PublisherPoolItem> hashMap = publishersPool;
        synchronized (hashMap) {
            publisherPoolItem = publishersPool.get(this.topicName);
        }
        if (publisherPoolItem == null) {
            throw new IllegalStateException("Impossible to use this method without building the publisher passing valid topic");
        }
        publisherPoolItem.sendMessage(message);
    }

    public void publish(Message message, int n, int n2, long l) throws JMSException {
        message.setJMSDeliveryMode(n);
        message.setJMSPriority(n2);
        message.setJMSExpiration(l + System.currentTimeMillis());
        this.publish(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Topic topic, Message message) throws JMSException {
        PublisherPoolItem publisherPoolItem;
        if (message == null) {
            throw new NullPointerException("The message can't be null");
        }
        if (topic == null) {
            throw new NullPointerException("The topic can't be null");
        }
        if (topic.getTopicName() == null || topic.getTopicName().isEmpty()) {
            throw new IllegalArgumentException("Invalid topic name");
        }
        HashMap<String, PublisherPoolItem> hashMap = publishersPool;
        synchronized (hashMap) {
            publisherPoolItem = publishersPool.get(topic.getTopicName());
        }
        if (publisherPoolItem == null) {
            try {
                publisherPoolItem = new PublisherPoolItem(topic.getTopicName(), this.containerServices);
            }
            catch (Exception exception) {
                throw new JMSException("Error building a SimpleSupplier");
            }
            hashMap = publishersPool;
            synchronized (hashMap) {
                publishersPool.put(topic.getTopicName(), publisherPoolItem);
            }
        }
        publisherPoolItem.sendMessage(message);
    }

    public void publish(Topic topic, Message message, int n, int n2, long l) throws JMSException {
        message.setJMSDeliveryMode(n);
        message.setJMSPriority(n2);
        message.setJMSExpiration(l + System.currentTimeMillis());
        this.publish(topic, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        HashMap<String, PublisherPoolItem> hashMap = publishersPool;
        synchronized (hashMap) {
            Collection<PublisherPoolItem> collection = publishersPool.values();
            Iterator<PublisherPoolItem> iterator = collection.iterator();
            while (iterator.hasNext()) {
                PublisherPoolItem publisherPoolItem = iterator.next();
                publisherPoolItem.close();
                iterator.remove();
            }
        }
    }

    public void send(Message message) throws JMSException {
        this.publish(message);
    }

    private class PublisherPoolItem {
        private SimpleSupplier publisher;
        private long lastAccessTime;

        public PublisherPoolItem(String string, ContainerServicesBase containerServicesBase) throws AcsJException {
            this.publisher = new SimpleSupplier(string, "ALARMSYSTEM", containerServicesBase);
            this.lastAccessTime = System.currentTimeMillis();
        }

        public void sendMessage(Message message) throws JMSException {
            if (this.publisher == null) {
                throw new IllegalStateException("Trying to publish on a null publisher");
            }
            if (message instanceof ACSJMSMessage) {
                ((ACSJMSMessage)message).getEntity().type = message.getClass().getName();
                try {
                    this.publisher.publishEvent((IDLEntity)((ACSJMSMessage)message).getEntity());
                }
                catch (AcsJException acsJException) {
                    JMSException jMSException = new JMSException("Failed to publish on NC " + this.publisher.getChannelName());
                    jMSException.setLinkedException((Exception)((Object)acsJException));
                    throw jMSException;
                }
            } else {
                throw new IllegalArgumentException("ACSJMSProducer can only send ACSJMSMessage messages!");
            }
            this.lastAccessTime = System.currentTimeMillis();
        }

        public void close() {
            if (this.publisher == null) {
                throw new IllegalStateException("Trying to close a null publisher");
            }
            this.publisher.disconnect();
            this.publisher = null;
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }
    }
}

