/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.jms;

import alma.acs.container.ContainerServicesBase;
import com.cosylab.acs.jms.ACSJMSMessageEntity;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.omg.CORBA.Object;
import org.omg.CosPropertyService.Property;

public class ACSJMSMessage
implements Message {
    private Destination destination;
    protected ACSJMSMessageEntity entity;
    private ContainerServicesBase containerServices;

    public ACSJMSMessage(ACSJMSMessageEntity aCSJMSMessageEntity, ContainerServicesBase containerServicesBase) {
        if (containerServicesBase == null) {
            throw new IllegalArgumentException("Invalid null ContainerServices");
        }
        this.entity = aCSJMSMessageEntity;
        this.containerServices = containerServicesBase;
    }

    public ACSJMSMessage(ContainerServicesBase containerServicesBase) {
        if (containerServicesBase == null) {
            throw new IllegalArgumentException("Invalid null ContainerServices");
        }
        this.entity = new ACSJMSMessageEntity();
        this.entity.properties = new Property[0];
        this.containerServices = containerServicesBase;
    }

    public String getJMSMessageID() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void setJMSMessageID(String string) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public long getJMSTimestamp() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void setJMSTimestamp(long l) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void setJMSCorrelationIDAsBytes(byte[] byArray) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void setJMSCorrelationID(String string) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public String getJMSCorrelationID() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public Destination getJMSReplyTo() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void setJMSReplyTo(Destination destination) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public Destination getJMSDestination() throws JMSException {
        return this.destination;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.destination = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.entity.delivery_mode;
    }

    public void setJMSDeliveryMode(int n) throws JMSException {
        this.entity.delivery_mode = n;
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.entity.redelivered;
    }

    public void setJMSRedelivered(boolean bl) throws JMSException {
        this.entity.redelivered = bl;
    }

    public String getJMSType() throws JMSException {
        return this.entity.type;
    }

    public void setJMSType(String string) throws JMSException {
        this.entity.type = string;
    }

    public long getJMSExpiration() throws JMSException {
        return this.entity.expiration;
    }

    public void setJMSExpiration(long l) throws JMSException {
        this.entity.expiration = l;
    }

    public int getJMSPriority() throws JMSException {
        return this.entity.priority;
    }

    public void setJMSPriority(int n) throws JMSException {
        this.entity.priority = n;
    }

    public void clearProperties() throws JMSException {
        this.entity.properties = new Property[0];
    }

    public boolean propertyExists(String string) throws JMSException {
        return this.findProperty(string, false) != -1;
    }

    public boolean getBooleanProperty(String string) throws JMSException {
        int n = this.findProperty(string, false);
        if (n == -1) {
            throw new JMSException("Propery " + string + " not found");
        }
        boolean bl = this.entity.properties[n].property_value.extract_boolean();
        return bl;
    }

    public byte getByteProperty(String string) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public short getShortProperty(String string) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public int getIntProperty(String string) throws JMSException {
        int n = this.findProperty(string, false);
        if (n == -1) {
            throw new JMSException("Propery " + string + " mot found");
        }
        return this.entity.properties[n].property_value.extract_long();
    }

    public long getLongProperty(String string) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public float getFloatProperty(String string) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public double getDoubleProperty(String string) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public String getStringProperty(String string) throws JMSException {
        int n = this.findProperty(string, false);
        if (n == -1) {
            return null;
        }
        return this.entity.properties[n].property_value.extract_string();
    }

    public java.lang.Object getObjectProperty(String string) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public Enumeration getPropertyNames() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void setBooleanProperty(String string, boolean bl) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void setByteProperty(String string, byte by) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void setShortProperty(String string, short s) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void setIntProperty(String string, int n) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void setLongProperty(String string, long l) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void setFloatProperty(String string, float f) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void setDoubleProperty(String string, double d) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void setStringProperty(String string, String string2) throws JMSException {
        int n = this.findProperty(string, true);
        this.entity.properties[n].property_value.insert_string(string2);
    }

    public void setObjectProperty(String string, java.lang.Object object) throws JMSException {
        if (string == null) {
            throw new NullPointerException("Name is null!!!");
        }
        if (object == null) {
            return;
        }
        int n = this.findProperty(string, true);
        if (object == null) {
            throw new NullPointerException("Value is null!!!");
        }
        if (object instanceof Boolean) {
            this.entity.properties[n].property_value.insert_boolean(((Boolean)object).booleanValue());
        } else if (object instanceof Integer) {
            this.entity.properties[n].property_value.insert_long(((Integer)object).intValue());
        } else if (object instanceof String) {
            this.entity.properties[n].property_value.insert_string((String)object);
        } else if (object instanceof Long) {
            this.entity.properties[n].property_value.insert_longlong(((Long)object).longValue());
        } else if (object instanceof Short) {
            this.entity.properties[n].property_value.insert_short(((Short)object).shortValue());
        } else if (object instanceof Byte) {
            this.entity.properties[n].property_value.insert_octet(((Byte)object).byteValue());
        } else if (object instanceof Double) {
            this.entity.properties[n].property_value.insert_double(((Double)object).doubleValue());
        } else if (object instanceof Object) {
            this.entity.properties[n].property_value.insert_Object((Object)object);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void acknowledge() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void clearBody() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public ACSJMSMessageEntity getEntity() {
        return this.entity;
    }

    private int findProperty(String string, boolean bl) {
        for (int i = 0; i < this.entity.properties.length; ++i) {
            if (!string.equals(this.entity.properties[i].property_name)) continue;
            return i;
        }
        if (bl) {
            Property[] propertyArray = new Property[this.entity.properties.length + 1];
            for (int i = 0; i < this.entity.properties.length; ++i) {
                propertyArray[i] = this.entity.properties[i];
            }
            propertyArray[propertyArray.length - 1] = new Property(string, this.containerServices.getAdvancedContainerServices().getAny());
            this.entity.properties = propertyArray;
            return propertyArray.length - 1;
        }
        return -1;
    }
}

