/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.jms;

import alma.acs.container.ContainerServicesBase;
import com.codestreet.selector.parser.InvalidSelectorException;
import com.cosylab.acs.jms.ACSJMSMessage;
import com.cosylab.acs.jms.ACSJMSMessageEntity;
import com.cosylab.acs.jms.ACSJMSMessageSelector;
import com.cosylab.acs.jms.ACSJMSObjectMessage;
import com.cosylab.acs.jms.ACSJMSTextMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public abstract class ACSJMSConsumer
implements MessageConsumer {
    private MessageListener listener;
    protected Destination destination;
    private ContainerServicesBase containerServices;
    private ACSJMSMessageSelector selector = null;

    public ACSJMSConsumer(Destination destination, ContainerServicesBase containerServicesBase, String string) throws JMSException {
        if (containerServicesBase == null) {
            throw new IllegalArgumentException("The ContainerServicesBase can't be null");
        }
        this.destination = destination;
        this.containerServices = containerServicesBase;
        try {
            this.selector = new ACSJMSMessageSelector(string);
        }
        catch (InvalidSelectorException invalidSelectorException) {
            System.err.println("Exception caught while building an ACSJMSConsumer:");
            System.err.println(invalidSelectorException.getMessage());
            JMSException jMSException = new JMSException(invalidSelectorException.getMessage());
            throw jMSException;
        }
    }

    public String getMessageSelector() throws JMSException {
        return this.selector.getSelectorString();
    }

    public void setMessageSelector(String string) {
        try {
            this.selector.setSelectorString(string);
            System.out.println("## Selector set to [" + string + "]");
        }
        catch (InvalidSelectorException invalidSelectorException) {
            System.err.println("Exception setting the selector " + string);
            System.err.println("Exception message: " + invalidSelectorException.getMessage());
            invalidSelectorException.printStackTrace(System.err);
            System.err.println("The selector will be set to null!");
            try {
                this.selector.setSelectorString(null);
            }
            catch (InvalidSelectorException invalidSelectorException2) {
                // empty catch block
            }
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.listener;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.listener = messageListener;
    }

    public Message receive() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public Message receive(long l) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public Message receiveNoWait() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void close() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void receive(ACSJMSMessageEntity aCSJMSMessageEntity) {
        if (aCSJMSMessageEntity == null) {
            throw new NullPointerException("The message received is null");
        }
        ACSJMSMessage aCSJMSMessage = null;
        aCSJMSMessage = aCSJMSMessageEntity.type.compareTo("com.cosylab.acs.jms.ACSJMSObjectMessage") == 0 ? new ACSJMSObjectMessage(aCSJMSMessageEntity, this.containerServices) : new ACSJMSTextMessage(aCSJMSMessageEntity, this.containerServices);
        if (this.listener == null) {
            return;
        }
        if (this.selector.match(aCSJMSMessage)) {
            this.listener.onMessage((Message)aCSJMSMessage);
        }
    }
}

