/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBErrorWin;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBJComboBox;
import com.ca.commons.jndi.ConnectionData;
import com.ca.commons.naming.CBOpenConWin;
import com.ca.directory.jxplorer.DataListener;
import com.ca.directory.jxplorer.DataQuery;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.broker.JNDIBroker;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class JXOpenConWin
extends CBOpenConWin
implements DataListener {
    private static final Logger log = Logger.getLogger(CBOpenConWin.class.getName());
    private static final HashMap cachedps = new HashMap(20);
    private JXplorer jxplorer;
    private JNDIBroker jndiBroker;
    private JTextField dsmlService;
    protected static final String DSMLV2 = CBIntText.get("DSML v2");

    public JXOpenConWin(JXplorer jx, JLabel statusDisplay, String clientcerts, String cacerts, String referral, String aliasType) {
        super(jx, statusDisplay, clientcerts, cacerts, referral, aliasType, "connect");
        this.jxplorer = jx;
        this.newCon.tracing = this.jxplorer.jndiBroker.getTracing();
        this.addPasswordHandlingListener();
    }

    private void addPasswordHandlingListener() {
        CBJComboBox templateSelector = this.myTemplater.getLoadComboBox();
        ActionListener[] listeners = templateSelector.getActionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            templateSelector.removeActionListener(listeners[i]);
        }
        templateSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JXOpenConWin.this.myTemplater.load();
                JXOpenConWin.this.checkSecurityLevel();
                JXOpenConWin.this.retrieveCachedPassword();
            }
        });
        CBButton save = this.myTemplater.getSaveButton();
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JXOpenConWin.this.cachePassword();
            }
        });
    }

    protected void initGUI(JLabel statusDisplay) {
        super.initGUI(statusDisplay);
        if (JXplorer.getProperty("dsml") == null || !JXplorer.getProperty("dsml").equalsIgnoreCase("false")) {
            this.version.addItem(DSMLV2);
        }
        this.myTemplater.loadDefault();
        this.retrieveCachedPassword();
        this.display.validate();
    }

    private void retrieveCachedPassword() {
        if (!JXplorer.getProperty("jxplorer.cache.passwords").equals("true")) {
            return;
        }
        if (this.hostName.getText().trim() == "") {
            return;
        }
        String key = this.makePwdKey();
        if (cachedps.containsKey(key)) {
            String p = (String)cachedps.get(key);
            this.password.setText(p);
        }
    }

    private void cachePassword() {
        if (!JXplorer.getProperty("jxplorer.cache.passwords").equals("true")) {
            return;
        }
        String key = this.makePwdKey();
        cachedps.put(key, new String(this.password.getPassword()));
    }

    private String makePwdKey() {
        String key = new StringBuffer(50).append(this.port.getText()).append(this.managerDN.getText()).append(this.version.getSelectedItem().toString()).append(this.level.getSelectedIndex()).toString();
        return key;
    }

    public void addExtraComponent() {
        this.display.makeLight();
        JLabel urlLabel = new JLabel("   " + CBIntText.get("DSML Service") + ": ");
        this.display.add(urlLabel, 0, 2, 1, 1);
        this.dsmlService = new JTextField("", 30);
        this.display.addWide(this.dsmlService, 4);
        urlLabel.setToolTipText(CBIntText.get("The DSML service; e.g. ") + "'dsml/services/DSML?ldapHost=localhost&ldapPort=19289'");
        VersionActionListener versionListener = new VersionActionListener();
        this.version.addActionListener(versionListener);
    }

    public void doOK() {
        this.newCon.protocol = this.version.getSelectedItem().equals(DSMLV2) ? "dsml" : "ldap";
        this.addExtraEnvironmentProperties();
        this.cachePassword();
        super.doOK();
    }

    private void addExtraEnvironmentProperties() {
        Properties props = JXplorer.getMyProperties();
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith("Context") && !key.startsWith("context") && !key.startsWith("com.sun.jndi.ldap") && !key.startsWith("java.security") && !key.startsWith("javax.security")) continue;
            this.newCon.putExtraProperty(key, props.getProperty(key));
        }
    }

    public void reinit(String newclientcerts, String newcacerts, String newreferral, String newaliasType) {
        this.newCon.clientcerts = newclientcerts;
        this.newCon.cacerts = newcacerts;
        this.newCon.referralType = newreferral;
        this.newCon.aliasType = newaliasType;
        this.newCon.tracing = this.jndiBroker == null ? this.jxplorer.jndiBroker.getTracing() : this.jndiBroker.getTracing();
    }

    public void resetTitleAndPassword() {
        this.setTitle(CBIntText.get("Open LDAP/DSML Connection"));
        if (!JXplorer.getProperty("jxplorer.cache.passwords").equals("true")) {
            this.password.setText("");
        }
    }

    public void connect(ConnectionData connectData) {
        try {
            this.jndiBroker = this.jxplorer.jndiBroker;
            this.jxplorer.preConnectionSetup();
            DataQuery query = this.jndiBroker.connect(connectData);
            query.addDataListener(this);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unexpected exception in JXOpenConWin.connect", e);
            e.printStackTrace();
        }
    }

    public void dataReady(DataQuery request) {
        if (!(request instanceof JNDIBroker.DataConnectionQuery)) {
            log.warning("Incorrect data for connection - cannot connect");
            return;
        }
        if (!request.hasException()) {
            if (this.jxplorer.postConnectionSetup((JNDIBroker.DataConnectionQuery)request)) {
                this.setVisible(false);
                ((JNDIBroker.DataConnectionQuery)request).conData.clearPasswords();
                this.dispose();
            } else {
                this.jxplorer.disconnect();
            }
        } else {
            new CBErrorWin((Dialog)this, "Error opening connection:\n" + request.getException().getMessage(), request.getException());
            log.log(Level.WARNING, "Error opening connection ", request.getException());
            request.clearException();
            this.setTitle(CBIntText.get("Couldn't Connect: Try Again"));
            this.dispose();
            this.setVisible(true);
            this.userMessage.setText(CBIntText.get("Couldn't Open ") + request.getExtendedData("url"));
            this.jxplorer.disconnect();
            request.squelch();
        }
    }

    protected String getURL() throws NumberFormatException, URISyntaxException {
        String url = super.getURL();
        if (this.version.getSelectedItem().equals(DSMLV2)) {
            String dsml = this.dsmlService.getText();
            if (dsml.startsWith("/")) {
                dsml = dsml.substring(1);
            }
            if (url.startsWith("ldap://")) {
                url = url.substring(7);
            }
            url = "http://" + url + "/" + dsml;
        }
        log.fine("connecting with url: " + url);
        return url;
    }

    class VersionActionListener
    implements ActionListener {
        VersionActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (!JXOpenConWin.this.version.getSelectedItem().equals(DSMLV2)) {
                JXOpenConWin.this.dsmlService.setEnabled(false);
                JXOpenConWin.this.dsmlService.setText("");
                JXOpenConWin.this.dsmlService.setBackground(Color.lightGray);
                JXOpenConWin.this.level.setEnabled(true);
                JXOpenConWin.this.checkSecurityLevel();
            } else {
                JXOpenConWin.this.dsmlService.setEnabled(true);
                JXOpenConWin.this.dsmlService.setBackground(Color.white);
                JXOpenConWin.this.level.setSelectedIndex(0);
                JXOpenConWin.this.managerDN.setText("");
                JXOpenConWin.this.password.setText("");
                JXOpenConWin.this.checkSecurityLevel();
                JXOpenConWin.this.level.setEnabled(false);
            }
        }
    }
}

