/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows.search;

public class SearchWindowSettings {
    private int windowMode;
    private int switchMode;
    public static final int ID_ALL = 1;
    public static final int ID_EQUAL = 2;
    public static final int ID_CONTAINS = 3;
    public static final int SORT_NONE = 0;
    public static final int SORT_BY_TIME = 1;
    public static final int SORT_BY_PRIORITY = 2;
    public static final int SORT_BY_GROUP_NT = 3;
    public static final int SORT_BY_GROUP_NT_BY_PR = 4;
    public static final int CAP_HOST_NAME_ALL = 1;
    public static final int CAP_HOST_NAME_EQUALS = 2;
    public static int SWITCH_MODE_SN_I_PD = 1;
    public static int SWITCH_MODE_FF_FM_FC = 2;
    private AlarmIdentifierField SNFF;
    private AlarmIdentifierField IFM;
    private AlarmIdentifierField PDFC;
    private boolean priority_0;
    private boolean priority_1;
    private boolean priority_2;
    private boolean priority_3;
    private String after;
    private String before;
    private boolean active;
    private boolean acknowledged;
    private boolean highlighted;
    private boolean masked;
    private boolean terminated;
    private int sortState;
    private int CAPHostNameState;
    private String CAPHostNameEquals;

    public SearchWindowSettings(int n) {
        this.windowMode = n;
        this.switchMode = SWITCH_MODE_SN_I_PD;
        this.SNFF = new AlarmIdentifierField(n);
        this.IFM = new AlarmIdentifierField(n);
        this.PDFC = new AlarmIdentifierField(n);
        this.priority_0 = false;
        this.priority_1 = false;
        this.priority_2 = false;
        this.priority_3 = false;
        this.after = "";
        this.before = "";
        this.active = false;
        this.acknowledged = false;
        this.highlighted = false;
        this.masked = false;
        this.terminated = false;
        this.sortState = 1;
        this.CAPHostNameState = 1;
        this.CAPHostNameEquals = "";
    }

    public int getWindowMode() {
        return this.windowMode;
    }

    public void setWindowMode(int n) {
        this.windowMode = n;
        this.SNFF.setWindowMode(n);
        this.IFM.setWindowMode(n);
        this.PDFC.setWindowMode(n);
    }

    public int getSwitchMode() {
        return this.switchMode;
    }

    public void setSwitchMode(int n) {
        this.switchMode = n;
    }

    public int getSNFFState() {
        return this.SNFF.getState();
    }

    public void setSNFFState(int n) {
        this.SNFF.setState(n);
    }

    public String getSNFFContains() {
        return this.SNFF.getContains();
    }

    public void setSNFFContains(String string) {
        this.SNFF.setContains(string);
    }

    private void setSNFFWindowMode(int n) {
        this.SNFF.setWindowMode(n);
    }

    private int getSNFFWindowMode() {
        return this.SNFF.getWindowMode();
    }

    public int getIFMState() {
        return this.IFM.getState();
    }

    public void setIFMState(int n) {
        this.IFM.setState(n);
    }

    public String getIFMContains() {
        return this.IFM.getContains();
    }

    public void setIFMContains(String string) {
        this.IFM.setContains(string);
    }

    private void setIFMWindowMode(int n) {
        this.IFM.setWindowMode(n);
    }

    private int getIFMWindowMode() {
        return this.IFM.getWindowMode();
    }

    public int getPDFCState() {
        return this.PDFC.getState();
    }

    public void setPDFCState(int n) {
        this.PDFC.setState(n);
    }

    public String getPDFCContains() {
        return this.PDFC.getContains();
    }

    public void setPDFCContains(String string) {
        this.PDFC.setContains(string);
    }

    private void setPDFCWindowMode(int n) {
        this.PDFC.setWindowMode(n);
    }

    private int getPDFCWindowMode() {
        return this.PDFC.getWindowMode();
    }

    public boolean getPriority_0() {
        return this.priority_0;
    }

    public boolean getPriority_1() {
        return this.priority_1;
    }

    public boolean getPriority_2() {
        return this.priority_2;
    }

    public boolean getPriority_3() {
        return this.priority_3;
    }

    public void setPriority_0(boolean bl) {
        this.priority_0 = bl;
    }

    public void setPriority_1(boolean bl) {
        this.priority_1 = bl;
    }

    public void setPriority_2(boolean bl) {
        this.priority_2 = bl;
    }

    public void setPriority_3(boolean bl) {
        this.priority_3 = bl;
    }

    public boolean isTimeStampEnabled() {
        return this.windowMode != 2;
    }

    public String getTimeStampAfter() {
        if (this.windowMode == 2) {
            return "";
        }
        return this.after;
    }

    public void setTimeStampAfter(String string) {
        this.after = string;
    }

    public String getTimeStampBefore() {
        return this.before;
    }

    public void setTimeStampBefore(String string) {
        this.before = string;
    }

    public boolean getStatusActive() {
        if (!this.isStatusActiveEnabled()) {
            return false;
        }
        return this.active;
    }

    public boolean getStatusAcknowledged() {
        if (!this.isStatusAcknowledgedEnabled()) {
            return false;
        }
        return this.acknowledged;
    }

    public boolean getStatusHighlighted() {
        if (!this.isStatusHighlightedEnabled()) {
            return false;
        }
        return this.highlighted;
    }

    public boolean getStatusMasked() {
        if (!this.isStatusMaskedEnabled()) {
            return false;
        }
        return this.masked;
    }

    public boolean getStatusTerminated() {
        if (!this.isStatusTerminatedEnabled()) {
            return false;
        }
        return this.terminated;
    }

    public void setStatusActive(boolean bl) {
        this.active = bl;
    }

    public void setStatusAcknowledged(boolean bl) {
        this.acknowledged = bl;
    }

    public void setStatusHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    public void setStatusMasked(boolean bl) {
        this.masked = bl;
    }

    public void setStatusTerminated(boolean bl) {
        this.terminated = bl;
    }

    public boolean isStatusActiveEnabled() {
        return this.windowMode != 2;
    }

    public boolean isStatusAcknowledgedEnabled() {
        return this.windowMode != 1 && this.windowMode != 2;
    }

    public boolean isStatusHighlightedEnabled() {
        return this.windowMode != 1 && this.windowMode != 2;
    }

    public boolean isStatusMaskedEnabled() {
        return this.windowMode != 1 && this.windowMode != 2;
    }

    public boolean isStatusTerminatedEnabled() {
        return this.windowMode != 2;
    }

    public int getSortState() {
        if (this.windowMode == 2) {
            return 0;
        }
        return this.sortState;
    }

    public void setSortState(int n) {
        this.sortState = n;
    }

    public boolean isSortByPriorityEnabled() {
        return this.windowMode != 2;
    }

    public boolean isSortByTimeEnabled() {
        return this.windowMode != 2;
    }

    public boolean isSortGroupNTEnabled() {
        return this.windowMode != 2 && this.windowMode != 3;
    }

    public boolean isSortGroupNTByPriorityEnabled() {
        return this.windowMode != 2 && this.windowMode != 3;
    }

    public int getCAPHostNameState() {
        return this.CAPHostNameState;
    }

    public void setCAPHostNameState(int n) {
        this.CAPHostNameState = n;
    }

    public String getCAPHostNameEquals() {
        return this.CAPHostNameEquals;
    }

    public void setCAPHostNameEquals(String string) {
        this.CAPHostNameEquals = string;
    }

    public boolean isCAPHostNameEqualsEnabled() {
        return this.windowMode != 2;
    }

    private class AlarmIdentifierField {
        private int windowMode;
        private int state;
        private String contains;

        public AlarmIdentifierField(int n) {
            this(n, 1, "");
        }

        public AlarmIdentifierField(int n, int n2, String string) {
            this.windowMode = n;
            this.state = n2;
            this.contains = string;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int n) {
            this.state = n;
        }

        public int getWindowMode() {
            return this.windowMode;
        }

        public void setWindowMode(int n) {
            this.windowMode = n;
        }

        public String getContains() {
            return this.contains;
        }

        public void setContains(String string) {
            this.contains = string;
        }
    }
}

