/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows.search;

import cern.laser.client.LaserException;
import cern.laser.client.LaserTimeOutException;
import cern.laser.client.data.Category;
import cern.laser.client.impl.services.selection.CategorySelectionImpl;
import cern.laser.client.impl.services.selection.SelectionImpl;
import cern.laser.client.services.selection.AlarmSearchListener;
import cern.laser.client.services.selection.CategorySelection;
import cern.laser.client.services.selection.Selection;
import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.alarms.AlarmContainer;
import cern.laser.guiplatform.alarms.AlarmNodeManager;
import cern.laser.guiplatform.alarms.AlarmSelectionHandlerFactory;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.Constants;
import cern.laser.guiplatform.util.SearchProxyBuffer;
import cern.laser.guiplatform.windows.ActiveListExplorerPanel;
import cern.laser.guiplatform.windows.search.ProgressDialog;
import cern.laser.guiplatform.windows.search.SearchWindowSettings;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class SearchWindow
extends TopComponent {
    Selection selection;
    int windowMode;
    SearchWindowSettings settings;
    Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private JRadioButton IFMallRadioButton;
    private ButtonGroup IFMbuttonGroup;
    private JRadioButton IFMcontainsRadioButton;
    private JRadioButton IFMequalsRadioButton;
    private JPanel IFMpanel;
    private JTextField IFMtextField;
    private JRadioButton PDFCallRadioButton;
    private ButtonGroup PDFCbuttonGroup;
    private JRadioButton PDFCcontainsRadioButton;
    private JRadioButton PDFCequalsRadioButton;
    private JPanel PDFCpanel;
    private JTextField PDFCtextField;
    private JRadioButton SNFFallRadioButton;
    private ButtonGroup SNFFbuttonGroup;
    private JRadioButton SNFFcontainsRadioButton;
    private JRadioButton SNFFequalsRadioButton;
    private JPanel SNFFpanel;
    private JTextField SNFFtextField;
    private JPanel bottomMainPanel;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JRadioButton hostNameAllRadioButton;
    private ButtonGroup hostNameButtonGroup;
    private JRadioButton hostNameEqualsRadioButton;
    private JPanel hostNamePanel;
    private JTextField hostNameTextField;
    private JButton jButton1;
    private JButton jButton2;
    private JPanel mainPanel;
    private JCheckBox priorityLevel0checkBox;
    private JCheckBox priorityLevel1checkBox;
    private JCheckBox priorityLevel2checkBox;
    private JCheckBox priorityLevel3checkBox;
    private JPanel priorityPanel;
    private JButton searchButton;
    private JRadioButton sortByPriorityRadioButton;
    private JRadioButton sortByTimeRadioButton;
    private JRadioButton sortGroupNTRadioButton;
    private JRadioButton sortGroupNTbyPriorityRadioButton;
    private ButtonGroup sortOptionButtonGroup;
    private JPanel sortOptionPanel;
    private JCheckBox statusAcknowledgedCheckBox;
    private JCheckBox statusActiveCheckBox;
    private JCheckBox statusHighlightedCheckBox;
    private JCheckBox statusMaskedCheckBox;
    private JPanel statusPanel;
    private JCheckBox statusTerminatedCheckBox;
    private JTextField timestampAfterTextField;
    private JTextField timestampBeforeTextField;
    private JLabel timestampLabel1;
    private JLabel timestampLabel2;
    private JPanel timestampPanel;
    private JPanel upperMainPanel;
    private static final long serialVersionUID = 1L;

    public SearchWindow() {
        this(3, null);
    }

    public SearchWindow(int n, Category[] categoryArray) {
        this.selection = new SelectionImpl();
        CategorySelectionImpl categorySelectionImpl = new CategorySelectionImpl();
        categorySelectionImpl.addAll(Arrays.asList(categoryArray));
        this.selection.setCategorySelection((CategorySelection)categorySelectionImpl);
        this.windowMode = n;
        this.settings = AppRegister.getInstance().getSearchWindowSettings(n);
        this.initComponents();
        this.setCloseOperation(1);
        switch (n) {
            case 1: {
                this.setName(NbBundle.getMessage(SearchWindow.class, (String)"LBL_search_component_name_archive"));
                break;
            }
            case 2: {
                this.setName(NbBundle.getMessage(SearchWindow.class, (String)"LBL_search_component_name_alarminfo"));
                break;
            }
            case 3: {
                this.setName(NbBundle.getMessage(SearchWindow.class, (String)"LBL_search_component_name_search"));
                break;
            }
            default: {
                this.setName("No label found, check Bundle file!");
            }
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SearchWindow.class);
    }

    private void initComponents() {
        this.SNFFbuttonGroup = new ButtonGroup();
        this.IFMbuttonGroup = new ButtonGroup();
        this.PDFCbuttonGroup = new ButtonGroup();
        this.sortOptionButtonGroup = new ButtonGroup();
        this.hostNameButtonGroup = new ButtonGroup();
        this.buttonsPanel = new JPanel();
        this.searchButton = new JButton();
        this.cancelButton = new JButton();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.mainPanel = new JPanel();
        this.upperMainPanel = new JPanel();
        this.SNFFpanel = new JPanel();
        this.SNFFallRadioButton = new JRadioButton();
        this.SNFFequalsRadioButton = new JRadioButton();
        this.SNFFcontainsRadioButton = new JRadioButton();
        this.SNFFtextField = new JTextField();
        this.IFMpanel = new JPanel();
        this.IFMallRadioButton = new JRadioButton();
        this.IFMequalsRadioButton = new JRadioButton();
        this.IFMcontainsRadioButton = new JRadioButton();
        this.IFMtextField = new JTextField();
        this.PDFCpanel = new JPanel();
        this.PDFCallRadioButton = new JRadioButton();
        this.PDFCequalsRadioButton = new JRadioButton();
        this.PDFCcontainsRadioButton = new JRadioButton();
        this.PDFCtextField = new JTextField();
        this.priorityPanel = new JPanel();
        this.priorityLevel0checkBox = new JCheckBox();
        this.priorityLevel1checkBox = new JCheckBox();
        this.priorityLevel2checkBox = new JCheckBox();
        this.priorityLevel3checkBox = new JCheckBox();
        this.bottomMainPanel = new JPanel();
        this.timestampPanel = new JPanel();
        this.timestampLabel1 = new JLabel();
        this.timestampAfterTextField = new JTextField();
        this.timestampLabel2 = new JLabel();
        this.timestampBeforeTextField = new JTextField();
        this.statusPanel = new JPanel();
        this.statusActiveCheckBox = new JCheckBox();
        this.statusAcknowledgedCheckBox = new JCheckBox();
        this.statusHighlightedCheckBox = new JCheckBox();
        this.statusMaskedCheckBox = new JCheckBox();
        this.statusTerminatedCheckBox = new JCheckBox();
        this.sortOptionPanel = new JPanel();
        this.sortByTimeRadioButton = new JRadioButton();
        this.sortByPriorityRadioButton = new JRadioButton();
        this.sortGroupNTRadioButton = new JRadioButton();
        this.sortGroupNTbyPriorityRadioButton = new JRadioButton();
        this.hostNamePanel = new JPanel();
        this.hostNameAllRadioButton = new JRadioButton();
        this.hostNameEqualsRadioButton = new JRadioButton();
        this.hostNameTextField = new JTextField();
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(400, 277));
        this.setPreferredSize(new Dimension(630, 380));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                SearchWindow.this.formComponentShown(componentEvent);
            }
        });
        this.buttonsPanel.setToolTipText("");
        this.searchButton.setFont(new Font("Dialog", 0, 12));
        this.searchButton.setText("Search");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.searchButtonActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.searchButton);
        this.cancelButton.setFont(new Font("Dialog", 0, 12));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.cancelButton);
        this.jButton1.setFont(new Font("Dialog", 0, 12));
        this.jButton1.setText("Switch");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.jButton1);
        this.jButton2.setText("TEST IT");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.jButton2ActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.jButton2);
        this.add(this.buttonsPanel, "South");
        this.mainPanel.setLayout(new GridLayout(0, 1));
        this.mainPanel.setBorder(new TitledBorder(""));
        this.upperMainPanel.setLayout(new GridLayout(1, 0));
        this.SNFFpanel.setLayout(new GridLayout(0, 1));
        this.SNFFpanel.setBorder(new TitledBorder("System Name"));
        this.SNFFallRadioButton.setFont(new Font("Dialog", 0, 12));
        this.SNFFallRadioButton.setText("All");
        this.SNFFbuttonGroup.add(this.SNFFallRadioButton);
        if (this.settings.getSNFFState() == 1) {
            this.SNFFallRadioButton.setSelected(true);
        } else {
            this.SNFFallRadioButton.setSelected(false);
        }
        this.SNFFallRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.SNFFallRadioButtonActionPerformed(actionEvent);
            }
        });
        this.SNFFpanel.add(this.SNFFallRadioButton);
        this.SNFFequalsRadioButton.setFont(new Font("Dialog", 0, 12));
        this.SNFFequalsRadioButton.setText("Equals");
        this.SNFFbuttonGroup.add(this.SNFFequalsRadioButton);
        if (this.settings.getSNFFState() == 2) {
            this.SNFFequalsRadioButton.setSelected(true);
        } else {
            this.SNFFequalsRadioButton.setSelected(false);
        }
        this.SNFFequalsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.SNFFequalsRadioButtonActionPerformed(actionEvent);
            }
        });
        this.SNFFpanel.add(this.SNFFequalsRadioButton);
        this.SNFFcontainsRadioButton.setFont(new Font("Dialog", 0, 12));
        this.SNFFcontainsRadioButton.setText("Contains");
        this.SNFFbuttonGroup.add(this.SNFFcontainsRadioButton);
        if (this.settings.getSNFFState() == 3) {
            this.SNFFcontainsRadioButton.setSelected(true);
        } else {
            this.SNFFcontainsRadioButton.setSelected(false);
        }
        this.SNFFcontainsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.SNFFcontainsRadioButtonActionPerformed(actionEvent);
            }
        });
        this.SNFFpanel.add(this.SNFFcontainsRadioButton);
        this.SNFFtextField.setText(this.settings.getSNFFContains());
        if (this.SNFFcontainsRadioButton.isSelected() || this.SNFFequalsRadioButton.isSelected()) {
            this.SNFFtextField.setEnabled(true);
        } else {
            this.SNFFtextField.setEnabled(false);
        }
        this.SNFFtextField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                SearchWindow.this.SNFFtextFieldCaretUpdate(caretEvent);
            }
        });
        this.SNFFpanel.add(this.SNFFtextField);
        this.upperMainPanel.add(this.SNFFpanel);
        this.IFMpanel.setLayout(new GridLayout(0, 1));
        this.IFMpanel.setBorder(new TitledBorder("Identifier"));
        this.IFMallRadioButton.setFont(new Font("Dialog", 0, 12));
        this.IFMallRadioButton.setText("All");
        this.IFMbuttonGroup.add(this.IFMallRadioButton);
        if (this.settings.getIFMState() == 1) {
            this.IFMallRadioButton.setSelected(true);
        } else {
            this.IFMallRadioButton.setSelected(false);
        }
        this.IFMallRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.IFMallRadioButtonActionPerformed(actionEvent);
            }
        });
        this.IFMpanel.add(this.IFMallRadioButton);
        this.IFMequalsRadioButton.setFont(new Font("Dialog", 0, 12));
        this.IFMequalsRadioButton.setText("Equals");
        this.IFMbuttonGroup.add(this.IFMequalsRadioButton);
        if (this.settings.getIFMState() == 2) {
            this.IFMequalsRadioButton.setSelected(true);
        } else {
            this.IFMequalsRadioButton.setSelected(false);
        }
        this.IFMequalsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.IFMequalsRadioButtonActionPerformed(actionEvent);
            }
        });
        this.IFMpanel.add(this.IFMequalsRadioButton);
        this.IFMcontainsRadioButton.setFont(new Font("Dialog", 0, 12));
        this.IFMcontainsRadioButton.setText("Contains");
        this.IFMbuttonGroup.add(this.IFMcontainsRadioButton);
        if (this.settings.getIFMState() == 3) {
            this.IFMcontainsRadioButton.setSelected(true);
        } else {
            this.IFMcontainsRadioButton.setSelected(false);
        }
        this.IFMcontainsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.IFMcontainsRadioButtonActionPerformed(actionEvent);
            }
        });
        this.IFMpanel.add(this.IFMcontainsRadioButton);
        this.IFMtextField.setText(this.settings.getIFMContains());
        if (this.IFMcontainsRadioButton.isSelected() || this.IFMequalsRadioButton.isSelected()) {
            this.IFMtextField.setEnabled(true);
        } else {
            this.IFMtextField.setEnabled(false);
        }
        this.IFMtextField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                SearchWindow.this.IFMtextFieldCaretUpdate(caretEvent);
            }
        });
        this.IFMpanel.add(this.IFMtextField);
        this.upperMainPanel.add(this.IFMpanel);
        this.PDFCpanel.setLayout(new GridLayout(0, 1));
        this.PDFCpanel.setBorder(new TitledBorder("Problem description"));
        this.PDFCallRadioButton.setFont(new Font("Dialog", 0, 12));
        this.PDFCallRadioButton.setText("All");
        this.PDFCbuttonGroup.add(this.PDFCallRadioButton);
        if (this.settings.getPDFCState() == 1) {
            this.PDFCallRadioButton.setSelected(true);
        } else {
            this.PDFCallRadioButton.setSelected(false);
        }
        this.PDFCallRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.PDFCallRadioButtonActionPerformed(actionEvent);
            }
        });
        this.PDFCpanel.add(this.PDFCallRadioButton);
        this.PDFCequalsRadioButton.setFont(new Font("Dialog", 0, 12));
        this.PDFCequalsRadioButton.setText("Equals");
        this.PDFCbuttonGroup.add(this.PDFCequalsRadioButton);
        if (this.settings.getPDFCState() == 2) {
            this.PDFCequalsRadioButton.setSelected(true);
        } else {
            this.PDFCequalsRadioButton.setSelected(false);
        }
        this.PDFCequalsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.PDFCequalsRadioButtonActionPerformed(actionEvent);
            }
        });
        this.PDFCpanel.add(this.PDFCequalsRadioButton);
        this.PDFCcontainsRadioButton.setFont(new Font("Dialog", 0, 12));
        this.PDFCcontainsRadioButton.setText("Contains");
        this.PDFCbuttonGroup.add(this.PDFCcontainsRadioButton);
        if (this.settings.getPDFCState() == 3) {
            this.PDFCcontainsRadioButton.setSelected(true);
        } else {
            this.PDFCcontainsRadioButton.setSelected(false);
        }
        this.PDFCcontainsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.PDFCcontainsRadioButtonActionPerformed(actionEvent);
            }
        });
        this.PDFCpanel.add(this.PDFCcontainsRadioButton);
        this.PDFCtextField.setText(this.settings.getPDFCContains());
        if (this.PDFCcontainsRadioButton.isSelected() || this.PDFCequalsRadioButton.isSelected()) {
            this.PDFCtextField.setEnabled(true);
        } else {
            this.PDFCtextField.setEnabled(false);
        }
        this.PDFCtextField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                SearchWindow.this.PDFCtextFieldCaretUpdate(caretEvent);
            }
        });
        this.PDFCpanel.add(this.PDFCtextField);
        this.upperMainPanel.add(this.PDFCpanel);
        this.priorityPanel.setLayout(new GridLayout(0, 1));
        this.priorityPanel.setBorder(new TitledBorder("Priority"));
        this.priorityLevel0checkBox.setFont(new Font("Dialog", 0, 12));
        this.priorityLevel0checkBox.setText("Level 0");
        if (this.settings.getPriority_0()) {
            this.priorityLevel0checkBox.setSelected(true);
        } else {
            this.priorityLevel0checkBox.setSelected(false);
        }
        this.priorityLevel0checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.priorityLevel0checkBoxActionPerformed(actionEvent);
            }
        });
        this.priorityPanel.add(this.priorityLevel0checkBox);
        this.priorityLevel1checkBox.setFont(new Font("Dialog", 0, 12));
        this.priorityLevel1checkBox.setText("Level 1");
        if (this.settings.getPriority_1()) {
            this.priorityLevel1checkBox.setSelected(true);
        } else {
            this.priorityLevel1checkBox.setSelected(false);
        }
        this.priorityLevel1checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.priorityLevel1checkBoxActionPerformed(actionEvent);
            }
        });
        this.priorityPanel.add(this.priorityLevel1checkBox);
        this.priorityLevel2checkBox.setFont(new Font("Dialog", 0, 12));
        this.priorityLevel2checkBox.setText("Level 2");
        if (this.settings.getPriority_2()) {
            this.priorityLevel2checkBox.setSelected(true);
        } else {
            this.priorityLevel2checkBox.setSelected(false);
        }
        this.priorityLevel2checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.priorityLevel2checkBoxActionPerformed(actionEvent);
            }
        });
        this.priorityPanel.add(this.priorityLevel2checkBox);
        this.priorityLevel3checkBox.setFont(new Font("Dialog", 0, 12));
        this.priorityLevel3checkBox.setText("Level 3");
        if (this.settings.getPriority_3()) {
            this.priorityLevel3checkBox.setSelected(true);
        } else {
            this.priorityLevel3checkBox.setSelected(false);
        }
        this.priorityLevel3checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.priorityLevel3checkBoxActionPerformed(actionEvent);
            }
        });
        this.priorityPanel.add(this.priorityLevel3checkBox);
        this.upperMainPanel.add(this.priorityPanel);
        this.mainPanel.add(this.upperMainPanel);
        this.bottomMainPanel.setLayout(new GridLayout(1, 0));
        this.timestampPanel.setLayout(new GridLayout(4, 1));
        this.timestampPanel.setBorder(new TitledBorder("Time Stamp"));
        this.timestampLabel1.setFont(new Font("Dialog", 0, 12));
        this.timestampLabel1.setText("After :");
        this.timestampPanel.add(this.timestampLabel1);
        this.timestampAfterTextField.setPreferredSize(new Dimension(69, 13));
        this.timestampAfterTextField.setText(this.settings.getTimeStampAfter());
        if (this.settings.isTimeStampEnabled()) {
            this.timestampAfterTextField.setEditable(true);
        } else {
            this.timestampAfterTextField.setEditable(false);
        }
        this.timestampAfterTextField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                SearchWindow.this.timestampAfterTextFieldCaretUpdate(caretEvent);
            }
        });
        this.timestampPanel.add(this.timestampAfterTextField);
        this.timestampLabel2.setFont(new Font("Dialog", 0, 12));
        this.timestampLabel2.setText("Before :");
        this.timestampPanel.add(this.timestampLabel2);
        this.timestampBeforeTextField.setText(this.settings.getTimeStampBefore());
        if (this.settings.isTimeStampEnabled()) {
            this.timestampBeforeTextField.setEditable(true);
        } else {
            this.timestampBeforeTextField.setEditable(false);
        }
        this.timestampBeforeTextField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                SearchWindow.this.timestampBeforeTextFieldCaretUpdate(caretEvent);
            }
        });
        this.timestampPanel.add(this.timestampBeforeTextField);
        this.bottomMainPanel.add(this.timestampPanel);
        this.statusPanel.setLayout(new GridLayout(5, 0));
        this.statusPanel.setBorder(new TitledBorder("Status"));
        this.statusActiveCheckBox.setFont(new Font("Dialog", 0, 12));
        this.statusActiveCheckBox.setText("Active");
        this.statusActiveCheckBox.setSelected(this.settings.getStatusActive());
        this.statusActiveCheckBox.setEnabled(this.settings.isStatusActiveEnabled());
        this.statusActiveCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.statusActiveCheckBoxActionPerformed(actionEvent);
            }
        });
        this.statusPanel.add(this.statusActiveCheckBox);
        this.statusAcknowledgedCheckBox.setFont(new Font("Dialog", 0, 12));
        this.statusAcknowledgedCheckBox.setText("Acknowledged");
        this.statusAcknowledgedCheckBox.setSelected(this.settings.getStatusAcknowledged());
        this.statusAcknowledgedCheckBox.setEnabled(this.settings.isStatusAcknowledgedEnabled());
        this.statusAcknowledgedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.statusAcknowledgedCheckBoxActionPerformed(actionEvent);
            }
        });
        this.statusPanel.add(this.statusAcknowledgedCheckBox);
        this.statusHighlightedCheckBox.setFont(new Font("Dialog", 0, 12));
        this.statusHighlightedCheckBox.setText("Highlighted");
        this.statusHighlightedCheckBox.setSelected(this.settings.getStatusHighlighted());
        this.statusHighlightedCheckBox.setEnabled(this.settings.isStatusHighlightedEnabled());
        this.statusHighlightedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.statusHighlightedCheckBoxActionPerformed(actionEvent);
            }
        });
        this.statusPanel.add(this.statusHighlightedCheckBox);
        this.statusMaskedCheckBox.setFont(new Font("Dialog", 0, 12));
        this.statusMaskedCheckBox.setText("Masked");
        this.statusMaskedCheckBox.setSelected(this.settings.getStatusMasked());
        this.statusMaskedCheckBox.setEnabled(this.settings.isStatusMaskedEnabled());
        this.statusMaskedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.statusMaskedCheckBoxActionPerformed(actionEvent);
            }
        });
        this.statusPanel.add(this.statusMaskedCheckBox);
        this.statusTerminatedCheckBox.setFont(new Font("Dialog", 0, 12));
        this.statusTerminatedCheckBox.setText("Terminated");
        this.statusTerminatedCheckBox.setSelected(this.settings.getStatusTerminated());
        this.statusTerminatedCheckBox.setEnabled(this.settings.isStatusTerminatedEnabled());
        this.statusTerminatedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.statusTerminatedCheckBoxActionPerformed(actionEvent);
            }
        });
        this.statusPanel.add(this.statusTerminatedCheckBox);
        this.bottomMainPanel.add(this.statusPanel);
        this.sortOptionPanel.setLayout(new GridLayout(4, 0));
        this.sortOptionPanel.setBorder(new TitledBorder("Sort option"));
        this.sortByTimeRadioButton.setFont(new Font("Dialog", 0, 12));
        this.sortByTimeRadioButton.setText("by time");
        this.sortOptionButtonGroup.add(this.sortByTimeRadioButton);
        if (this.settings.getSortState() == 1) {
            this.sortByTimeRadioButton.setSelected(true);
        } else {
            this.sortByTimeRadioButton.setSelected(false);
        }
        this.sortByTimeRadioButton.setEnabled(this.settings.isSortByTimeEnabled());
        this.sortByTimeRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.sortByTimeRadioButtonActionPerformed(actionEvent);
            }
        });
        this.sortOptionPanel.add(this.sortByTimeRadioButton);
        this.sortByPriorityRadioButton.setFont(new Font("Dialog", 0, 12));
        this.sortByPriorityRadioButton.setText("by priority");
        this.sortOptionButtonGroup.add(this.sortByPriorityRadioButton);
        if (this.settings.getSortState() == 2) {
            this.sortByPriorityRadioButton.setSelected(true);
        } else {
            this.sortByPriorityRadioButton.setSelected(false);
        }
        this.sortByPriorityRadioButton.setEnabled(this.settings.isSortByPriorityEnabled());
        this.sortByPriorityRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.sortByPriorityRadioButtonActionPerformed(actionEvent);
            }
        });
        this.sortOptionPanel.add(this.sortByPriorityRadioButton);
        this.sortGroupNTRadioButton.setFont(new Font("Dialog", 0, 12));
        this.sortGroupNTRadioButton.setText("group N&T");
        this.sortOptionButtonGroup.add(this.sortGroupNTRadioButton);
        if (this.settings.getSortState() == 3) {
            this.sortGroupNTRadioButton.setSelected(true);
        } else {
            this.sortGroupNTRadioButton.setSelected(false);
        }
        this.sortGroupNTRadioButton.setEnabled(this.settings.isSortGroupNTEnabled());
        this.sortGroupNTRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.sortGroupNTRadioButtonActionPerformed(actionEvent);
            }
        });
        this.sortOptionPanel.add(this.sortGroupNTRadioButton);
        this.sortGroupNTbyPriorityRadioButton.setFont(new Font("Dialog", 0, 12));
        this.sortGroupNTbyPriorityRadioButton.setText("group N&T by prior.");
        this.sortOptionButtonGroup.add(this.sortGroupNTbyPriorityRadioButton);
        if (this.settings.getSortState() == 4) {
            this.sortGroupNTbyPriorityRadioButton.setSelected(true);
        } else {
            this.sortGroupNTbyPriorityRadioButton.setSelected(false);
        }
        this.sortGroupNTbyPriorityRadioButton.setEnabled(this.settings.isSortGroupNTByPriorityEnabled());
        this.sortGroupNTbyPriorityRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.sortGroupNTbyPriorityRadioButtonActionPerformed(actionEvent);
            }
        });
        this.sortOptionPanel.add(this.sortGroupNTbyPriorityRadioButton);
        this.bottomMainPanel.add(this.sortOptionPanel);
        this.hostNamePanel.setLayout(new GridLayout(4, 1));
        this.hostNamePanel.setBorder(new TitledBorder("Host name"));
        this.hostNameAllRadioButton.setFont(new Font("Dialog", 0, 12));
        this.hostNameAllRadioButton.setText("All");
        this.hostNameButtonGroup.add(this.hostNameAllRadioButton);
        if (this.settings.getCAPHostNameState() == 1) {
            this.hostNameAllRadioButton.setSelected(true);
        } else {
            this.hostNameAllRadioButton.setSelected(false);
        }
        this.hostNameAllRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.hostNameAllRadioButtonActionPerformed(actionEvent);
            }
        });
        this.hostNamePanel.add(this.hostNameAllRadioButton);
        this.hostNameEqualsRadioButton.setFont(new Font("Dialog", 0, 12));
        this.hostNameEqualsRadioButton.setText("Equals");
        this.hostNameButtonGroup.add(this.hostNameEqualsRadioButton);
        if (this.settings.getCAPHostNameState() == 2) {
            this.hostNameEqualsRadioButton.setSelected(true);
        } else {
            this.hostNameEqualsRadioButton.setSelected(false);
        }
        this.hostNameEqualsRadioButton.setEnabled(this.settings.isCAPHostNameEqualsEnabled());
        this.hostNameEqualsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.hostNameEqualsRadioButtonActionPerformed(actionEvent);
            }
        });
        this.hostNamePanel.add(this.hostNameEqualsRadioButton);
        this.hostNameTextField.setText(this.settings.getCAPHostNameEquals());
        if (this.hostNameEqualsRadioButton.isSelected()) {
            this.hostNameTextField.setEnabled(true);
        } else {
            this.hostNameTextField.setEnabled(false);
        }
        this.hostNameTextField.setEnabled(this.settings.isCAPHostNameEqualsEnabled() && this.hostNameEqualsRadioButton.isEnabled() && this.hostNameEqualsRadioButton.isSelected());
        this.hostNameTextField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                SearchWindow.this.hostNameTextFieldCaretUpdate(caretEvent);
            }
        });
        this.hostNamePanel.add(this.hostNameTextField);
        this.bottomMainPanel.add(this.hostNamePanel);
        this.mainPanel.add(this.bottomMainPanel);
        this.add(this.mainPanel, "North");
    }

    private void jButton2ActionPerformed(ActionEvent actionEvent) {
        AlarmNodeManager alarmNodeManager = AlarmContainer.getDefault().getAlarmNodeManager("ACTIVE_LIST_LISTENER");
        for (String string : alarmNodeManager.getMap().keySet()) {
            AlarmBean alarmBean = alarmNodeManager.getAlarm(string);
            SearchProxyBuffer.getDefault().onSearchAlarm(alarmBean.getCommentedAlarm().getAlarm());
        }
        SearchProxyBuffer.getDefault().searchFinished();
    }

    private void searchButtonActionPerformed(ActionEvent actionEvent) {
        Object object;
        ProgressDialog progressDialog = new ProgressDialog();
        SearchProxyBuffer.getDefault().close();
        SearchProxyBuffer.getDefault().disable();
        SearchProxyBuffer.getDefault().registerAlarmSearchListener(progressDialog);
        SearchProxyBuffer.getDefault().registerAlarmSearchListener(AlarmContainer.getDefault());
        AlarmContainer.getDefault().clearSearchList();
        try {
            object = AlarmSelectionHandlerFactory.getHandler();
            object.search(this.selection, 10, (AlarmSearchListener)AlarmContainer.getDefault());
        }
        catch (LaserTimeOutException laserTimeOutException) {
            this.logger.debug((Object)"LaserTimeOutException");
            laserTimeOutException.printStackTrace();
        }
        catch (LaserException laserException) {
            this.logger.debug((Object)"LaserException");
            laserException.printStackTrace();
        }
        object = NbBundle.getMessage(ActiveListExplorerPanel.class, (String)"LBL_Search_list_component_name");
        AlarmNodeManager alarmNodeManager = AlarmContainer.getDefault().getAlarmNodeManager("SEARCH_LISTENER_KEY");
        String[] stringArray = Constants.getColumnsToDisplayInSearch();
        ActiveListExplorerPanel activeListExplorerPanel = new ActiveListExplorerPanel(alarmNodeManager, (String)object, stringArray);
        activeListExplorerPanel.open();
        progressDialog.open();
        SearchProxyBuffer.getDefault().enable();
        this.close();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.close();
    }

    private void formComponentShown(ComponentEvent componentEvent) {
        this.updateBorderNames();
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        this.doSwitch();
    }

    private void hostNameTextFieldCaretUpdate(CaretEvent caretEvent) {
        this.settings.setCAPHostNameEquals(this.hostNameTextField.getText());
    }

    private void hostNameEqualsRadioButtonActionPerformed(ActionEvent actionEvent) {
        if (this.hostNameEqualsRadioButton.isSelected()) {
            this.settings.setCAPHostNameState(2);
            this.hostNameTextField.setEnabled(true);
        }
    }

    private void hostNameAllRadioButtonActionPerformed(ActionEvent actionEvent) {
        if (this.hostNameAllRadioButton.isSelected()) {
            this.settings.setCAPHostNameState(1);
            this.hostNameTextField.setEnabled(false);
        }
    }

    private void sortGroupNTbyPriorityRadioButtonActionPerformed(ActionEvent actionEvent) {
        if (this.sortGroupNTbyPriorityRadioButton.isSelected()) {
            this.settings.setSortState(4);
        }
    }

    private void sortGroupNTRadioButtonActionPerformed(ActionEvent actionEvent) {
        if (this.sortGroupNTRadioButton.isSelected()) {
            this.settings.setSortState(3);
        }
    }

    private void sortByPriorityRadioButtonActionPerformed(ActionEvent actionEvent) {
        if (this.sortByPriorityRadioButton.isSelected()) {
            this.settings.setSortState(2);
        }
    }

    private void sortByTimeRadioButtonActionPerformed(ActionEvent actionEvent) {
        if (this.sortByTimeRadioButton.isSelected()) {
            this.settings.setSortState(1);
        }
    }

    private void statusTerminatedCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.settings.setStatusTerminated(this.statusTerminatedCheckBox.isSelected());
    }

    private void statusMaskedCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.settings.setStatusMasked(this.statusMaskedCheckBox.isSelected());
    }

    private void statusHighlightedCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.settings.setStatusHighlighted(this.statusHighlightedCheckBox.isSelected());
    }

    private void statusAcknowledgedCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.settings.setStatusAcknowledged(this.statusAcknowledgedCheckBox.isSelected());
    }

    private void statusActiveCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.settings.setStatusActive(this.statusActiveCheckBox.isSelected());
    }

    private void timestampBeforeTextFieldCaretUpdate(CaretEvent caretEvent) {
        this.settings.setTimeStampBefore(this.timestampBeforeTextField.getText());
    }

    private void timestampAfterTextFieldCaretUpdate(CaretEvent caretEvent) {
        this.settings.setTimeStampAfter(this.timestampAfterTextField.getText());
    }

    private void priorityLevel3checkBoxActionPerformed(ActionEvent actionEvent) {
        this.settings.setPriority_3(this.priorityLevel3checkBox.isSelected());
    }

    private void priorityLevel2checkBoxActionPerformed(ActionEvent actionEvent) {
        this.settings.setPriority_2(this.priorityLevel2checkBox.isSelected());
    }

    private void priorityLevel1checkBoxActionPerformed(ActionEvent actionEvent) {
        this.settings.setPriority_1(this.priorityLevel1checkBox.isSelected());
    }

    private void priorityLevel0checkBoxActionPerformed(ActionEvent actionEvent) {
        this.settings.setPriority_0(this.priorityLevel0checkBox.isSelected());
    }

    private void PDFCtextFieldCaretUpdate(CaretEvent caretEvent) {
        this.settings.setPDFCContains(this.PDFCtextField.getText());
    }

    private void IFMtextFieldCaretUpdate(CaretEvent caretEvent) {
        this.settings.setIFMContains(this.IFMtextField.getText());
    }

    private void SNFFtextFieldCaretUpdate(CaretEvent caretEvent) {
        this.settings.setSNFFContains(this.SNFFtextField.getText());
    }

    private void PDFCcontainsRadioButtonActionPerformed(ActionEvent actionEvent) {
        if (this.PDFCcontainsRadioButton.isSelected()) {
            this.settings.setPDFCState(3);
            this.PDFCtextField.setEnabled(true);
        }
    }

    private void IFMcontainsRadioButtonActionPerformed(ActionEvent actionEvent) {
        if (this.IFMcontainsRadioButton.isSelected()) {
            this.settings.setIFMState(3);
            this.IFMtextField.setEnabled(true);
        }
    }

    private void SNFFcontainsRadioButtonActionPerformed(ActionEvent actionEvent) {
        if (this.SNFFcontainsRadioButton.isSelected()) {
            this.settings.setSNFFState(3);
            this.SNFFtextField.setEnabled(true);
        }
    }

    private void PDFCequalsRadioButtonActionPerformed(ActionEvent actionEvent) {
        if (this.PDFCequalsRadioButton.isSelected()) {
            this.settings.setPDFCState(2);
            this.PDFCtextField.setEnabled(true);
        }
    }

    private void IFMequalsRadioButtonActionPerformed(ActionEvent actionEvent) {
        if (this.IFMequalsRadioButton.isSelected()) {
            this.settings.setIFMState(2);
            this.IFMtextField.setEnabled(true);
        }
    }

    private void SNFFequalsRadioButtonActionPerformed(ActionEvent actionEvent) {
        if (this.SNFFequalsRadioButton.isSelected()) {
            this.settings.setSNFFState(2);
            this.SNFFtextField.setEnabled(true);
        }
    }

    private void PDFCallRadioButtonActionPerformed(ActionEvent actionEvent) {
        if (this.PDFCallRadioButton.isSelected()) {
            this.settings.setPDFCState(1);
            this.PDFCtextField.setEnabled(false);
        }
    }

    private void IFMallRadioButtonActionPerformed(ActionEvent actionEvent) {
        if (this.IFMallRadioButton.isSelected()) {
            this.settings.setIFMState(1);
            this.IFMtextField.setEnabled(false);
        }
    }

    private void SNFFallRadioButtonActionPerformed(ActionEvent actionEvent) {
        if (this.SNFFallRadioButton.isSelected()) {
            this.settings.setSNFFState(1);
            this.SNFFtextField.setEnabled(false);
        }
    }

    private void updateBorderNames() {
        if (this.settings.getSwitchMode() == SearchWindowSettings.SWITCH_MODE_FF_FM_FC) {
            this.SNFFpanel.setBorder(new TitledBorder(NbBundle.getMessage(SearchWindow.class, (String)"LBL_border_system_name")));
            this.IFMpanel.setBorder(new TitledBorder(NbBundle.getMessage(SearchWindow.class, (String)"LBL_border_identifier")));
            this.PDFCpanel.setBorder(new TitledBorder(NbBundle.getMessage(SearchWindow.class, (String)"LBL_border_problem_description")));
        } else {
            this.SNFFpanel.setBorder(new TitledBorder(NbBundle.getMessage(SearchWindow.class, (String)"LBL_border_FF")));
            this.IFMpanel.setBorder(new TitledBorder(NbBundle.getMessage(SearchWindow.class, (String)"LBL_border_FM")));
            this.PDFCpanel.setBorder(new TitledBorder(NbBundle.getMessage(SearchWindow.class, (String)"LBL_border_FC")));
        }
    }

    private void doSwitch() {
        if (this.settings.getSwitchMode() == SearchWindowSettings.SWITCH_MODE_FF_FM_FC) {
            this.settings.setSwitchMode(SearchWindowSettings.SWITCH_MODE_SN_I_PD);
        } else {
            this.settings.setSwitchMode(SearchWindowSettings.SWITCH_MODE_FF_FM_FC);
        }
        this.updateBorderNames();
    }
}

