/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows.login;

import cern.laser.client.LaserConnectionException;
import cern.laser.client.LaserException;
import cern.laser.client.services.selection.AlarmSelectionHandler;
import cern.laser.client.services.selection.AlarmSelectionListener;
import cern.laser.client.services.selection.Selection;
import cern.laser.console.Behaviour;
import cern.laser.console.Configuration;
import cern.laser.console.LaserConfigurationNotFoundException;
import cern.laser.console.LaserConsoleException;
import cern.laser.console.LaserUserNotFoundException;
import cern.laser.console.User;
import cern.laser.console.UserHandler;
import cern.laser.guiplatform.alarms.AlarmContainer;
import cern.laser.guiplatform.alarms.AlarmNodeManager;
import cern.laser.guiplatform.alarms.AlarmSelectionHandlerFactory;
import cern.laser.guiplatform.category.CategoriesPreLoader;
import cern.laser.guiplatform.logging.TraceLogger;
import cern.laser.guiplatform.user.UserHandlerFactory;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.util.ProxyBuffer;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import cern.laser.guiplatform.windows.ActiveListExplorerPanel;
import cern.laser.guiplatform.windows.AlarmStatisticInfoPanel;
import cern.laser.guiplatform.windows.InstantFaultExplorer;
import cern.laser.guiplatform.windows.configuration.ConsoleConfigurationWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.IntrospectionException;
import java.net.URL;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class AlarmConsoleLoginWindow
extends TopComponent {
    private JPanel butonsPanel;
    private JButton cancelButton;
    private JButton guestButton;
    private JLabel iconLabel;
    private JPanel iconPanel;
    private JPanel labelPanel;
    private JButton loginButton;
    private JLabel loginNameLabel;
    private JTextField loginNameTextField;
    private JPanel mainPanel;
    private JLabel passwordLabel;
    private JPasswordField passwordPasswordField;
    private JPanel southPanel;
    private JPanel textFieldPanel;
    private JLabel titleLabel;
    private static Logger logger = LogFactory.getLogger(AlarmConsoleLoginWindow.class.getName());

    public AlarmConsoleLoginWindow() {
        this.initComponents();
        this.postInitComponents();
    }

    private void initComponents() {
        this.labelPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.mainPanel = new JPanel();
        this.textFieldPanel = new JPanel();
        this.loginNameLabel = new JLabel();
        this.loginNameTextField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordPasswordField = new JPasswordField();
        this.iconPanel = new JPanel();
        this.iconLabel = new JLabel();
        this.southPanel = new JPanel();
        this.butonsPanel = new JPanel();
        this.loginButton = new JButton();
        this.cancelButton = new JButton();
        this.guestButton = new JButton();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(415, 300));
        this.labelPanel.setLayout(new BorderLayout());
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.labelPanel.add((Component)this.titleLabel, "Center");
        this.add(this.labelPanel, "North");
        this.mainPanel.setLayout(new BorderLayout());
        this.textFieldPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 15, 0, 12);
        this.textFieldPanel.add((Component)this.loginNameLabel, gridBagConstraints);
        this.loginNameTextField.setPreferredSize(new Dimension(100, 22));
        this.loginNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                AlarmConsoleLoginWindow.this.loginNameTextFieldKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.textFieldPanel.add((Component)this.loginNameTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 14, 0, 28);
        this.textFieldPanel.add((Component)this.passwordLabel, gridBagConstraints);
        this.passwordPasswordField.setPreferredSize(new Dimension(100, 22));
        this.passwordPasswordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                AlarmConsoleLoginWindow.this.passwordPasswordFieldKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.textFieldPanel.add((Component)this.passwordPasswordField, gridBagConstraints);
        this.mainPanel.add((Component)this.textFieldPanel, "Center");
        this.iconPanel.setLayout(new GridBagLayout());
        this.iconLabel.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/cern/laser/guiplatform/images/marvmad.gif")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 25, 0, 25);
        this.iconPanel.add((Component)this.iconLabel, gridBagConstraints);
        this.mainPanel.add((Component)this.iconPanel, "East");
        this.add(this.mainPanel, "Center");
        this.southPanel.setLayout(new BorderLayout());
        this.loginButton.setPreferredSize(new Dimension(80, 27));
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AlarmConsoleLoginWindow.this.loginButtonActionPerformed(actionEvent);
            }
        });
        this.butonsPanel.add(this.loginButton);
        this.cancelButton.setPreferredSize(new Dimension(80, 29));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AlarmConsoleLoginWindow.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.butonsPanel.add(this.cancelButton);
        this.guestButton.setText("Login as a guest");
        this.guestButton.setToolTipText("Guest facility. Try out a LASER!");
        this.guestButton.setPreferredSize(new Dimension(137, 29));
        this.guestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AlarmConsoleLoginWindow.this.guestButtonActionPerformed(actionEvent);
            }
        });
        this.butonsPanel.add(this.guestButton);
        this.southPanel.add((Component)this.butonsPanel, "Center");
        this.add(this.southPanel, "South");
    }

    private void guestButtonActionPerformed(ActionEvent actionEvent) {
        this.loginNameTextField.setText("GUEST");
        this.passwordPasswordField.setText("guest");
        this.login();
    }

    private void passwordPasswordFieldKeyReleased(KeyEvent keyEvent) {
        this.enableOrDisableLoginButton();
    }

    private void loginNameTextFieldKeyReleased(KeyEvent keyEvent) {
        this.enableOrDisableLoginButton();
    }

    private void enableOrDisableLoginButton() {
        if (this.loginNameTextField.getText().length() > 0 && this.passwordPasswordField.getPassword().length > 0) {
            this.loginButton.setEnabled(true);
            this.getRootPane().setDefaultButton(this.loginButton);
        } else {
            this.loginButton.setEnabled(false);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        TraceLogger.log("User press cancel button !!");
        this.close();
    }

    private void loginButtonActionPerformed(ActionEvent actionEvent) {
        this.login();
    }

    private void postInitComponents() {
        this.setCloseOperation(0);
        this.putClientProperty("PersistenceType", "Never");
        this.putClientProperty("TabPolicy", "HideWhenAlone");
        this.titleLabel.setText(NbBundle.getMessage(AlarmConsoleLoginWindow.class, (String)"LOGIN_window_title"));
        this.loginButton.setText(NbBundle.getMessage(AlarmConsoleLoginWindow.class, (String)"LOGIN_string"));
        this.loginButton.setEnabled(false);
        this.cancelButton.setText(NbBundle.getMessage(AlarmConsoleLoginWindow.class, (String)"CANCEL_string"));
        this.passwordLabel.setText(NbBundle.getMessage(AlarmConsoleLoginWindow.class, (String)"PASSWORD_string"));
        this.loginNameLabel.setText(NbBundle.getMessage(AlarmConsoleLoginWindow.class, (String)"LOGIN_NAME_string"));
        this.setName(NbBundle.getMessage(AlarmConsoleLoginWindow.class, (String)"LOGIN_window_name"));
        WindowManager.getDefault().getMainWindow().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                logger.debug((Object)" windows is being closed ");
                AcWindowManager.closeAllTopComponents();
                try {
                    AlarmSelectionHandler alarmSelectionHandler = AlarmSelectionHandlerFactory.getHandler();
                    alarmSelectionHandler.resetSelection();
                }
                catch (LaserException laserException) {
                    logger.error((Object)laserException.getMessage(), (Throwable)laserException);
                    logger.error((Object)laserException.getRootCause().getMessage(), laserException.getRootCause());
                }
                ProxyBuffer.getDefault().disable();
                ProxyBuffer.getDefault().close();
                AlarmContainer.getDefault().clearContainer();
                logger.debug((Object)"AlarmContainer was cleared!!");
                AppRegister.getInstance().unregisterUser();
                AppRegister.getInstance().cleanRegister();
            }
        });
    }

    protected void componentClosed() {
        super.componentClosed();
    }

    public boolean canClose(Workspace workspace, boolean bl) {
        return super.canClose(workspace, bl);
    }

    private void login() {
        Map map;
        Object object;
        TraceLogger.log("User \"" + this.loginNameTextField.getText() + "\" is trying to login");
        logger.debug((Object)("User \"" + this.loginNameTextField.getText() + "\" is trying to login"));
        System.out.println("user login - system out");
        logger.debug((Object)("marek: (logger) " + System.getProperty("log4j.configuration")));
        TraceLogger.log("marek: (trace logger) " + System.getProperty("log4j.configuration"));
        String string = this.loginNameTextField.getText();
        char[] cArray = this.passwordPasswordField.getPassword();
        String string2 = new String(cArray);
        boolean bl = false;
        boolean bl2 = false;
        UserHandler userHandler = null;
        User user = null;
        Configuration configuration = null;
        String string3 = null;
        CategoriesPreLoader.getInstance();
        try {
            userHandler = UserHandlerFactory.getHandler();
            logger.debug((Object)"after UserHandlerFactory");
            user = userHandler.getUser(string);
            logger.debug((Object)"after getUser");
            if (user == null) {
                throw new LaserConnectionException("cannot get User");
            }
            if (user.getName() != "GUEST" && !user.getPassword().equals(string2)) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(AlarmConsoleLoginWindow.class, (String)"USER_PASSWORD_NOT_VALID_message", (Object)string), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                this.loginNameTextField.setText("");
                this.passwordPasswordField.setText("");
                this.loginButton.setEnabled(false);
                return;
            }
            try {
                if (user.getConfiguration("NOT SAVED DEFAULT CONFIGURATION") != null) {
                    user.removeConfiguration("NOT SAVED DEFAULT CONFIGURATION");
                }
            }
            catch (LaserConfigurationNotFoundException laserConfigurationNotFoundException) {
                logger.warn((Object)"deleting DEFAULT_CONFIGURATION_NAME NOT SAVED DEFAULT CONFIGURATION");
                System.err.println("### (LaserConfigurationNotFoundException):Deleting DEFAULT_CONFIGURATION_NAME NOT SAVED DEFAULT CONFIGURATION");
            }
            catch (LaserConnectionException laserConnectionException) {
                logger.warn((Object)"deleting DEFAULT_CONFIGURATION_NAME NOT SAVED DEFAULT CONFIGURATION");
                System.err.println("### (LaserConnectionException)Deleting DEFAULT_CONFIGURATION_NAME NOT SAVED DEFAULT CONFIGURATION");
            }
            configuration = user.getDefaultConfiguration();
            if (configuration == null) {
                bl = true;
                logger.debug((Object)("user: " + user.getName() + " does not have default configuration"));
                configuration = user.createConfiguration("NOT SAVED DEFAULT CONFIGURATION");
            }
            string3 = configuration.getName();
        }
        catch (LaserUserNotFoundException laserUserNotFoundException) {
            System.out.println("### login exception: LaserUserNotFoundException");
            this.close();
            logger.warn((Object)("User " + string + " does not exists."));
            TraceLogger.log("User " + this.loginNameTextField.getText() + " login failed ");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(AlarmConsoleLoginWindow.class, (String)"USER_DOES_NOT_EXIST_message", (Object)string), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            this.loginNameTextField.setText("");
            this.passwordPasswordField.setText("");
            this.loginButton.setEnabled(false);
            return;
        }
        catch (LaserConnectionException laserConnectionException) {
            System.out.println("### login exception: LaserConnectionException");
            this.close();
            TraceLogger.log("User " + this.loginNameTextField.getText() + " login failed ");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Connection Problem", 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            this.loginNameTextField.setText("");
            this.passwordPasswordField.setText("");
            this.loginButton.setEnabled(false);
            return;
        }
        catch (LaserConsoleException laserConsoleException) {
            System.out.println("### login exception: LaserConsoleException");
            this.close();
            logger.error((Object)laserConsoleException.getMessage(), (Throwable)laserConsoleException);
            logger.error((Object)laserConsoleException.getRootCause().getMessage(), laserConsoleException.getRootCause());
            try {
                if (user == null) {
                    throw new LaserConsoleException("user is null");
                }
                bl = true;
                configuration = user.createConfiguration("NOT SAVED DEFAULT CONFIGURATION");
                string3 = configuration.getName();
                bl2 = true;
            }
            catch (LaserConsoleException laserConsoleException2) {
                logger.error((Object)laserConsoleException.getMessage(), (Throwable)laserConsoleException);
                logger.error((Object)laserConsoleException.getRootCause().getMessage(), laserConsoleException.getRootCause());
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Connection problem. Try later.", 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                this.loginNameTextField.setText("");
                this.passwordPasswordField.setText("");
                this.loginButton.setEnabled(false);
                return;
            }
        }
        this.close();
        try {
            logger.debug((Object)"selection: ");
            logger.debug((Object)configuration.getSelection());
            object = AlarmSelectionHandlerFactory.getHandler();
            logger.debug((Object)"selecting ........... ");
            ProxyBuffer.getDefault().registerAlarmSelectionListener(AlarmContainer.getDefault());
            map = object.select(configuration.getSelection(), (AlarmSelectionListener)ProxyBuffer.getDefault());
            logger.debug((Object)("selected " + map.size() + " alarms "));
            AlarmContainer.getDefault().initContainer(map, configuration);
            AppRegister.getInstance().registerLoadedConfiguration(configuration);
            String[] stringArray = AppRegister.getInstance().getBehaviour().getColumnsToDisplay();
            AlarmNodeManager alarmNodeManager = AlarmContainer.getDefault().getAlarmNodeManager("ACTIVE_LIST_LISTENER");
            ActiveListExplorerPanel activeListExplorerPanel = new ActiveListExplorerPanel(alarmNodeManager, NbBundle.getMessage(ActiveListExplorerPanel.class, (String)"LBL_Active_list_component_name"), false, false, stringArray);
            AppRegister.getInstance().registerActiveListExplorerPanel(activeListExplorerPanel);
            Behaviour behaviour = AppRegister.getInstance().getBehaviour();
            Selection selection = AppRegister.getInstance().getSelection();
            boolean bl3 = selection.getReducedMaskedSelection();
            AlarmStatisticInfoPanel alarmStatisticInfoPanel = new AlarmStatisticInfoPanel(string3, behaviour, bl3);
            AlarmContainer.getDefault().attach("this_key_has_to_be_changed", alarmStatisticInfoPanel);
            AlarmContainer.getDefault().addAlarmSelectionOnExceptionListener(alarmStatisticInfoPanel);
            activeListExplorerPanel.add(alarmStatisticInfoPanel, "South", -1);
            URL uRL = ((Object)((Object)this)).getClass().getClassLoader().getResource("cern/laser/guiplatform/images/spider.gif");
            AcWindowManager.openTopComponent((TopComponent)activeListExplorerPanel, "alarmlist", 1, 10, uRL);
            InstantFaultExplorer instantFaultExplorer = null;
            AlarmNodeManager alarmNodeManager2 = AlarmContainer.getDefault().getAlarmNodeManager("INSTANT_LIST_LISTENER");
            instantFaultExplorer = new InstantFaultExplorer(alarmNodeManager2, stringArray);
            AcWindowManager.openInMode("instantlist", (TopComponent)instantFaultExplorer);
            AppRegister.getInstance().registerUser(user);
            ProxyBuffer.getDefault().enable();
            bl = true;
            if (bl) {
                final ConsoleConfigurationWindow consoleConfigurationWindow = new ConsoleConfigurationWindow(user, configuration);
                consoleConfigurationWindow.open();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ((ConsoleConfigurationWindow)consoleConfigurationWindow).loadAllCategoriesInTreeExplorer();
                        }
                        catch (IntrospectionException introspectionException) {
                            logger.error((Object)introspectionException.getMessage(), (Throwable)introspectionException);
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Unable to create configuration window", 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            logger.error((Object)cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Unable to create configuration window", 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        }
                    }
                };
                EventQueue.invokeLater(runnable);
                NotifyDescriptor.Message message = bl2 ? new NotifyDescriptor.Message((Object)"Default configuration took too long and timed out\nPlease reduce your default selection or request an alternative, reduced config", 1) : (!AppRegister.getInstance().isGuestMode() ? new NotifyDescriptor.Message((Object)("User " + string + " does not have default configuraiton.\n" + "Please create default configuration, save it, and press Apply button"), 1) : new NotifyDescriptor.Message((Object)"Welcome in the LASER Alarm Console. You are in a Guest mode.\nTo check the system please load or create a configuration and press Apply button.", 1));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        }
        catch (LaserConsoleException laserConsoleException) {
            this.close();
            logger.error((Object)laserConsoleException.getMessage(), (Throwable)laserConsoleException);
            logger.error((Object)laserConsoleException.getRootCause().getMessage(), laserConsoleException.getRootCause());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Selection problem", 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        catch (LaserException laserException) {
            this.close();
            logger.error((Object)laserException.getMessage(), (Throwable)laserException);
            logger.error((Object)laserException.getRootCause().getMessage(), laserException.getRootCause());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(AlarmConsoleLoginWindow.class, (String)"LASER_EXCEPTION_SELECT_message"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        AcWindowManager.activateDefaultWorkspace();
        TraceLogger.log("User " + this.loginNameTextField.getText() + " successfully logged ");
        AcWindowManager.setStatusText(NbBundle.getMessage(AlarmConsoleLoginWindow.class, (String)"USER_SUCCESSFULLY_LOGGED_message", (Object)(string + " ")));
        object = NbBundle.getMessage(ActiveListExplorerPanel.class, (String)"LBL_Active_list_component_name");
        map = AppRegister.getInstance().getBehaviour();
        AcWindowManager.setTableColumns((String)object, map.getColumnsToDisplay());
    }
}

