/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows.filter;

import cern.laser.client.LaserException;
import cern.laser.client.services.selection.Filter;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import cern.laser.guiplatform.windows.filter.CreatedFiltersExplorer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.IntrospectionException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import org.apache.log4j.Logger;

public class SingleFilterItem
extends JPanel {
    private JButton addButton;
    private JComboBox name;
    private JLabel nameLabel;
    private JComboBox operator;
    private JLabel operatorLabel;
    private JTextField value;
    private JLabel valueLabel;
    private String oldName = "";
    private String oldOperator = "";
    private String oldValue = "";
    private boolean isInUpdateMode = false;
    static final Logger logger = LogFactory.getLogger(SingleFilterItem.class.getName());
    private CreatedFiltersExplorer filterExplorer = null;

    public SingleFilterItem() {
        this.initComponents();
        this.initializeComponents();
        this.postInit();
    }

    private void initComponents() {
        this.name = new JComboBox();
        this.operator = new JComboBox();
        this.value = new JTextField();
        this.nameLabel = new JLabel();
        this.operatorLabel = new JLabel();
        this.valueLabel = new JLabel();
        this.addButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EtchedBorder());
        this.setPreferredSize(new Dimension(450, 110));
        this.name.setEditable(true);
        this.name.setPreferredSize(new Dimension(140, 26));
        this.name.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SingleFilterItem.this.nameActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 2, 6, 6);
        this.add((Component)this.name, gridBagConstraints);
        this.operator.setPreferredSize(new Dimension(140, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 2, 6, 6);
        this.add((Component)this.operator, gridBagConstraints);
        this.value.setPreferredSize(new Dimension(140, 26));
        this.value.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                SingleFilterItem.this.valueKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 2, 6, 2);
        this.add((Component)this.value, gridBagConstraints);
        this.nameLabel.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 0, 2, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.operatorLabel.setText("Operator");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 0, 2, 0);
        this.add((Component)this.operatorLabel, gridBagConstraints);
        this.valueLabel.setText("Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 0, 2, 0);
        this.add((Component)this.valueLabel, gridBagConstraints);
        this.addButton.setText("Add Filter");
        this.addButton.setPreferredSize(new Dimension(105, 30));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SingleFilterItem.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 6, 6, 6);
        this.add((Component)this.addButton, gridBagConstraints);
    }

    private void valueKeyReleased(KeyEvent keyEvent) {
        if (this.enableAddButton()) {
            this.addButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
        }
    }

    private void nameKeyReleased(KeyEvent keyEvent) {
        JTextField jTextField = (JTextField)this.name.getEditor().getEditorComponent();
        if (jTextField.getText().length() != 0 && this.value.getText().length() != 0) {
            this.addButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
        }
    }

    private void nameActionPerformed(ActionEvent actionEvent) {
        this.operator.setModel(new DefaultComboBoxModel<String>(Filter.operators));
        if (this.enableAddButton()) {
            this.addButton.setEnabled(true);
        }
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        logger.debug((Object)"user wants to add new filter");
        if (this.filterExplorer == null) {
            throw new NullPointerException("FilterExplorer is null");
        }
        try {
            if (!this.isInUpdateMode) {
                Filter filter = Filter.create((String)((String)this.name.getSelectedItem()), (String)((String)this.operator.getSelectedItem()), (String)this.value.getText());
                try {
                    filter.validate();
                    this.filterExplorer.addFilter(filter);
                    AppRegister.getInstance().notifyConfigurationChange();
                }
                catch (LaserException laserException) {
                    logger.warn((Object)("Fitler: " + filter.getProperty() + filter.getOperator() + filter.getValue() + " is not valid"));
                    AcWindowManager.notifyError("This filter is not valid");
                }
            } else {
                Filter filter = Filter.create((String)((String)this.name.getSelectedItem()), (String)((String)this.operator.getSelectedItem()), (String)this.value.getText());
                try {
                    filter.validate();
                    this.filterExplorer.removeFilter(this.oldName, this.oldOperator, this.oldValue);
                    this.filterExplorer.addFilter(filter);
                    AppRegister.getInstance().notifyConfigurationChange();
                }
                catch (LaserException laserException) {
                    logger.warn((Object)("Fitler: " + filter.getProperty() + filter.getOperator() + filter.getValue() + " is not valid"));
                    AcWindowManager.notifyError("This filter is not valid");
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            logger.error((Object)introspectionException, introspectionException.fillInStackTrace());
        }
        this.resetPanel();
    }

    private void initializeComponents() {
        this.addButton.setEnabled(false);
        this.name.setModel(new DefaultComboBoxModel<String>(Filter.properties));
        this.operator.setModel(new DefaultComboBoxModel<String>(Filter.operators));
    }

    private boolean enableAddButton() {
        return ((String)this.name.getSelectedItem()).length() != 0 && this.value.getText().length() != 0;
    }

    private void postInit() {
        this.name.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                SingleFilterItem.this.nameKeyReleased(keyEvent);
            }
        });
    }

    public void resetPanel() {
        this.value.setText("");
        this.name.setSelectedIndex(0);
        this.operator.setSelectedIndex(0);
        this.addButton.setEnabled(false);
        this.addButton.setText("Add Filter");
        this.isInUpdateMode = false;
    }

    public void setFitlerExplorer(CreatedFiltersExplorer createdFiltersExplorer) {
        this.filterExplorer = createdFiltersExplorer;
    }

    public void reload(String string, String string2, String string3, String string4) {
        logger.debug((Object)(this.getClass().getName() + " reload " + string + " " + string2 + " " + string3 + " button name " + string4));
        this.name.setSelectedItem(string);
        this.operator.setSelectedItem(string2);
        this.value.setText(string3);
        this.addButton.setText(string4);
    }

    public void setInUpdateMode(String string, String string2, String string3, String string4) {
        this.name.setSelectedItem(string);
        this.operator.setSelectedItem(string2);
        this.value.setText(string3);
        this.addButton.setText(string4);
        this.addButton.setEnabled(true);
        this.oldName = string;
        this.oldOperator = string2;
        this.oldValue = string3;
        this.isInUpdateMode = true;
    }

    public void setMode(String string, String string2, String string3) {
        if (this.oldName.equals(string) && this.oldOperator.equals(string2) && this.oldValue.equals(string3)) {
            this.resetPanel();
        }
    }
}

