/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows.filter;

import cern.gp.explorer.ListTableExplorer;
import cern.gp.nodes.GPNode;
import cern.gp.nodes.NodeFactory;
import cern.gp.nodes.children.ChildrenManager;
import cern.gp.nodes.children.ChildrenMapManager;
import cern.gp.nodes.children.NodeMap;
import cern.laser.client.services.selection.Filter;
import cern.laser.guiplatform.filters.FilterItemBean;
import cern.laser.guiplatform.util.LogFactory;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openide.nodes.Node;

public class CreatedFiltersExplorer
extends ListTableExplorer {
    protected static Logger logger = LogFactory.getLogger(CreatedFiltersExplorer.class.getName());
    private CreatedFiltersNodeManager nodeManager = null;

    public CreatedFiltersExplorer(List list) {
        this.nodeManager = new CreatedFiltersNodeManager(list);
        try {
            this.setRootNode(NodeFactory.createNode((Object)new Object(), (ChildrenManager)this.nodeManager));
            this.setTableColumns((Object)new FilterItemBean(), new String[]{"operator", "value"});
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
        }
    }

    public void addFilter(Filter filter) throws IntrospectionException {
        this.nodeManager.addFilter(new FilterItemBean(filter));
    }

    public void removeFilter(String string, String string2, String string3) {
        this.nodeManager.removeFilter(string, string2, string3);
    }

    public void removeFilter(Filter filter) {
        this.nodeManager.removeFilter(filter);
    }

    public void removeFilter(GPNode gPNode) {
        this.nodeManager.removeFilter(gPNode);
    }

    public void removeAllFilters() {
        this.nodeManager.removeAllFilters();
    }

    public List getDefinedFilters() {
        return this.nodeManager.getDefinedFilters();
    }

    private class CreatedFiltersNodeManager
    implements ChildrenMapManager {
        final Logger logger = LogFactory.getLogger(CreatedFiltersNodeManager.class.getName());
        private NodeMap filtersNodeMap = null;
        private List filtersList = null;
        private final List EMPTY_LIST = new ArrayList();

        public CreatedFiltersNodeManager(List list) {
            this.filtersList = list;
        }

        public Comparator getComparator() {
            return null;
        }

        public void initChildrenMap(NodeMap nodeMap) {
            this.filtersNodeMap = nodeMap;
            try {
                for (Filter filter : this.filtersList) {
                    FilterItemBean filterItemBean = new FilterItemBean(filter);
                    GPNode gPNode = NodeFactory.createNode((Object)((Object)filterItemBean));
                    FilterItemBean filterItemBean2 = (FilterItemBean)((Object)gPNode.getBean());
                    this.filtersNodeMap.addNode((Object)(filterItemBean2.getName() + filterItemBean2.getOperator() + filterItemBean2.getValue()), gPNode);
                }
            }
            catch (IntrospectionException introspectionException) {
                this.logger.error((Object)introspectionException, introspectionException.fillInStackTrace());
            }
        }

        public void addFilter(FilterItemBean filterItemBean) throws IntrospectionException {
            this.filtersNodeMap.addNode((Object)(filterItemBean.getName() + filterItemBean.getOperator() + filterItemBean.getValue()), NodeFactory.createNode((Object)((Object)filterItemBean)));
        }

        public void removeFilter(GPNode gPNode) {
            Node node = gPNode.getPeerNode();
            FilterItemBean filterItemBean = (FilterItemBean)((Object)gPNode.getBean());
            Set set = this.filtersNodeMap.keySet();
            if (set.contains(filterItemBean.getName() + filterItemBean.getOperator() + filterItemBean.getValue())) {
                this.logger.debug((Object)(filterItemBean.getName() + filterItemBean.getOperator() + filterItemBean.getValue() + " IS IN EXPLORER !!"));
            } else {
                this.logger.debug((Object)(filterItemBean.getName() + filterItemBean.getOperator() + filterItemBean.getValue() + " IS NOT IN EXPLORER !!"));
            }
            this.filtersNodeMap.removeNode((Object)(filterItemBean.getName() + filterItemBean.getOperator() + filterItemBean.getValue()));
            try {
                node.destroy();
            }
            catch (IOException iOException) {
                this.logger.error((Object)iOException, iOException.fillInStackTrace());
            }
        }

        public void removeFilter(String string, String string2, String string3) {
            GPNode gPNode = this.filtersNodeMap.removeNode((Object)(string + string2 + string3));
            try {
                gPNode.getPeerNode().destroy();
            }
            catch (IOException iOException) {
                this.logger.error((Object)iOException, iOException.fillInStackTrace());
            }
        }

        public void removeFilter(Filter filter) {
            GPNode gPNode = this.filtersNodeMap.removeNode((Object)(filter.getProperty() + filter.getOperator() + filter.getValue()));
            try {
                gPNode.getPeerNode().destroy();
            }
            catch (IOException iOException) {
                this.logger.error((Object)iOException, iOException.fillInStackTrace());
            }
        }

        public void removeAllFilters() {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            Iterator iterator = this.filtersNodeMap.keySet().iterator();
            while (iterator.hasNext()) {
                Node node = this.filtersNodeMap.getNode(iterator.next()).getPeerNode();
                arrayList.add(node);
            }
            this.filtersNodeMap.removeNodes(this.filtersNodeMap.keySet().toArray());
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                try {
                    Node node = (Node)arrayList.remove(0);
                    node.destroy();
                    continue;
                }
                catch (IOException iOException) {
                    this.logger.error((Object)iOException, iOException.fillInStackTrace());
                }
            }
        }

        public List getDefinedFilters() {
            Set set = this.filtersNodeMap.keySet();
            if (set.size() == 0) {
                return this.EMPTY_LIST;
            }
            ArrayList<Filter> arrayList = new ArrayList<Filter>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                arrayList.add(((FilterItemBean)((Object)this.filtersNodeMap.getNode(iterator.next()).getBean())).getFilter());
            }
            return arrayList;
        }
    }
}

