/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows.configuration;

import cern.gp.nodes.GPNode;
import cern.laser.client.LaserException;
import cern.laser.console.Configuration;
import cern.laser.console.LaserConsoleException;
import cern.laser.console.User;
import cern.laser.guiplatform.configuration.ConfigurationBean;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windows.configuration.ConsoleConfigurationPanel;
import cern.laser.guiplatform.windows.configuration.LoadConfigurationPanel;
import cern.laser.guiplatform.windows.filter.CreateFiltersPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.beans.IntrospectionException;
import java.util.List;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ConsoleConfigurationWindow
extends TopComponent {
    private static Logger logger = LogFactory.getLogger(ConsoleConfigurationWindow.class.getName());
    private JPanel configurationPanel;
    private JPanel loadConfigurationPanel;
    User user = null;
    Configuration configuration = null;
    private CreateFiltersPanel filtersPanel = null;
    private static final Dimension defaultDimension = new Dimension((int)((double)WindowManager.getDefault().getCurrentWorkspace().getBounds().width / 1.5), (int)((double)WindowManager.getDefault().getCurrentWorkspace().getBounds().height / 1.2));
    public static final Dimension defaultLoadConfigurationPanelDimension = new Dimension(ConsoleConfigurationWindow.defaultDimension.width / 4, ConsoleConfigurationWindow.defaultDimension.height);
    private static final long serialVersionUID = 1L;

    public ConsoleConfigurationWindow(User user, Configuration configuration) throws LaserException {
        this.initComponents();
        this.setCloseOperation(1);
        this.setName(NbBundle.getMessage(ConsoleConfigurationWindow.class, (String)"LBL_ConsoleConfigurationWindow_component_name"));
        this.putClientProperty("PersistenceType", "Never");
        this.putClientProperty("TabPolicy", "HideWhenAlone");
        this.user = user;
        this.configuration = configuration;
        this.postInitComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private void postInitComponents() throws LaserException {
        this.loadConfigurationPanel = new LoadConfigurationPanel(this, this.user);
        this.configurationPanel = new ConsoleConfigurationPanel(this, this.configuration);
        this.setLayout(new BorderLayout());
        this.add(this.loadConfigurationPanel, "West");
        this.add(this.configurationPanel, "Center");
    }

    public void removeFilter(GPNode gPNode) {
        ((ConsoleConfigurationPanel)this.configurationPanel).removeFilter(gPNode);
    }

    public void removeAllFilters() {
        ((ConsoleConfigurationPanel)this.configurationPanel).removeAllFilters();
    }

    public void setInUpdateMode(String string, String string2, String string3, String string4) {
        ((ConsoleConfigurationPanel)this.configurationPanel).setInUpdateMode(string, string2, string3, string4);
    }

    public void updateCategoryTreeExplorer() throws IntrospectionException, CloneNotSupportedException {
        ((ConsoleConfigurationPanel)this.configurationPanel).updateCategoryTreeExplorer();
    }

    public void loadAllCategoriesInTreeExplorer() throws IntrospectionException, CloneNotSupportedException {
        ((ConsoleConfigurationPanel)this.configurationPanel).loadAllCategoriesInTreeExplorer();
    }

    public void addCategory(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        ((ConsoleConfigurationPanel)this.configurationPanel).addCategory(gPNode);
    }

    public void addCategoryWithoutChildren(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        ((ConsoleConfigurationPanel)this.configurationPanel).addCategoryWithoutChildren(gPNode);
    }

    public void addSubCategories(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        ((ConsoleConfigurationPanel)this.configurationPanel).addSubCategories(gPNode);
    }

    public void removeCategoryWithoutChildren(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        ((ConsoleConfigurationPanel)this.configurationPanel).removeCategoryWithoutChildren(gPNode);
    }

    public void removeSubCategories(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        ((ConsoleConfigurationPanel)this.configurationPanel).removeSubCategories(gPNode);
    }

    public void removeCategory(GPNode gPNode) {
        ((ConsoleConfigurationPanel)this.configurationPanel).removeCategory(gPNode);
    }

    public void removeAllCategories() {
        ((ConsoleConfigurationPanel)this.configurationPanel).removeAllCategories();
    }

    public void addConfigurationToList(ConfigurationBean configurationBean) throws IntrospectionException {
        ((LoadConfigurationPanel)this.loadConfigurationPanel).addNewConfiguration(configurationBean);
    }

    public void removeConfiguration(GPNode gPNode) {
        ((LoadConfigurationPanel)this.loadConfigurationPanel).removeConfiguration(gPNode);
    }

    public List getDefinedConfigurations(User user) throws LaserConsoleException {
        return ((LoadConfigurationPanel)this.loadConfigurationPanel).getDefinedConfigurationNames(user);
    }

    public void updateConfigurationPanel(Configuration configuration, String string) throws LaserConsoleException {
        ((ConsoleConfigurationPanel)this.configurationPanel).updateConfiguration(configuration, string);
    }

    public Dimension getPreferredSize() {
        return defaultDimension;
    }

    protected void componentClosed() {
        AppRegister.getInstance().clearConfigurationChangeListeners();
    }
}

