/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows.configuration;

import cern.gp.nodes.GPNode;
import cern.gp.util.GPManager;
import cern.laser.client.LaserConnectionException;
import cern.laser.client.LaserException;
import cern.laser.client.services.selection.AlarmSelectionListener;
import cern.laser.client.services.selection.CategorySelection;
import cern.laser.client.services.selection.FilterSelection;
import cern.laser.client.services.selection.Selection;
import cern.laser.console.Behaviour;
import cern.laser.console.CommentedAlarmMap;
import cern.laser.console.Configuration;
import cern.laser.console.LaserConfigurationDuplicationException;
import cern.laser.console.LaserConsoleException;
import cern.laser.console.User;
import cern.laser.guiplatform.alarms.AlarmContainer;
import cern.laser.guiplatform.alarms.AlarmSelectionHandlerFactory;
import cern.laser.guiplatform.configuration.ConfigurationBean;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.ImageUtility;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.util.ProxyBuffer;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import cern.laser.guiplatform.windows.ActiveListExplorerPanel;
import cern.laser.guiplatform.windows.AlarmStatisticInfoPanel;
import cern.laser.guiplatform.windows.InstantFaultExplorer;
import cern.laser.guiplatform.windows.behaviour.ConfigureBehaviourPanel;
import cern.laser.guiplatform.windows.category.ChooseCategoryPanel;
import cern.laser.guiplatform.windows.configuration.ConsoleConfigurationWindow;
import cern.laser.guiplatform.windows.filter.CreateFiltersPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class ConsoleConfigurationPanel
extends JPanel {
    private static Logger logger = LogFactory.getLogger(ConsoleConfigurationPanel.class.getName());
    private JTabbedPane mainPane = null;
    private ChooseCategoryPanel categoryPanel = null;
    private CreateFiltersPanel filtersPanel = null;
    private ConfigureBehaviourPanel behaviourPanel = null;
    private JLabel infoLabel = null;
    private JButton saveButton = null;
    private JButton resetButton = null;
    private JButton applyButton = null;
    private JButton closeButton = null;
    private Configuration configuration = null;
    private ConsoleConfigurationWindow parentWindow = null;
    private boolean overwritten = false;
    private SaveConfigurationOptionPane optionPane = null;
    private User loggedUser = null;
    private boolean ownConfiguration = true;

    public ConsoleConfigurationPanel(ConsoleConfigurationWindow consoleConfigurationWindow, Configuration configuration) throws LaserConsoleException {
        this.parentWindow = consoleConfigurationWindow;
        this.configuration = configuration;
        this.initComponents();
    }

    private void initComponents() throws LaserConsoleException {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel = new JPanel();
        this.infoLabel = new JLabel("Current configuration: " + this.configuration.getName());
        jPanel.add(this.infoLabel);
        this.add((Component)jPanel, "North");
        this.mainPane = new JTabbedPane();
        this.makeCategoryPanel();
        this.makeFiltersPanel();
        this.makeBehaviorPanel();
        this.add((Component)this.mainPane, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout());
        this.saveButton = new JButton("Save", ImageUtility.getPanelIcon(this, "/org/openide/resources/actions/saveAll.gif"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleConfigurationPanel.this.saveButtonActionPerformed(actionEvent);
            }
        });
        this.saveButton.setEnabled(false);
        AppRegister.getInstance().registerConfigurationChangeListeners(this.saveButton);
        this.applyButton = new JButton("Apply", ImageUtility.getPanelIcon(this, "/org/openide/resources/actions/execute.gif"));
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleConfigurationPanel.this.applyButtonActionPerformed(actionEvent);
            }
        });
        this.resetButton = new JButton("Reset", ImageUtility.getPanelIcon(this, "/org/openide/resources/actions/clean.gif"));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleConfigurationPanel.this.resetButtonActionPerformed(actionEvent);
            }
        });
        this.closeButton = new JButton("Close", ImageUtility.getPanelIcon(this, "/cern/laser/guiplatform/images/exit.gif"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleConfigurationPanel.this.parentWindow.close();
            }
        });
        jPanel2.add(this.saveButton);
        jPanel2.add(this.applyButton);
        jPanel2.add(this.resetButton);
        jPanel2.add(this.closeButton);
        this.add((Component)jPanel2, "South");
    }

    protected void makeCategoryPanel() {
        this.categoryPanel = new ChooseCategoryPanel(this.configuration);
        this.mainPane.addTab("Category tree", ImageUtility.getPanelIcon(this, "/cern/laser/guiplatform/images/view_tree.png"), this.categoryPanel, "Choose category");
    }

    protected void makeFiltersPanel() throws LaserConsoleException {
        this.filtersPanel = new CreateFiltersPanel(this.configuration);
        this.mainPane.addTab("Filters", ImageUtility.getPanelIcon(this, "/cern/laser/guiplatform/images/filters_icon.png"), this.filtersPanel, "Create filters");
    }

    protected void makeBehaviorPanel() throws LaserConsoleException {
        this.behaviourPanel = new ConfigureBehaviourPanel(this.configuration);
        this.mainPane.addTab("Behaviour", ImageUtility.getPanelIcon(this, "/cern/laser/guiplatform/images/behaviour_icon.png"), this.behaviourPanel, "Behaviour");
    }

    public void removeFilter(GPNode gPNode) {
        this.filtersPanel.removeFilter(gPNode);
        this.configurationChanged();
    }

    public void removeAllFilters() {
        this.filtersPanel.removeAllFilters();
        this.configurationChanged();
    }

    public void setInUpdateMode(String string, String string2, String string3, String string4) {
        this.filtersPanel.setInUpdateMode(string, string2, string3, string4);
    }

    public void updateCategoryTreeExplorer() throws IntrospectionException, CloneNotSupportedException {
        this.categoryPanel.updateCategoryTreeExplorer();
    }

    public void loadAllCategoriesInTreeExplorer() throws IntrospectionException, CloneNotSupportedException {
        this.categoryPanel.loadAllCategoriesInTreeExplorer();
    }

    public void addCategory(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        this.categoryPanel.addCategory(gPNode);
        this.configurationChanged();
    }

    public void addCategoryWithoutChildren(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        this.categoryPanel.addCategoryWithoutChildren(gPNode);
        this.configurationChanged();
    }

    public void addSubCategories(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        this.categoryPanel.addSubCategories(gPNode);
        this.configurationChanged();
    }

    public void removeCategoryWithoutChildren(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        this.categoryPanel.removeCategoryWithoutChildren(gPNode);
        this.configurationChanged();
    }

    public void removeSubCategories(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        this.categoryPanel.removeSubCategories(gPNode);
        this.configurationChanged();
    }

    public void removeCategory(GPNode gPNode) {
        this.categoryPanel.removeCategory(gPNode);
        this.configurationChanged();
    }

    public void removeAllCategories() {
        this.categoryPanel.removeAllCategories();
        this.configurationChanged();
    }

    public void updateConfiguration(Configuration configuration, String string) throws LaserConsoleException {
        logger.debug((Object)("update configuration, conf name: " + configuration.getName()));
        this.configuration = configuration;
        this.categoryPanel.updateCategorySelection(configuration);
        this.filtersPanel.updateFilterSelection(configuration);
        this.behaviourPanel.updateBehaviour(configuration);
        this.infoLabel.setText("Current configuration: " + this.configuration.getName());
        this.saveButton.setEnabled(false);
        this.ownConfiguration = string.compareTo(AppRegister.getInstance().getRegisteredUser().getName()) == 0;
    }

    public void configurationChanged() {
        AppRegister.getInstance().notifyConfigurationChange();
    }

    private void applyButtonActionPerformed(ActionEvent actionEvent) {
        String string;
        logger.debug((Object)"Configuration should be applied:");
        Configuration configuration = null;
        String string2 = null;
        Selection selection = null;
        Behaviour behaviour = null;
        this.loggedUser = AppRegister.getInstance().getRegisteredUser();
        if (this.saveButton.isEnabled() || !this.ownConfiguration) {
            logger.debug((Object)"new configuration NOT SAVED RECENTLY LOADED CONFIGURATION should be created");
            this.ownConfiguration = true;
            configuration = this.createConfiguration("NOT SAVED RECENTLY LOADED CONFIGURATION", false);
            if (configuration == null) {
                return;
            }
            logger.debug((Object)"new configuration NOT SAVED RECENTLY LOADED CONFIGURATION was be created");
        } else {
            string = null;
            try {
                string = this.configuration.getName();
            }
            catch (LaserConsoleException laserConsoleException) {
                logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
                logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
            }
            logger.debug((Object)("conf: " + string + " should be applied"));
            configuration = this.configuration;
        }
        string = null;
        logger.debug((Object)"disconnet from bussiens tier");
        try {
            string = AlarmSelectionHandlerFactory.getHandler();
            string.resetSelection();
            logger.debug((Object)"resetSelection");
        }
        catch (LaserException laserException) {
            logger.error((Object)laserException, laserException.fillInStackTrace());
            logger.error((Object)laserException.getRootCause(), laserException.getRootCause().fillInStackTrace());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Internal error. Cannot reset selection.\n", 0);
            GPManager.notify((NotifyDescriptor)message);
            return;
        }
        ProxyBuffer.getDefault().disable();
        logger.debug((Object)"disabled ProxyBuffer");
        AlarmContainer.getDefault().clearNodeManagers();
        logger.debug((Object)"cleaned NodeManagers");
        Map map = null;
        try {
            AppRegister.getInstance().registerLoadedConfiguration(configuration);
            selection = configuration.getSelection();
            behaviour = configuration.getBehaviour();
            string2 = configuration.getName();
            map = string.select(selection, (AlarmSelectionListener)ProxyBuffer.getDefault());
            AlarmContainer.getDefault().reloadContainer(map, configuration);
            this.infoLabel.setText("Current configuration: " + configuration.getName());
        }
        catch (LaserConsoleException laserConsoleException) {
            logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
            logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Connection error. Unable to register new configuration, or reload alarm container.\nPlease, logout and try to login again later", 0);
            GPManager.notify((NotifyDescriptor)message);
            return;
        }
        catch (LaserException laserException) {
            logger.error((Object)laserException, laserException.fillInStackTrace());
            logger.error((Object)laserException.getRootCause(), laserException.getRootCause().fillInStackTrace());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Connection error. Unable to select new fault states.\nPlease, logout and try to login again later", 0);
            GPManager.notify((NotifyDescriptor)message);
            return;
        }
        String string3 = NbBundle.getMessage(ActiveListExplorerPanel.class, (String)"LBL_Active_list_component_name");
        AcWindowManager.setTableColumns(string3, behaviour.getColumnsToDisplay());
        String string4 = NbBundle.getMessage(InstantFaultExplorer.class, (String)"LBL_Instant_list_component_name");
        AcWindowManager.setTableColumns(string4, behaviour.getColumnsToDisplay());
        TopComponent topComponent = AcWindowManager.findTopComponent(string3);
        Component component = topComponent.getComponent(topComponent.getComponentCount() - 1);
        ((AlarmStatisticInfoPanel)component).updatePanel(string2, behaviour, selection.getReducedMaskedSelection());
        ProxyBuffer.getDefault().enable();
    }

    private void saveButtonActionPerformed(ActionEvent actionEvent) {
        logger.debug((Object)"Save button pressesd, user wants to save your configuration");
        this.loggedUser = AppRegister.getInstance().getRegisteredUser();
        try {
            this.optionPane = new SaveConfigurationOptionPane((Container)((Object)this.parentWindow), this.parentWindow.getDefinedConfigurations(this.loggedUser));
        }
        catch (LaserConsoleException laserConsoleException) {
            logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
            logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Internal error.\nLook into log file", 0);
            GPManager.notify((NotifyDescriptor)message);
            return;
        }
        if (this.optionPane.shouldBeSaved()) {
            Configuration configuration = null;
            configuration = this.createConfiguration(this.optionPane.getConfigurationName(), this.optionPane.shouldBeDefault());
            if (configuration == null) {
                return;
            }
            try {
                ConfigurationBean configurationBean = new ConfigurationBean(configuration);
                this.parentWindow.addConfigurationToList(configurationBean);
            }
            catch (LaserConsoleException laserConsoleException) {
                logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
                logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
            }
            catch (IntrospectionException introspectionException) {
                logger.error((Object)introspectionException, introspectionException.fillInStackTrace());
            }
            this.configuration = configuration;
            this.infoLabel.setText("Current configuration: " + this.optionPane.getConfigurationName());
            this.saveButton.setEnabled(false);
        }
    }

    private Configuration createConfiguration(String string, boolean bl) {
        Configuration configuration = null;
        Behaviour behaviour = null;
        Selection selection = null;
        CommentedAlarmMap commentedAlarmMap = null;
        CommentedAlarmMap commentedAlarmMap2 = null;
        CommentedAlarmMap commentedAlarmMap3 = null;
        CommentedAlarmMap commentedAlarmMap4 = null;
        CommentedAlarmMap commentedAlarmMap5 = null;
        CommentedAlarmMap commentedAlarmMap6 = null;
        boolean bl2 = false;
        if (this.configuration != null) {
            try {
                commentedAlarmMap = this.configuration.getMasked();
                commentedAlarmMap2 = this.configuration.getInhibited();
                commentedAlarmMap3 = this.configuration.getHighlighted();
                commentedAlarmMap4 = this.configuration.getAutoHighlighted();
                commentedAlarmMap5 = this.configuration.getAutoKlaxoned();
                commentedAlarmMap6 = this.configuration.getAcknowledged();
                bl2 = true;
            }
            catch (LaserConsoleException laserConsoleException) {
                logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
                logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Unable to create configuration.", 0);
                GPManager.notify((NotifyDescriptor)message);
                return null;
            }
        }
        try {
            configuration = this.loggedUser.createConfiguration(string);
        }
        catch (LaserConfigurationDuplicationException laserConfigurationDuplicationException) {
            this.overwritten = true;
            try {
                configuration = this.loggedUser.getConfiguration(string);
                selection = configuration.getSelection();
                behaviour = configuration.getBehaviour();
            }
            catch (LaserConsoleException laserConsoleException) {
                logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
                logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)("Unable to get configuration: " + string), 0);
                GPManager.notify((NotifyDescriptor)message);
                return null;
            }
            catch (LaserConnectionException laserConnectionException) {
                logger.error((Object)laserConnectionException, laserConnectionException.fillInStackTrace());
                logger.error((Object)laserConnectionException.getRootCause(), laserConnectionException.getRootCause().fillInStackTrace());
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)("Unable to get configuration: " + string), 0);
                GPManager.notify((NotifyDescriptor)message);
                return null;
            }
        }
        catch (LaserConsoleException laserConsoleException) {
            logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
            logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Unable to create configuration.", 0);
            GPManager.notify((NotifyDescriptor)message);
            return null;
        }
        Selection selection2 = null;
        try {
            selection2 = AlarmSelectionHandlerFactory.getHandler().createSelection();
        }
        catch (LaserException laserException) {
            logger.error((Object)laserException, laserException.fillInStackTrace());
            logger.error((Object)laserException.getRootCause(), laserException.getRootCause().fillInStackTrace());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Configuration can't be created.\nUnable to create selection.", 0);
            GPManager.notify((NotifyDescriptor)message);
            return null;
        }
        CategorySelection categorySelection = selection2.createCategorySelection();
        categorySelection.addAll(this.categoryPanel.getChoosenCategories());
        selection2.setCategorySelection(categorySelection);
        selection2.setReducedMaskedSelection(this.behaviourPanel.isReducedMaskedFlagOn());
        FilterSelection filterSelection = selection2.createFilterSelection();
        filterSelection.addAll((Collection)this.filtersPanel.getDefinedFilters());
        selection2.setFilterSelection(filterSelection);
        Behaviour behaviour2 = configuration.createBehaviour();
        behaviour2.setAlarmAutoKlaxon(this.behaviourPanel.isAlarmAutoKlaxon());
        behaviour2.setAlarmAutoTerminated(this.behaviourPanel.isAlarmAutoTerminated());
        behaviour2.setAlarmDistinguished(this.behaviourPanel.isAlarmDistinguished());
        behaviour2.setDailyPrinter(this.behaviourPanel.getDailyPrinter());
        behaviour2.setDailyPrinting(this.behaviourPanel.isDailyPrinting());
        behaviour2.setKlaxonVolume(this.behaviourPanel.getKlaxonVolume());
        behaviour2.setColumnsToDisplay(this.behaviourPanel.getColumnsToDisplay());
        try {
            configuration.setBehaviour(behaviour2);
            configuration.setSelection(selection2);
            if (bl2) {
                configuration.setMasked(commentedAlarmMap);
                configuration.setInhibited(commentedAlarmMap2);
                configuration.setHighlighted(commentedAlarmMap3);
                configuration.setAutoHighlighted(commentedAlarmMap4);
                configuration.setAutoKlaxoned(commentedAlarmMap5);
                configuration.setAcknowledged(commentedAlarmMap6);
            }
        }
        catch (LaserConsoleException laserConsoleException) {
            logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
            logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Unable to create configuration.\nUnable to set behaviour and selection", 0);
            GPManager.notify((NotifyDescriptor)message);
            if (this.overwritten) {
                try {
                    configuration.setBehaviour(behaviour);
                    configuration.setSelection(selection);
                }
                catch (LaserConsoleException laserConsoleException2) {
                    logger.error((Object)laserConsoleException2, laserConsoleException2.fillInStackTrace());
                    logger.error((Object)laserConsoleException2.getRootCause(), laserConsoleException2.getRootCause().fillInStackTrace());
                    message = new NotifyDescriptor.Message((Object)"ERROR. This configuration should be deleted.", 0);
                    GPManager.notify((NotifyDescriptor)message);
                }
            }
            return null;
        }
        if (bl) {
            try {
                this.loggedUser.setDefaultConfiguration(string);
            }
            catch (LaserConsoleException laserConsoleException) {
                logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
                logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Problem with setting this configuration as default.", 0);
                GPManager.notify((NotifyDescriptor)message);
                return null;
            }
        }
        return configuration;
    }

    private void resetButtonActionPerformed(ActionEvent actionEvent) {
        this.behaviourPanel.reset();
        this.categoryPanel.reset();
        this.filtersPanel.reset();
        this.configurationChanged();
    }

    private class SaveConfigurationOptionPane {
        private JRadioButton setAsDefault = null;
        private boolean isDefault = false;
        private JTextField confNameField = null;
        private String confName = null;
        boolean configurationSaved = false;
        private JPanel panel = null;
        private Container parentContainer = null;
        private List existedConfNames = null;
        private JDialog dialog = null;
        private JOptionPane optionPane = null;
        final String saveStr = NbBundle.getMessage(ConsoleConfigurationPanel.class, (String)"SaveConfigurationOptionPane_save_string");
        final String cancelStr = NbBundle.getMessage(ConsoleConfigurationPanel.class, (String)"SaveConfigurationOptionPane_cancel_string");

        public SaveConfigurationOptionPane(Container container, List list) {
            this.parentContainer = container;
            this.existedConfNames = list;
            this.initComponents();
        }

        private void initComponents() {
            Object[] objectArray = new Object[]{this.saveStr, this.cancelStr};
            this.panel = new JPanel();
            this.panel.setLayout(new BorderLayout());
            JLabel jLabel = new JLabel("Here you can save your configuration");
            this.panel.add((Component)jLabel, "North");
            this.setAsDefault = new JRadioButton("Set as default");
            this.panel.add((Component)this.setAsDefault, "Center");
            JPanel jPanel = new JPanel();
            JLabel jLabel2 = new JLabel("Enter your configuration's name");
            this.confNameField = new JTextField(30);
            jPanel.setLayout(new GridLayout(2, 1));
            jPanel.add(jLabel2);
            jPanel.add(this.confNameField);
            this.panel.add((Component)jPanel, "South");
            this.optionPane = new JOptionPane(this.panel, 1, 2, null, objectArray, objectArray[0]);
            this.optionPane.setPreferredSize(new Dimension(300, 200));
            this.dialog = new JDialog();
            this.dialog.setModal(true);
            this.dialog.setTitle("Save configuration");
            this.dialog.setLocationRelativeTo(this.parentContainer);
            this.dialog.setContentPane(this.optionPane);
            this.optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getPropertyName();
                    if (SaveConfigurationOptionPane.this.dialog.isVisible() && propertyChangeEvent.getSource() == SaveConfigurationOptionPane.this.optionPane && (string.equals("value") || string.equals("inputValue"))) {
                        Object object = SaveConfigurationOptionPane.this.optionPane.getValue();
                        if (object == JOptionPane.UNINITIALIZED_VALUE) {
                            return;
                        }
                        SaveConfigurationOptionPane.this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                        if (object.equals(SaveConfigurationOptionPane.this.saveStr)) {
                            String string2 = SaveConfigurationOptionPane.this.confNameField.getText();
                            if (string2 == null || string2.length() < 1) {
                                JOptionPane.showMessageDialog(SaveConfigurationOptionPane.this.optionPane, "You should give configuration name !!!", "Try again", 0);
                            } else if (SaveConfigurationOptionPane.this.existedConfNames.contains(string2)) {
                                int n = JOptionPane.showConfirmDialog(SaveConfigurationOptionPane.this.optionPane, "\"" + string2 + "\"" + " already exists and will be overwritten !" + " Is this OK for you ? ", " Warning ", 2);
                                if (n == 0) {
                                    logger.debug((Object)" conf name can be overwritten !! ");
                                    if (SaveConfigurationOptionPane.this.setAsDefault.isSelected()) {
                                        SaveConfigurationOptionPane.this.isDefault = true;
                                    }
                                    SaveConfigurationOptionPane.this.configurationSaved = true;
                                    SaveConfigurationOptionPane.this.confName = string2;
                                    SaveConfigurationOptionPane.this.dialog.setVisible(false);
                                }
                            } else {
                                if (SaveConfigurationOptionPane.this.setAsDefault.isSelected()) {
                                    SaveConfigurationOptionPane.this.isDefault = true;
                                }
                                SaveConfigurationOptionPane.this.configurationSaved = true;
                                SaveConfigurationOptionPane.this.confName = string2;
                                SaveConfigurationOptionPane.this.dialog.setVisible(false);
                            }
                        } else {
                            logger.debug((Object)"Cancel button");
                            SaveConfigurationOptionPane.this.isDefault = false;
                            SaveConfigurationOptionPane.this.configurationSaved = false;
                            SaveConfigurationOptionPane.this.confName = null;
                            SaveConfigurationOptionPane.this.dialog.setVisible(false);
                        }
                    }
                }
            });
            this.dialog.pack();
            this.dialog.setVisible(true);
        }

        public boolean shouldBeDefault() {
            return this.isDefault;
        }

        public String getConfigurationName() {
            return this.confName;
        }

        public boolean shouldBeSaved() {
            return this.configurationSaved;
        }
    }
}

