/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows.category;

import cern.gp.beans.BeanSupport;
import cern.gp.explorer.ListExplorer;
import cern.gp.nodes.GPNode;
import cern.gp.nodes.NodeFactory;
import cern.gp.nodes.children.ChildrenManager;
import cern.gp.nodes.children.ChildrenMapManager;
import cern.gp.nodes.children.NodeList;
import cern.gp.nodes.children.NodeMap;
import cern.gp.nodes.impl.GPBeanNode;
import cern.laser.client.data.Category;
import cern.laser.guiplatform.category.CategoryBean;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windows.category.CategoryTreeExplorer;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class ChoosenCategoryExplorer
extends ListExplorer {
    private static final Logger logger = LogFactory.getLogger(ChoosenCategoryExplorer.class.getName());
    private ChoosenCategoryNodeManager nodeManager = null;

    public ChoosenCategoryExplorer(List list) {
        this.nodeManager = new ChoosenCategoryNodeManager(list);
        try {
            this.setRootNode(NodeFactory.createNode((Object)new Object(), (ChildrenManager)this.nodeManager));
        }
        catch (IntrospectionException introspectionException) {
            logger.error((Object)introspectionException, introspectionException.fillInStackTrace());
        }
    }

    public boolean contains(GPNode gPNode) {
        try {
            CategoryBean categoryBean = (CategoryBean)((CategoryBean)gPNode.getBean()).clone();
            return this.nodeManager.contains(categoryBean);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return false;
        }
    }

    public void addCategory(BeanSupport beanSupport) throws IntrospectionException {
        this.nodeManager.addCategory(beanSupport);
    }

    public void removeCategory(GPNode gPNode) {
        this.nodeManager.removeCategory(gPNode);
        ((CategoryBean)gPNode.getBean()).setSelected(false);
    }

    public void removeAllCategories() {
        this.nodeManager.removeAllCategories();
    }

    public void addCategory(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        this.addCategoryWithoutChildren(gPNode);
        this.addSubCategories(gPNode);
    }

    public void addCategoryWithoutChildren(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        CategoryBean categoryBean = (CategoryBean)((CategoryBean)gPNode.getBean()).clone();
        this.addCategory(categoryBean);
        ((CategoryBean)gPNode.getBean()).setSelected(true);
    }

    public void addSubCategories(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        CategoryBean categoryBean = (CategoryBean)((CategoryBean)gPNode.getBean()).clone();
        if (!gPNode.getPeerNode().isLeaf()) {
            Children children = gPNode.getPeerNode().getChildren();
            logger.debug((Object)"before getChildren test 5");
            Enumeration enumeration = children.nodes();
            while (enumeration.hasMoreElements()) {
                logger.debug((Object)((Node)enumeration.nextElement()).getName());
            }
            logger.debug((Object)"after getChildren test 5");
            enumeration = gPNode.getNodeCollection();
            CategoryTreeExplorer.CategoryTreeNodeManager categoryTreeNodeManager = (CategoryTreeExplorer.CategoryTreeNodeManager)enumeration.getChildrenManager();
            NodeList nodeList = categoryTreeNodeManager.getNodeList();
            if (nodeList != null) {
                for (GPNode gPNode2 : nodeList) {
                    this.addCategory(gPNode2);
                }
            }
        }
    }

    public void removeCategoryWithoutChildren(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        this.removeCategory(gPNode);
    }

    public void removeSubCategories(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        this.removeSubCategories(gPNode, false);
    }

    public void removeSubCategories(GPNode gPNode, boolean bl) throws IntrospectionException, CloneNotSupportedException {
        CategoryBean categoryBean = (CategoryBean)((CategoryBean)gPNode.getBean()).clone();
        if (bl) {
            this.removeCategory(gPNode);
        }
        if (!gPNode.getPeerNode().isLeaf()) {
            Children children = gPNode.getPeerNode().getChildren();
            logger.debug((Object)"before getChildren test 5");
            Enumeration enumeration = children.nodes();
            while (enumeration.hasMoreElements()) {
                logger.debug((Object)((Node)enumeration.nextElement()).getName());
            }
            logger.debug((Object)"after getChildren test 5");
            enumeration = gPNode.getNodeCollection();
            CategoryTreeExplorer.CategoryTreeNodeManager categoryTreeNodeManager = (CategoryTreeExplorer.CategoryTreeNodeManager)enumeration.getChildrenManager();
            NodeList nodeList = categoryTreeNodeManager.getNodeList();
            if (nodeList != null) {
                for (GPNode gPNode2 : nodeList) {
                    this.removeSubCategories(gPNode2, true);
                }
            }
        }
    }

    public Collection getChoosenCategories() {
        return this.nodeManager.getChoosenCategories();
    }

    public void updateChoosenCategories(List list) {
        this.nodeManager.removeAllCategories();
        try {
            for (Category category : list) {
                CategoryBean categoryBean = new CategoryBean(category);
                categoryBean.setCloned();
                this.nodeManager.addCategory(categoryBean);
            }
        }
        catch (IntrospectionException introspectionException) {
            logger.error((Object)introspectionException, introspectionException.fillInStackTrace());
        }
    }

    class CategoryComparator
    implements Comparator {
        CategoryComparator() {
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof GPBeanNode) || !(object2 instanceof GPBeanNode)) {
                return 0;
            }
            GPBeanNode gPBeanNode = (GPBeanNode)object;
            GPBeanNode gPBeanNode2 = (GPBeanNode)object2;
            String string = gPBeanNode.getName();
            String string2 = gPBeanNode2.getName();
            return string.compareTo(string2);
        }
    }

    private class ChoosenCategoryNodeManager
    implements ChildrenMapManager {
        private final Logger logger = LogFactory.getLogger(ChoosenCategoryNodeManager.class.getName());
        private NodeMap categoryNodeMap = null;
        private List categoryList = null;
        private String userName = null;

        public ChoosenCategoryNodeManager(List list) {
            this.categoryList = list;
        }

        public boolean contains(BeanSupport beanSupport) {
            return this.categoryNodeMap.keySet().contains(beanSupport.getName());
        }

        public void initChildrenMap(NodeMap nodeMap) {
            this.logger.debug((Object)(this.getClass().getName() + "initChildrenList(NodeMao nodeMap)"));
            this.categoryNodeMap = nodeMap;
            if (this.categoryList == null) {
                this.logger.debug((Object)" user do not have choosen category !!!");
                return;
            }
            try {
                for (Category category : this.categoryList) {
                    CategoryBean categoryBean = new CategoryBean(category);
                    categoryBean.setCloned();
                    GPNode gPNode = NodeFactory.createNode((Object)categoryBean);
                    this.categoryNodeMap.addNode(gPNode);
                }
            }
            catch (IntrospectionException introspectionException) {
                this.logger.error((Object)introspectionException, introspectionException.fillInStackTrace());
            }
        }

        public Comparator getComparator() {
            return new CategoryComparator();
        }

        public void addCategory(BeanSupport beanSupport) throws IntrospectionException {
            if (!this.categoryNodeMap.keySet().contains(beanSupport.getName())) {
                this.categoryNodeMap.addNode((Object)beanSupport.getName(), NodeFactory.createNode((Object)beanSupport));
            }
        }

        public void removeCategory(GPNode gPNode) {
            Node node = gPNode.getPeerNode();
            this.categoryNodeMap.removeNode((Object)gPNode.getName());
        }

        public void removeAllCategories() {
            Node node;
            ArrayList<Node> arrayList = new ArrayList<Node>();
            Iterator iterator = this.categoryNodeMap.keySet().iterator();
            while (iterator.hasNext()) {
                node = this.categoryNodeMap.getNode(iterator.next()).getPeerNode();
                arrayList.add(node);
            }
            this.categoryNodeMap.removeNodes(this.categoryNodeMap.keySet().toArray());
            for (int i = 0; i < arrayList.size(); ++i) {
                node = (Node)arrayList.remove(i);
                try {
                    node.destroy();
                    continue;
                }
                catch (IOException iOException) {
                    this.logger.error((Object)iOException, iOException.fillInStackTrace());
                }
            }
        }

        public Collection getChoosenCategories() {
            ArrayList<Category> arrayList = new ArrayList<Category>();
            Set set = this.categoryNodeMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                arrayList.add(((CategoryBean)this.categoryNodeMap.getNode(iterator.next()).getBean()).getCategory());
            }
            return arrayList;
        }
    }
}

