/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows.category;

import cern.gp.explorer.TreeExplorer;
import cern.gp.nodes.NodeFactory;
import cern.gp.nodes.children.ChildrenListManager;
import cern.gp.nodes.children.ChildrenManager;
import cern.gp.nodes.children.NodeList;
import cern.gp.nodes.impl.GPBeanNode;
import cern.laser.client.LaserException;
import cern.laser.client.data.Category;
import cern.laser.guiplatform.category.CategoriesPreLoader;
import cern.laser.guiplatform.category.CategoryBean;
import cern.laser.guiplatform.category.CategoryBrowsingHandlerFactory;
import cern.laser.guiplatform.util.LogFactory;
import java.beans.IntrospectionException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class CategoryTreeExplorer
extends TreeExplorer {
    private static Logger logger = LogFactory.getLogger(CategoryTreeNodeManager.class.getName());
    private CategoryTreeNodeManager nodeManager = null;

    public CategoryTreeExplorer(Category category) {
        this.nodeManager = new CategoryTreeNodeManager(category);
        try {
            this.setRootNode(NodeFactory.createNode((Object)new CategoryBean(category), (ChildrenManager)this.nodeManager));
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
        }
    }

    public void expandAndColapseTree() {
        logger.debug((Object)"expandAndColapseTree");
        int n = 0;
        do {
            for (int i = n = this.getTreeAccess().getTree().getRowCount(); i >= 0; --i) {
                this.getTreeAccess().getTree().expandRow(i);
            }
        } while (n != this.getTreeAccess().getTree().getRowCount());
        this.expandAll(false);
    }

    public void expandAll(boolean bl) {
        JTree jTree = this.getTreeAccess().getTree();
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        this.expandAll(jTree, new TreePath(treeNode), bl);
    }

    private void expandAll(JTree jTree, TreePath treePath, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                this.expandAll(jTree, treePath2, bl);
            }
        }
        if (bl) {
            jTree.expandPath(treePath);
        } else {
            jTree.collapsePath(treePath);
        }
    }

    public class CategoryTreeNodeManager
    implements ChildrenListManager {
        private Logger logger = LogFactory.getLogger(CategoryTreeNodeManager.class.getName());
        private NodeList nodeList = null;
        private Category categoryRoot = null;

        public CategoryTreeNodeManager(Category category) {
            this.categoryRoot = category;
        }

        public void initChildrenList(NodeList nodeList) {
            this.logger.debug((Object)"initChildrenList");
            this.nodeList = nodeList;
            Collection collection = null;
            try {
                collection = CategoriesPreLoader.getInstance().isLoaded(this.categoryRoot) ? CategoriesPreLoader.getInstance().getChildren(this.categoryRoot) : CategoryBrowsingHandlerFactory.getHandler().getChildren(this.categoryRoot);
                for (Category category : collection) {
                    try {
                        if (!category.isLeaf()) {
                            nodeList.addNode(NodeFactory.createNode((Object)new CategoryBean(category), (ChildrenManager)new CategoryTreeNodeManager(category)));
                            continue;
                        }
                        nodeList.addNode(NodeFactory.createNode((Object)new CategoryBean(category)));
                    }
                    catch (IntrospectionException introspectionException) {
                        this.logger.error((Object)introspectionException, introspectionException.fillInStackTrace());
                    }
                }
            }
            catch (LaserException laserException) {
                this.logger.error((Object)laserException.getRootCause());
            }
        }

        public Comparator getComparator() {
            return new CategoryComparator();
        }

        public NodeList getNodeList() {
            return this.nodeList;
        }

        class CategoryComparator
        implements Comparator {
            CategoryComparator() {
            }

            public int compare(Object object, Object object2) {
                if (!(object instanceof GPBeanNode) || !(object2 instanceof GPBeanNode)) {
                    return 0;
                }
                GPBeanNode gPBeanNode = (GPBeanNode)object;
                GPBeanNode gPBeanNode2 = (GPBeanNode)object2;
                String string = gPBeanNode.getName();
                String string2 = gPBeanNode2.getName();
                return string.compareTo(string2);
            }
        }
    }
}

