/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows.behaviour;

import cern.laser.console.Behaviour;
import cern.laser.console.Configuration;
import cern.laser.console.LaserConsoleException;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windows.DisplayableColumnExplorer;
import cern.laser.guiplatform.windows.behaviour.SimpleChoosePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class ConfigureBehaviourPanel
extends JPanel
implements ActionListener {
    static final Logger logger = LogFactory.getLogger(ConfigureBehaviourPanel.class.getName());
    JPanel behaviourPanel = null;
    DisplayableColumnExplorer columnsExplorer = null;
    AlarmDailyPrintPanel dailyPrintPanel = null;
    SimpleChoosePanel simChoosePanel = null;
    SimpleChoosePanel behChoosePanel = null;
    SimpleChoosePanel klaxonChoosePanel = null;
    ChooseKlaxonVolumePanel klaxonVoluePanel = null;
    SimpleChoosePanel activeListFontPanel = null;
    SimpleChoosePanel clockMenuBarPanel = null;
    SimpleChoosePanel reducedMaskFlagPanel = null;
    private static final String RIGHT = "right";
    private static final String LEFT = "left";
    private static final String FIRST = "first";
    private static final String SECOND = "second";
    private static final String THIRD = "third";
    private static final String FOURTH = "fourth";
    Configuration configuration = null;

    public ConfigureBehaviourPanel(Configuration configuration) throws LaserConsoleException {
        this.configuration = configuration;
        this.initComponent();
    }

    private void initComponent() throws LaserConsoleException {
        this.setLayout(new GridLayout(0, 2));
        this.behaviourPanel = new JPanel();
        this.dailyPrintPanel = new AlarmDailyPrintPanel(NbBundle.getMessage(AlarmDailyPrintPanel.class, (String)"LBL_AlarmDailyPrintPanel_border_name"), NbBundle.getMessage(AlarmDailyPrintPanel.class, (String)"LBL_AlarmDailyPrintPanel_RadioButton_name"), this.configuration.getBehaviour().isDailyPrinting(), this.configuration.getBehaviour().getDailyPrinter());
        this.dailyPrintPanel.addConfigurationChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppRegister.getInstance().notifyConfigurationChange();
            }
        });
        this.behaviourPanel.add(this.dailyPrintPanel);
        this.behaviourPanel.setLayout(new GridLayout(7, 0));
        Behaviour behaviour = this.configuration.getBehaviour();
        boolean bl = this.configuration.getSelection().getReducedMaskedSelection();
        this.simChoosePanel = new SimpleChoosePanel("New Alarms Behaviour", "Distinguish", "Same", behaviour.isAlarmDistinguished() ? LEFT : RIGHT);
        this.simChoosePanel.addConfigurationChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppRegister.getInstance().notifyConfigurationChange();
            }
        });
        this.behaviourPanel.add(this.simChoosePanel);
        this.behChoosePanel = new SimpleChoosePanel("Terminates Behaviour", "Automatic", "Manual", behaviour.isAlarmAutoTerminated() ? LEFT : RIGHT);
        this.behChoosePanel.addConfigurationChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppRegister.getInstance().notifyConfigurationChange();
            }
        });
        this.behaviourPanel.add(this.behChoosePanel);
        this.klaxonChoosePanel = new SimpleChoosePanel("Klaxon Setting", "Selected FS", "Every FS", behaviour.isAlarmAutoKlaxon() ? RIGHT : LEFT);
        this.klaxonChoosePanel.addConfigurationChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppRegister.getInstance().notifyConfigurationChange();
            }
        });
        this.behaviourPanel.add(this.klaxonChoosePanel);
        this.klaxonVoluePanel = new ChooseKlaxonVolumePanel("Klaxon Volume", "No", "Bell High", "Bell Low", "Klaxon", this.setKlaxonVolume(behaviour.getKlaxonVolume()));
        this.klaxonVoluePanel.addConfigurationChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppRegister.getInstance().notifyConfigurationChange();
            }
        });
        this.behaviourPanel.add(this.klaxonVoluePanel);
        this.activeListFontPanel = new SimpleChoosePanel("Active List Font Behaviour", "Small font", "Big font", LEFT);
        this.activeListFontPanel.addConfigurationChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppRegister.getInstance().notifyConfigurationChange();
            }
        });
        this.behaviourPanel.add(this.activeListFontPanel);
        this.clockMenuBarPanel = new SimpleChoosePanel("Show Clock in menubar", "Yes", "No", LEFT);
        this.clockMenuBarPanel.addConfigurationChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppRegister.getInstance().notifyConfigurationChange();
            }
        });
        this.behaviourPanel.add(this.klaxonChoosePanel);
        this.reducedMaskFlagPanel = new SimpleChoosePanel("Reduction Mask Filtering", "On", "Off", bl ? LEFT : RIGHT);
        this.reducedMaskFlagPanel.addConfigurationChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppRegister.getInstance().notifyConfigurationChange();
            }
        });
        this.behaviourPanel.add(this.reducedMaskFlagPanel);
        this.columnsExplorer = new DisplayableColumnExplorer(this.configuration.getBehaviour().getColumnsToDisplay(), false);
        this.add((Component)((Object)this.columnsExplorer));
        this.add(this.behaviourPanel);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void reset() {
        this.simChoosePanel.setSelected(LEFT);
        this.behChoosePanel.setSelected(RIGHT);
        this.klaxonChoosePanel.setSelected(RIGHT);
        this.activeListFontPanel.setSelected(LEFT);
        this.clockMenuBarPanel.setSelected(LEFT);
        this.reducedMaskFlagPanel.setSelected(RIGHT);
        this.klaxonVoluePanel.setDefaultChecked();
        this.dailyPrintPanel.reset();
        this.columnsExplorer.reset();
    }

    public HashMap getSelectedBehaviuor() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    public boolean isAlarmAutoKlaxon() {
        return !this.klaxonChoosePanel.getChoosenButton().equals(LEFT);
    }

    public String getKlaxonVolume() {
        if (this.klaxonVoluePanel.getChoosenButton().equals(SECOND)) {
            return "HIGH_BELL";
        }
        if (this.klaxonVoluePanel.getChoosenButton().equals(THIRD)) {
            return "LOW_BELL";
        }
        if (this.klaxonVoluePanel.getChoosenButton().equals(FOURTH)) {
            return "KLAXON";
        }
        if (this.klaxonVoluePanel.getChoosenButton().equals(FIRST)) {
            return "SILENT";
        }
        return "SILENT";
    }

    private String setKlaxonVolume(String string) {
        if (string.equals("SILENT")) {
            return FIRST;
        }
        if (string.equals("HIGH_BELL")) {
            return SECOND;
        }
        if (string.equals("LOW_BELL")) {
            return THIRD;
        }
        return FOURTH;
    }

    public boolean isDailyPrinting() {
        return this.dailyPrintPanel.isDailyPrinting();
    }

    public String getDailyPrinter() {
        return this.dailyPrintPanel.getDailyPrinterName();
    }

    public boolean isAlarmDistinguished() {
        return this.simChoosePanel.getChoosenButton().equals(LEFT);
    }

    public boolean isAlarmAutoTerminated() {
        return this.behChoosePanel.getChoosenButton().equals(LEFT);
    }

    public boolean isReducedMaskedFlagOn() {
        return this.reducedMaskFlagPanel.getChoosenButton().equals(LEFT);
    }

    public String[] getColumnsToDisplay() {
        List list = this.columnsExplorer.getEnabledColumns();
        String[] stringArray = list.toArray(new String[0]);
        logger.debug((Object)("getColumnsToDisplay() " + list.toString()));
        return stringArray;
    }

    public void updateBehaviour(Configuration configuration) throws LaserConsoleException {
        this.configuration = configuration;
        Behaviour behaviour = this.configuration.getBehaviour();
        boolean bl = this.configuration.getSelection().getReducedMaskedSelection();
        this.dailyPrintPanel.updatePanel(this.configuration.getBehaviour().isDailyPrinting(), this.configuration.getBehaviour().getDailyPrinter());
        this.simChoosePanel.setSelected(behaviour.isAlarmDistinguished() ? LEFT : RIGHT);
        this.behChoosePanel.setSelected(behaviour.isAlarmAutoTerminated() ? LEFT : RIGHT);
        this.klaxonChoosePanel.setSelected(behaviour.isAlarmAutoKlaxon() ? RIGHT : LEFT);
        this.klaxonVoluePanel.setSelected(this.setKlaxonVolume(behaviour.getKlaxonVolume()));
        this.activeListFontPanel.setSelected(LEFT);
        this.clockMenuBarPanel.setSelected(LEFT);
        this.reducedMaskFlagPanel.setSelected(bl ? LEFT : RIGHT);
        this.columnsExplorer.updateColumns(this.configuration.getBehaviour().getColumnsToDisplay());
    }

    private class AlarmDailyPrintPanel
    extends JPanel {
        final Logger logger = LogFactory.getLogger(AlarmDailyPrintPanel.class.getName());
        private JButton setDailyPrinterButton = null;
        private JRadioButton radioButton = null;
        private JButton setPrinterButton = null;
        private String dailyPrinterName = null;
        private JLabel printerNameLabel = null;
        private ActionListener confChangeListener = null;

        public AlarmDailyPrintPanel(String string, String string2, boolean bl, String string3) {
            this.dailyPrinterName = string3;
            Border border = BorderFactory.createEtchedBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, string);
            this.setLayout(new GridLayout(2, 0));
            this.setBorder(titledBorder);
            JPanel jPanel = new JPanel(new BorderLayout());
            this.radioButton = new JRadioButton(string2);
            this.radioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AlarmDailyPrintPanel.this.radioButtonActionPerformed(actionEvent);
                }
            });
            if (bl) {
                this.radioButton.setSelected(true);
            }
            jPanel.add((Component)this.radioButton, "West");
            this.setPrinterButton = new JButton("Set Daily Printer");
            this.setPrinterButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AlarmDailyPrintPanel.this.setPrinterButtonActionPerformed(actionEvent);
                }
            });
            jPanel.add((Component)this.setPrinterButton, "East");
            this.add(jPanel);
            this.printerNameLabel = new JLabel("Printer name: " + this.dailyPrinterName);
            this.add(this.printerNameLabel);
        }

        public void setPrinterButtonActionPerformed(ActionEvent actionEvent) {
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine("Give printer name", "Printer name", -1, -1);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.OK_OPTION) {
                this.dailyPrinterName = inputLine.getInputText();
                this.printerNameLabel.setText("Printer name: " + this.dailyPrinterName);
                if (this.confChangeListener != null) {
                    this.confChangeListener.actionPerformed(actionEvent);
                }
            }
        }

        public void radioButtonActionPerformed(ActionEvent actionEvent) {
            if (this.confChangeListener != null) {
                this.confChangeListener.actionPerformed(actionEvent);
            }
        }

        public void reset() {
            this.dailyPrinterName = "";
            this.printerNameLabel.setText("Printer name: " + this.dailyPrinterName);
            this.radioButton.setSelected(false);
        }

        public void updatePanel(boolean bl, String string) {
            this.dailyPrinterName = string;
            this.printerNameLabel.setText("Printer name: " + this.dailyPrinterName);
            this.radioButton.setSelected(bl);
        }

        public String getDailyPrinterName() {
            return this.dailyPrinterName;
        }

        public boolean isDailyPrinting() {
            return this.radioButton.isSelected();
        }

        public void addConfigurationChangeListener(ActionListener actionListener) {
            this.confChangeListener = actionListener;
        }
    }

    private class ChooseKlaxonVolumePanel
    extends JPanel
    implements ActionListener {
        private JRadioButton firstRadio = null;
        private JRadioButton secondRadio = null;
        private JRadioButton thirdRadio = null;
        private JRadioButton fourthRadio = null;
        private String defaultChecked = null;
        private ActionListener confChangeListener = null;

        public ChooseKlaxonVolumePanel() {
        }

        public ChooseKlaxonVolumePanel(String string, String string2, String string3, String string4, String string5, String string6) {
            this.initComponents(string, string2, string3, string4, string5, string6);
        }

        private void initComponents(String string, String string2, String string3, String string4, String string5, String string6) {
            this.defaultChecked = string6;
            Border border = BorderFactory.createEtchedBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, string);
            this.setLayout(new GridLayout(2, 2));
            this.setBorder(titledBorder);
            this.firstRadio = new JRadioButton(string2);
            this.firstRadio.addActionListener(this);
            this.secondRadio = new JRadioButton(string3);
            this.secondRadio.addActionListener(this);
            this.thirdRadio = new JRadioButton(string4);
            this.thirdRadio.addActionListener(this);
            this.fourthRadio = new JRadioButton(string5);
            this.fourthRadio.addActionListener(this);
            if (string6 != null) {
                if (string6.equals(ConfigureBehaviourPanel.FIRST)) {
                    this.firstRadio.setSelected(true);
                } else if (string6.equals(ConfigureBehaviourPanel.SECOND)) {
                    this.secondRadio.setSelected(true);
                } else if (string6.equals(ConfigureBehaviourPanel.THIRD)) {
                    this.thirdRadio.setSelected(true);
                } else if (string6.equals(ConfigureBehaviourPanel.FOURTH)) {
                    this.fourthRadio.setSelected(true);
                }
            }
            this.add(this.firstRadio);
            this.add(this.secondRadio);
            this.add(this.thirdRadio);
            this.add(this.fourthRadio);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(this.firstRadio)) {
                this.setSelected(ConfigureBehaviourPanel.FIRST);
            } else if (actionEvent.getSource().equals(this.secondRadio)) {
                this.setSelected(ConfigureBehaviourPanel.SECOND);
            } else if (actionEvent.getSource().equals(this.thirdRadio)) {
                this.setSelected(ConfigureBehaviourPanel.THIRD);
            } else if (actionEvent.getSource().equals(this.fourthRadio)) {
                this.setSelected(ConfigureBehaviourPanel.FOURTH);
            }
            if (this.confChangeListener != null) {
                this.confChangeListener.actionPerformed(actionEvent);
            }
        }

        public void setSelected(String string) {
            if (string.equals(ConfigureBehaviourPanel.FIRST)) {
                this.firstRadio.setSelected(true);
                this.secondRadio.setSelected(false);
                this.thirdRadio.setSelected(false);
                this.fourthRadio.setSelected(false);
            } else if (string.equals(ConfigureBehaviourPanel.SECOND)) {
                this.firstRadio.setSelected(false);
                this.secondRadio.setSelected(true);
                this.thirdRadio.setSelected(false);
                this.fourthRadio.setSelected(false);
            } else if (string.equals(ConfigureBehaviourPanel.THIRD)) {
                this.firstRadio.setSelected(false);
                this.secondRadio.setSelected(false);
                this.thirdRadio.setSelected(true);
                this.fourthRadio.setSelected(false);
            } else if (string.equals(ConfigureBehaviourPanel.FOURTH)) {
                this.firstRadio.setSelected(false);
                this.secondRadio.setSelected(false);
                this.thirdRadio.setSelected(false);
                this.fourthRadio.setSelected(true);
            }
        }

        public void setDefaultChecked() {
            if (this.defaultChecked != null) {
                this.setSelected(this.defaultChecked);
            }
        }

        public String getChoosenButton() {
            if (this.firstRadio.isSelected()) {
                return ConfigureBehaviourPanel.FIRST;
            }
            if (this.secondRadio.isSelected()) {
                return ConfigureBehaviourPanel.SECOND;
            }
            if (this.thirdRadio.isSelected()) {
                return ConfigureBehaviourPanel.THIRD;
            }
            return ConfigureBehaviourPanel.FOURTH;
        }

        public void addConfigurationChangeListener(ActionListener actionListener) {
            this.confChangeListener = actionListener;
        }
    }
}

