/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows.alarms;

import cern.laser.client.data.Category;
import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.util.LabelValueBean;
import cern.laser.guiplatform.util.LogFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class AlarmDetailsPanel
extends TopComponent {
    private JButton allFieldsButton;
    private JPanel buttonPanel;
    private JScrollPane categoryFieldsScrollPane;
    private JTable categoryFieldsTable;
    private JButton closeButton;
    private JScrollPane dynamicFieldsScrollPane;
    private JTable dynamicFieldsTable;
    private JPanel headerPanel;
    private JScrollPane headerScrollPane;
    private JButton helpButton;
    private JLabel identifierLabel;
    private JLabel identifierValLabel;
    private JPanel middlePanel;
    private JLabel probDescLabel;
    private JLabel probDescValLabel;
    private JScrollPane staticFieldsScrollPane;
    private JTable staticFieldsTable;
    private JLabel systemNameLabel;
    private JLabel systemNameValLabel;
    private AlarmBean alarm = null;
    private static final Dimension defaultDimension = new Dimension(WindowManager.getDefault().getCurrentWorkspace().getBounds().width / 3, WindowManager.getDefault().getCurrentWorkspace().getBounds().height);
    private boolean allFields = true;
    private static final Logger logger = LogFactory.getLogger(AlarmDetailsPanel.class.getName());
    private static final long serialVersionUID = 1L;

    public AlarmDetailsPanel(AlarmBean alarmBean) {
        this.initComponents();
        this.setCloseOperation(1);
        this.setName(NbBundle.getMessage(AlarmDetailsPanel.class, (String)"LBL_ALARM_DETAILS_PANEL_component_name"));
        this.putClientProperty("PersistenceType", "Never");
        this.putClientProperty("TabPolicy", "HideWhenAlone");
        this.alarm = alarmBean;
        this.postInitComponents();
    }

    private void initComponents() {
        this.headerScrollPane = new JScrollPane();
        this.headerPanel = new JPanel();
        this.systemNameLabel = new JLabel();
        this.systemNameValLabel = new JLabel();
        this.identifierLabel = new JLabel();
        this.identifierValLabel = new JLabel();
        this.probDescLabel = new JLabel();
        this.probDescValLabel = new JLabel();
        this.buttonPanel = new JPanel();
        this.allFieldsButton = new JButton();
        this.closeButton = new JButton();
        this.helpButton = new JButton();
        this.middlePanel = new JPanel();
        this.dynamicFieldsScrollPane = new JScrollPane();
        this.dynamicFieldsTable = new JTable();
        this.staticFieldsScrollPane = new JScrollPane();
        this.staticFieldsTable = new JTable();
        this.categoryFieldsScrollPane = new JScrollPane();
        this.categoryFieldsTable = new JTable();
        this.setLayout(new BorderLayout());
        this.headerPanel.setLayout(new GridBagLayout());
        this.headerPanel.setBorder(new BevelBorder(1));
        this.systemNameLabel.setText("System Name:");
        this.systemNameLabel.setPreferredSize(null);
        this.systemNameLabel.setHorizontalTextPosition(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 8, 0, 0);
        this.headerPanel.add((Component)this.systemNameLabel, gridBagConstraints);
        this.systemNameValLabel.setText("SPS_MSE_SEPTA ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 10, 0, 5);
        this.headerPanel.add((Component)this.systemNameValLabel, gridBagConstraints);
        this.identifierLabel.setText("Idetifier:");
        this.identifierLabel.setPreferredSize(null);
        this.identifierLabel.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.headerPanel.add((Component)this.identifierLabel, gridBagConstraints);
        this.identifierValLabel.setText("LSS6f");
        this.identifierValLabel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        this.headerPanel.add((Component)this.identifierValLabel, gridBagConstraints);
        this.probDescLabel.setText("Problem Description:");
        this.probDescLabel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.headerPanel.add((Component)this.probDescLabel, gridBagConstraints);
        this.probDescValLabel.setText("This is problem description");
        this.probDescValLabel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 3, 4);
        this.headerPanel.add((Component)this.probDescValLabel, gridBagConstraints);
        this.headerScrollPane.setViewportView(this.headerPanel);
        this.add(this.headerScrollPane, "North");
        this.allFieldsButton.setText("Not Empty Fields");
        this.allFieldsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AlarmDetailsPanel.this.allFieldsButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.allFieldsButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AlarmDetailsPanel.this.closeButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AlarmDetailsPanel.this.helpButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.helpButton);
        this.add(this.buttonPanel, "South");
        this.middlePanel.setLayout(new GridLayout(3, 0));
        this.dynamicFieldsScrollPane.setBorder(new TitledBorder("Dynamic fileds"));
        this.dynamicFieldsScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                AlarmDetailsPanel.this.dynamicFieldsScrollPaneComponentResized(componentEvent);
            }
        });
        this.dynamicFieldsTable.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Title 1", "Title 2"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.dynamicFieldsTable.setPreferredSize(null);
        this.dynamicFieldsScrollPane.setViewportView(this.dynamicFieldsTable);
        this.middlePanel.add(this.dynamicFieldsScrollPane);
        this.staticFieldsScrollPane.setBorder(new TitledBorder("Static fields"));
        this.staticFieldsTable.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Title 1", "Title 2"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.staticFieldsTable.setPreferredSize(null);
        this.staticFieldsScrollPane.setViewportView(this.staticFieldsTable);
        this.middlePanel.add(this.staticFieldsScrollPane);
        this.categoryFieldsScrollPane.setBorder(new TitledBorder("Alarm belongs to these categories"));
        this.categoryFieldsTable.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}}, new String[]{"Category Name", "Category Description"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.categoryFieldsScrollPane.setViewportView(this.categoryFieldsTable);
        this.middlePanel.add(this.categoryFieldsScrollPane);
        this.add(this.middlePanel, "Center");
    }

    private void helpButtonActionPerformed(ActionEvent actionEvent) {
    }

    private void allFieldsButtonActionPerformed(ActionEvent actionEvent) {
        if (this.allFields) {
            this.allFieldsButton.setText("All Fields");
            this.allFields = false;
        } else {
            this.allFieldsButton.setText("Not Empty Fields");
            this.allFields = true;
        }
        this.setAllTableModels();
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.close();
    }

    private void dynamicFieldsScrollPaneComponentResized(ComponentEvent componentEvent) {
        this.setAutoResizeMode(this.dynamicFieldsTable, this.dynamicFieldsScrollPane);
        this.setAutoResizeMode(this.staticFieldsTable, this.staticFieldsScrollPane);
        this.setAutoResizeMode(this.categoryFieldsTable, this.categoryFieldsScrollPane);
    }

    private void setAutoResizeMode(JTable jTable, JScrollPane jScrollPane) {
        Dimension dimension = jScrollPane.getSize();
        Dimension dimension2 = jTable.getPreferredSize();
        if (dimension.width >= dimension2.width) {
            jTable.setAutoResizeMode(2);
        } else {
            jTable.setAutoResizeMode(0);
        }
    }

    public void updatePanel(AlarmBean alarmBean) {
        this.alarm = alarmBean;
        this.allFields = true;
        this.systemNameValLabel.setText(this.alarm.getSystemName());
        this.identifierValLabel.setText(this.alarm.getIdentifier());
        this.probDescValLabel.setText(this.alarm.getProblemDescription());
        this.setAllTableModels();
    }

    private void postInitComponents() {
        this.probDescValLabel.setText(this.alarm.getProblemDescription());
        this.systemNameValLabel.setText(this.alarm.getSystemName());
        this.identifierValLabel.setText(this.alarm.getIdentifier());
        this.dynamicFieldsTable.setTableHeader(null);
        this.staticFieldsTable.setTableHeader(null);
        this.setAllTableModels();
    }

    private void setAllTableModels() {
        AlarmPropertiesModel alarmPropertiesModel = new AlarmPropertiesModel(this.alarm.getDynamicInfo(this.allFields));
        this.dynamicFieldsTable.setModel(alarmPropertiesModel);
        this.initColumnSizes(this.dynamicFieldsTable, (AlarmPropertiesModel)this.dynamicFieldsTable.getModel());
        this.setAutoResizeMode(this.dynamicFieldsTable, this.dynamicFieldsScrollPane);
        AlarmPropertiesModel alarmPropertiesModel2 = new AlarmPropertiesModel(this.alarm.getStaticInfo(this.allFields));
        this.staticFieldsTable.setModel(alarmPropertiesModel2);
        this.initColumnSizes(this.staticFieldsTable, (AlarmPropertiesModel)this.staticFieldsTable.getModel());
        this.setAutoResizeMode(this.staticFieldsTable, this.staticFieldsScrollPane);
        ArrayList<LabelValueBean> arrayList = new ArrayList<LabelValueBean>();
        for (Category category : this.alarm.getCategories()) {
            arrayList.add(new LabelValueBean(category.getName(), category.getDescription()));
        }
        AlarmPropertiesModel alarmPropertiesModel3 = new AlarmPropertiesModel(arrayList, new String[]{NbBundle.getMessage(AlarmDetailsPanel.class, (String)"LBL_ALARM_DETAILS_PANEL_CATEGORY_NAME_column_name"), NbBundle.getMessage(AlarmDetailsPanel.class, (String)"LBL_ALARM_DETAILS_PANEL_CATEGORY_DESC_column_name")});
        this.categoryFieldsTable.setModel(alarmPropertiesModel3);
        this.initColumnSizes(this.categoryFieldsTable, (AlarmPropertiesModel)this.categoryFieldsTable.getModel());
        this.setAutoResizeMode(this.categoryFieldsTable, this.categoryFieldsScrollPane);
    }

    private void initColumnSizes(JTable jTable, AlarmPropertiesModel alarmPropertiesModel) {
        TableColumn tableColumn = null;
        Component component = null;
        int n = 0;
        int n2 = 0;
        int n3 = 30;
        String[] stringArray = new String[]{alarmPropertiesModel.getLongestLabel(), alarmPropertiesModel.getLongestValue()};
        for (int i = 0; i < stringArray.length; ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            component = jTable.getDefaultRenderer(alarmPropertiesModel.getColumnClass(i)).getTableCellRendererComponent(jTable, stringArray[i], false, false, 0, i);
            n2 = component.getPreferredSize().width;
            tableColumn.setPreferredWidth(Math.max(n, n2) + n3);
        }
    }

    public Dimension getPreferredSize() {
        return defaultDimension;
    }

    private class AlarmPropertiesModel
    extends AbstractTableModel {
        private final Logger logger = LogFactory.getLogger(AlarmPropertiesModel.class.getName());
        private List properties = null;
        private int maxLabelLength = 0;
        private String longestLabel = null;
        private int maxValueLength = 0;
        private String longestValue = null;
        private Object[] columnNames = null;

        public AlarmPropertiesModel(List list, Object[] objectArray) {
            this.properties = list;
            this.columnNames = objectArray;
            this.calculateMaxColumnLenghts();
        }

        public AlarmPropertiesModel(List list) {
            this(list, new String[]{"col1", "col2"});
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.properties.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            LabelValueBean labelValueBean = (LabelValueBean)this.properties.get(n);
            if (n2 == 0) {
                return labelValueBean.getLabel();
            }
            return labelValueBean.getValue();
        }

        @Override
        public String getColumnName(int n) {
            return (String)this.columnNames[n];
        }

        private void calculateMaxColumnLenghts() {
            for (LabelValueBean labelValueBean : this.properties) {
                int n = 0;
                n = labelValueBean.getLabel().length();
                if (n > this.maxLabelLength) {
                    this.maxLabelLength = n;
                    this.longestLabel = labelValueBean.getLabel();
                }
                if (labelValueBean.getValue() == null || (n = labelValueBean.getValue().length()) <= this.maxValueLength) continue;
                this.maxValueLength = n;
                this.longestValue = labelValueBean.getValue();
            }
        }

        public int getMaxLabelLength() {
            return this.maxLabelLength;
        }

        public int getMaxValueLength() {
            return this.maxValueLength;
        }

        public String getLongestLabel() {
            return this.longestLabel;
        }

        public String getLongestValue() {
            return this.longestValue;
        }
    }
}

