/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.util;

import cern.laser.client.data.Alarm;
import cern.laser.client.services.selection.AlarmSelectionListener;
import cern.laser.client.services.selection.LaserSelectionException;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.util.buffer.PullEvent;
import cern.laser.util.buffer.PullException;
import cern.laser.util.buffer.SynchroBuffer;
import cern.laser.util.buffer.SynchroBufferListener;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ProxyBuffer
implements AlarmSelectionListener,
SynchroBufferListener {
    private static final Logger logger = LogFactory.getLogger(ProxyBuffer.class.getName());
    private AlarmSelectionListener listener = null;
    private SynchroBuffer buffer = new SynchroBuffer(200L, 2000L, 100, 1);
    private static ProxyBuffer INSTANCE = null;

    private ProxyBuffer() {
        this.buffer.setSynchroBufferListener((SynchroBufferListener)this);
    }

    public void enable() {
        this.buffer.enable();
    }

    public void disable() {
        this.buffer.disable();
    }

    public void close() {
        this.buffer.close();
        this.listener = null;
        INSTANCE = null;
    }

    public static ProxyBuffer getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new ProxyBuffer();
        }
        return INSTANCE;
    }

    public void onAlarm(Alarm alarm) {
        logger.debug((Object)("pushed: " + alarm.getTriplet().toString() + " isActive: " + alarm.getStatus().isActive() + " isMasked: " + alarm.getStatus().isMasked() + " isReduced: " + alarm.getStatus().isReduced()));
        this.buffer.push((Object)alarm);
    }

    public void onException(LaserSelectionException laserSelectionException) {
        if (this.listener != null) {
            this.listener.onException(laserSelectionException);
        }
    }

    public void pull(PullEvent pullEvent) throws PullException {
        if (this.listener != null) {
            Iterator iterator = pullEvent.getPulled().iterator();
            while (iterator.hasNext()) {
                this.listener.onAlarm((Alarm)iterator.next());
            }
        }
    }

    public void registerAlarmSelectionListener(AlarmSelectionListener alarmSelectionListener) {
        this.listener = alarmSelectionListener;
    }

    public void unregisterAlarmSelectionListener() {
        this.listener = null;
    }
}

