/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.util;

import java.net.URL;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class LogFactory {
    private static final String CONSOLE_PATTERN_LAYOUT = "%5p [%t] (%F:%L) - %m%n";
    private static final String FILE_PATTERN_LAYOUT = "%5p [%t] {%d{dd HH:mm:ss}} (%F:%L) - %m%n";
    private static final String LOG_FILE_NAME = System.getProperty("netbeans.user") + "/alarm_console.log";

    public static Logger getLogger(String string) {
        Logger logger = Logger.getLogger((String)string);
        String string2 = System.getProperty("log4j.configuration");
        if (string2 == null || string2.length() == 0) {
            URL uRL = LogFactory.class.getClassLoader().getResource("resources/log4j.properties");
            PropertyConfigurator.configure((URL)uRL);
        } else {
            PropertyConfigurator.configure((String)string2);
        }
        logger.debug((Object)("Logger created for " + string));
        return logger;
    }

    public static void logException(Logger logger, Exception exception) {
        if (logger == null || exception == null) {
            return;
        }
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            logger.debug((Object)stackTraceElementArray[i]);
        }
    }
}

