/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.util;

import cern.laser.client.data.Category;
import cern.laser.client.services.selection.Selection;
import cern.laser.console.Behaviour;
import cern.laser.console.Configuration;
import cern.laser.console.LaserConsoleException;
import cern.laser.console.User;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windows.ActiveListExplorerPanel;
import cern.laser.guiplatform.windows.search.SearchWindowSettings;
import java.util.HashMap;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class AppRegister {
    private static Logger logger = LogFactory.getLogger(AppRegister.class.getName());
    public final String configurationKey = "actualConfiguraton";
    private final String loggedUserKey = "loggedUser";
    private final String activeListExplorerPanelKey = "activeListExplorerPanel";
    private static AppRegister instance = null;
    private HashMap register = new HashMap();
    private Configuration loadedConfiguration = null;
    private Category[] searchCategories = null;
    private Behaviour behaviour = null;
    private Selection selection = null;
    private JButton saveButton = null;
    private final String FONT_NAME = "Dialog";
    private final int FONT_SIZE_BIG = 22;
    private final int FONT_SIZE_SMALL = 18;
    private int fontSize = 18;
    private SearchWindowSettings searchWindowSettings = null;

    private AppRegister() {
    }

    public boolean isFontBig() {
        return this.fontSize == 22;
    }

    public boolean isGuestMode() {
        String string = this.getRegisteredUserName();
        return string != null && string.compareToIgnoreCase("GUEST") == 0;
    }

    public void setFontBig(boolean bl) {
        this.fontSize = bl ? 22 : 18;
    }

    public String getFontName() {
        return "Dialog";
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public static synchronized AppRegister getInstance() {
        if (instance == null) {
            instance = new AppRegister();
        }
        return instance;
    }

    public synchronized Configuration getLoadedConfiguration() {
        return this.loadedConfiguration;
    }

    public synchronized void registerLoadedConfiguration(Configuration configuration) throws LaserConsoleException {
        this.behaviour = configuration.getBehaviour();
        this.selection = configuration.getSelection();
        if (this.loadedConfiguration != null) {
            this.loadedConfiguration = null;
        }
        this.loadedConfiguration = configuration;
    }

    public synchronized Behaviour getBehaviour() {
        return this.behaviour;
    }

    public synchronized Selection getSelection() {
        return this.selection;
    }

    public void registerObject(Object object, Object object2) {
        this.register.put(object, object2);
    }

    public Object getRegisterdObject(Object object) {
        return this.register.get(object);
    }

    public void removeRegisteredObject(Object object) {
        this.register.remove(object);
    }

    public void registerUser(User user) {
        this.register.put("loggedUser", user);
    }

    public void unregisterUser() {
        this.register.remove("loggedUser");
    }

    public User getRegisteredUser() {
        return (User)this.register.get("loggedUser");
    }

    public String getRegisteredUserName() {
        String string = null;
        User user = (User)this.register.get("loggedUser");
        try {
            if (user != null) {
                string = user.getName();
            }
        }
        catch (LaserConsoleException laserConsoleException) {
            logger.debug((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
            string = null;
        }
        return string;
    }

    public void registerActiveListExplorerPanel(ActiveListExplorerPanel activeListExplorerPanel) {
        this.register.put("activeListExplorerPanel", activeListExplorerPanel);
    }

    public void unregisterActiveListExplorerPanel() {
        this.register.remove("activeListExplorerPanel");
    }

    public ActiveListExplorerPanel getRegisteredActiveListExplorerPanel() {
        return (ActiveListExplorerPanel)((Object)this.register.get("activeListExplorerPanel"));
    }

    public void cleanRegister() {
        this.register.clear();
        this.register = null;
        instance = null;
        this.loadedConfiguration = null;
        this.behaviour = null;
        logger.debug((Object)"AppRegister was cleared");
    }

    public void notifyConfigurationChange() {
        if (this.saveButton != null && !this.isGuestMode()) {
            this.saveButton.setEnabled(true);
        }
    }

    public void registerConfigurationChangeListeners(JButton jButton) {
        this.saveButton = jButton;
    }

    public void clearConfigurationChangeListeners() {
        this.saveButton = null;
    }

    public SearchWindowSettings getSearchWindowSettings(int n) {
        if (this.searchWindowSettings == null) {
            this.searchWindowSettings = new SearchWindowSettings(n);
        }
        this.searchWindowSettings.setWindowMode(n);
        return this.searchWindowSettings;
    }

    public Category[] getSearchCategories() {
        if (this.searchCategories == null) {
            this.searchCategories = new Category[0];
        }
        return this.searchCategories;
    }

    public void setSearchCategories(Category[] categoryArray) {
        this.searchCategories = categoryArray;
    }
}

