/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.printing;

import cern.laser.guiplatform.printing.PrintDialog;
import java.awt.Frame;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterIOException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.Sides;
import javax.swing.JFrame;

public class PrintUtil {
    private static final int USE_DEFAULTS = 1;
    private static final int USE_FORM_CODES = 2;
    private static final int USE_OPTIONS = 3;
    private Printable toPrint = null;
    private String printerName;
    private int numberOfCopies;
    private boolean isTwoSidePrint;
    private boolean isAllPagePrint;
    private boolean isRangePagePrint;
    private int rangeFrom;
    private int rangeTo;
    private boolean isPrintToFile;
    private File fileToPrint;
    private boolean isLandscape;
    private boolean settingsOK = false;
    private int sendStatus = 0;
    private int nextJob = 1;
    private String cfName;
    private String dfName;
    private String controlFile;
    private String userName = "null";
    private String jobName = "null";
    private int printOptions = 1;
    private int widthCode = -1;
    private String pagePosition = "twopage";
    private String rectoVerso = "rverso";
    private Socket sock = null;
    private int nextPort = 721;
    private final int timeout = 30;

    public PrintUtil() {
        try {
            this.userName = System.getProperty("user.name");
        }
        catch (Exception exception) {
            System.out.println("ERROR: Could not get user ID: " + exception);
        }
    }

    public static String getBuildingNumber() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("ERROR: Could not get local host name");
            return "0";
        }
        String string = inetAddress.getHostAddress();
        String string2 = PrintUtil.getSwitchIP(string);
        String string3 = PrintUtil.getSwitchName(string2);
        int n = string3.indexOf("-");
        String string4 = "";
        if (n != -1) {
            string4 = string3.substring(1, n);
        }
        return string4;
    }

    private static String getSwitchIP(String string) throws ArrayIndexOutOfBoundsException {
        String[] stringArray = new String[4];
        stringArray = string.split("\\.");
        String string2 = stringArray[0] + "." + stringArray[1] + "." + stringArray[2] + "." + (new Integer(stringArray[3]) / 64 * 64 + 3);
        return string2;
    }

    private static String getSwitchName(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getPrintersInBuilding(String string) throws Exception {
        URL uRL;
        if (string.compareTo("") == 0) {
            string = "0";
        }
        BufferedReader bufferedReader = null;
        string = string.trim().replace(' ', '_');
        try {
            String string2 = "http://service-print.web.cern.ch/service-print/cgi-bin/printer-result.plx?system=UNIX&building=" + string;
            uRL = new URL(string2);
            URLConnection uRLConnection = uRL.openConnection();
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string3 = new String();
            String string4 = new String();
            String string5 = new String();
            while ((string3 = bufferedReader.readLine()) != null) {
                string4 = string4 + string3 + "<myBreak/>";
            }
            Matcher matcher = Pattern.compile("^.*<textarea name=\"results\" rows=10 cols=40>(.*)</textarea>.*$").matcher(string4);
            if (!matcher.lookingAt()) {
                throw new Exception();
            }
            string5 = matcher.group(1);
            Object[] objectArray = string5.split("<myBreak/>");
            Arrays.sort(objectArray);
            if (objectArray.length == 1) {
                matcher = Pattern.compile("^.*Sorry, NONE found.*$").matcher((CharSequence)objectArray[0]);
                if (matcher.lookingAt()) {
                    String[] stringArray = null;
                    return stringArray;
                }
                Object[] objectArray2 = objectArray;
                return objectArray2;
            }
            Object[] objectArray3 = objectArray;
            return objectArray3;
        }
        catch (UnknownHostException unknownHostException) {
            uRL = null;
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
            return uRL;
        }
        catch (IOException iOException) {
            uRL = null;
            return uRL;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static String[] getPrintersInThisBuilding() throws Exception {
        return PrintUtil.getPrintersInBuilding(PrintUtil.getBuildingNumber());
    }

    public boolean printDialog() throws MissingPrintableObjectException {
        if (this.toPrint == null || !(this.toPrint instanceof Printable)) {
            throw new MissingPrintableObjectException();
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PrintService printService = printerJob.getPrintService();
        printService = null;
        if (printService != null) {
            PageFormat pageFormat = printerJob.defaultPage();
            pageFormat.setOrientation(0);
            PageFormat pageFormat2 = printerJob.pageDialog(pageFormat);
            printerJob.setPrintable(this.toPrint, pageFormat2);
            printerJob.setJobName("Laser AC");
            try {
                if (printerJob.printDialog()) {
                    printerJob.print();
                }
                return true;
            }
            catch (PrinterAbortException printerAbortException) {
                System.out.println("Printing terminated by user " + printerAbortException);
                return false;
            }
            catch (PrinterIOException printerIOException) {
                System.out.println("Printer Error " + printerIOException);
                return false;
            }
            catch (Exception exception) {
                System.out.println("Printer Error " + exception);
                return false;
            }
        }
        PrintDialog printDialog = new PrintDialog((Frame)new JFrame(), true);
        printDialog.show();
        if (printDialog.areSettingsOK()) {
            this.printerName = printDialog.getPrinterName();
            this.numberOfCopies = printDialog.getNumberOfCopies();
            this.isTwoSidePrint = printDialog.isTwoSidedPrint();
            this.isAllPagePrint = printDialog.isAllPagePrint();
            this.isRangePagePrint = printDialog.isRangePagePrint();
            this.rangeFrom = printDialog.getRangeFrom();
            this.rangeTo = printDialog.getRangeTo();
            this.isPrintToFile = printDialog.isPrintToFile();
            this.fileToPrint = printDialog.getFileToPrint();
            this.isLandscape = printDialog.isLandscape();
            this.settingsOK = true;
            return true;
        }
        return false;
    }

    public void print() throws SettingsNotCorrectException {
        if (!this.settingsOK) {
            throw new SettingsNotCorrectException();
        }
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        String string = DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType();
        StreamPrintServiceFactory[] streamPrintServiceFactoryArray = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(sERVICE_FORMATTED, string);
        if (streamPrintServiceFactoryArray.length == 0) {
            System.err.println("No suitable factories");
            System.exit(0);
        }
        try {
            File file = this.isPrintToFile ? this.fileToPrint : this.createTempFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            StreamPrintService streamPrintService = streamPrintServiceFactoryArray[0].getPrintService(fileOutputStream);
            DocPrintJob docPrintJob = streamPrintService.createPrintJob();
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            hashPrintRequestAttributeSet.add(new Copies(this.numberOfCopies));
            hashPrintRequestAttributeSet.add(new JobName("Laser AC", null));
            if (this.isLandscape) {
                hashPrintRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
            } else {
                hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
            }
            if (this.isTwoSidePrint) {
                hashPrintRequestAttributeSet.add(Sides.DUPLEX);
            } else {
                hashPrintRequestAttributeSet.add(Sides.ONE_SIDED);
            }
            if (this.isRangePagePrint) {
                hashPrintRequestAttributeSet.add(new PageRanges(this.rangeFrom, this.rangeTo));
            }
            SimpleDoc simpleDoc = new SimpleDoc(this.toPrint, sERVICE_FORMATTED, null);
            docPrintJob.print(simpleDoc, hashPrintRequestAttributeSet);
            if (!this.isPrintToFile) {
                this.print(file, 'o', this.printerName);
            }
            fileOutputStream.close();
        }
        catch (PrintException printException) {
            System.err.println(printException);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public void setPrintable(Printable printable) {
        this.toPrint = printable;
    }

    public static boolean checkPrinter(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string + ".print.cern.ch");
            return true;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = PrintUtil.getPrintersInBuilding("864");
            if (stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    System.out.println(stringArray2[i]);
                }
            } else {
                System.out.println("Sorry, none printers found");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("+++ Probably IT Printer Support Website has changed !");
        }
    }

    private File createTempFile() throws IOException {
        Random random = new Random();
        int n = 0;
        do {
            n = (random.nextInt() & Integer.MAX_VALUE) % 90000000 + 10000000;
        } while (new File("acout" + Integer.toString(n) + ".ps").exists());
        File file = File.createTempFile("ac" + Integer.toString(n), ".ps");
        file.deleteOnExit();
        return file;
    }

    public boolean print(File file, char c, String string) {
        this.sendStatus = 0;
        this.printerName = string;
        String string2 = String.valueOf(Character.toLowerCase(c));
        if (!(string2.equals("f") || string2.equals("l") || string2.equals("c") || string2.equals("d") || string2.equals("g") || string2.equals("n") || string2.equals("o") || string2.equals("p") || string2.equals("r") || string2.equals("t") || string2.equals("v"))) {
            System.out.println("ERROR: Invalid file type: " + string2);
            return false;
        }
        this.fileToPrint = file;
        String string3 = String.valueOf(this.nextJob);
        while (string3.length() < 3) {
            string3 = "0" + string3;
        }
        ++this.nextJob;
        if (this.nextJob == 1000) {
            this.nextJob = 1;
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("ERROR: Could not get local host name");
            return false;
        }
        this.cfName = new String("cfA" + string3 + inetAddress.getHostName());
        this.dfName = new String("dfA" + string3 + inetAddress.getHostName());
        this.controlFile = new String("H" + inetAddress.getHostName() + '\n' + "P" + this.userName + '\n');
        this.controlFile = this.jobName.equals("null") ? this.controlFile + "J" + this.fileToPrint.getName() + '\n' : this.controlFile + "J" + this.jobName + '\n';
        switch (this.printOptions) {
            case 1: {
                break;
            }
            case 2: {
                if (this.widthCode == -1) break;
                int n = 1;
                this.controlFile = this.controlFile + "I" + n + '\n' + "Z" + "XP_Width=" + this.widthCode + '\n';
                break;
            }
            case 3: {
                this.controlFile = this.controlFile + "Z" + this.pagePosition + "," + this.rectoVerso;
                if (this.widthCode != -1) {
                    this.controlFile = this.controlFile + ",XP_Width=" + this.widthCode;
                }
                this.controlFile = this.controlFile + '\n';
            }
        }
        this.controlFile = this.controlFile + string2 + this.dfName + '\n';
        InetAddress inetAddress2 = null;
        try {
            inetAddress2 = InetAddress.getByName(this.printerName + ".print.cern.ch");
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("ERROR: Unknown Host");
        }
        try {
            this.sock = new Socket(inetAddress2, 515, inetAddress, this.nextPort);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.sock == null) {
            try {
                this.sock = new Socket(inetAddress2, 515);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.sock == null) {
            System.out.println("ERROR: Cannot make a socket to the printer");
        }
        ++this.nextPort;
        if (this.nextPort == 732) {
            this.nextPort = 721;
        }
        if (this.sock != null) {
            boolean bl = false;
            boolean bl2 = true;
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(this.fileToPrint);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("ERROR: FileReader could not find the specified file");
                bl2 = false;
                this.sendStatus = 3;
            }
            if (bl2) {
                this.sendStatus = 1;
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
                    PrintWriter printWriter = new PrintWriter(this.sock.getOutputStream(), true);
                    printWriter.println("\u0002" + this.printerName);
                    if (PrintUtil.waitForData(bufferedReader, 30) && bufferedReader.read() == 0) {
                        printWriter.println("\u0002" + this.controlFile.length() + ' ' + this.cfName);
                        if (PrintUtil.waitForData(bufferedReader, 30) && bufferedReader.read() == 0) {
                            printWriter.print(this.controlFile + '\u0000');
                            printWriter.flush();
                            if (PrintUtil.waitForData(bufferedReader, 30) && bufferedReader.read() == 0) {
                                printWriter.println("\u0003" + this.fileToPrint.length() + ' ' + this.dfName);
                                if (PrintUtil.waitForData(bufferedReader, 30) && bufferedReader.read() == 0) {
                                    System.out.println("Sending Job Data...");
                                    while (fileReader.ready()) {
                                        printWriter.print((char)fileReader.read());
                                    }
                                    printWriter.print('\u0000');
                                    printWriter.flush();
                                    if (PrintUtil.waitForData(bufferedReader, 30) && bufferedReader.read() == 0) {
                                        System.out.println("...Job Data Sent");
                                        bl = true;
                                        this.sendStatus = 2;
                                    }
                                }
                            }
                        }
                    }
                    fileReader.close();
                    bufferedReader.close();
                    printWriter.close();
                    this.sock.close();
                    if (!bl) {
                        System.out.println("ERROR: Could not send job");
                        this.sendStatus = 3;
                    }
                }
                catch (IOException iOException) {
                    System.out.println("ERROR: IO Error: " + iOException);
                }
            }
        }
        return true;
    }

    private static boolean waitForData(BufferedReader bufferedReader, int n) throws IOException {
        long l = System.currentTimeMillis();
        while (!bufferedReader.ready() && System.currentTimeMillis() - l < (long)(n * 2000)) {
        }
        return bufferedReader.ready();
    }

    public class SettingsNotCorrectException
    extends Exception {
    }

    public class MissingPrintableObjectException
    extends Exception {
    }
}

