/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.printing;

import cern.laser.guiplatform.printing.DefaultPrinterDialog;
import cern.laser.guiplatform.printing.PrintUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class PrintDialog
extends JDialog {
    boolean settingsCorrect;
    File fileToPrint;
    private JTextField buildingNumber;
    private JButton cancelButton;
    private ButtonGroup directionGroup;
    private JRadioButton directionLandscape;
    private JRadioButton directionPortrait;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JSpinner numberOfCopies;
    private JRadioButton printAll;
    private JButton printButton;
    private JRadioButton printRange;
    private JCheckBox printToFile;
    private JCheckBox printTwoSided;
    private JComboBox printersCombo;
    private JTextField rangeFrom;
    private JTextField rangeTo;
    private ButtonGroup rangesGroup;
    private JButton refreshButton;

    public PrintDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.settingsCorrect = false;
        this.fileToPrint = null;
    }

    private void initComponents() {
        this.rangesGroup = new ButtonGroup();
        this.directionGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.buildingNumber = new JTextField();
        this.jLabel2 = new JLabel();
        this.printersCombo = new JComboBox();
        this.refreshButton = new JButton();
        this.jLabel3 = new JLabel();
        this.numberOfCopies = new JSpinner();
        this.printTwoSided = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.rangeFrom = new JTextField();
        this.printAll = new JRadioButton();
        this.printRange = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.rangeTo = new JTextField();
        this.printButton = new JButton();
        this.cancelButton = new JButton();
        this.printToFile = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.directionLandscape = new JRadioButton();
        this.directionPortrait = new JRadioButton();
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        this.setTitle("Print");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PrintDialog.this.closeDialog(windowEvent);
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                PrintDialog.this.formWindowOpened(windowEvent);
            }
        });
        this.jPanel1.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanel1.setBorder(new TitledBorder(null, "", 0, 0, new Font("Dialog", 1, 12)));
        this.jPanel1.setName("");
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setText("Building number");
        this.jPanel1.add((Component)this.jLabel1, new AbsoluteConstraints(10, 20, 120, 30));
        this.buildingNumber.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                PrintDialog.this.buildingNumberKeyReleased(keyEvent);
            }
        });
        this.jPanel1.add((Component)this.buildingNumber, new AbsoluteConstraints(130, 20, 80, 30));
        this.jLabel2.setText("Printers");
        this.jPanel1.add((Component)this.jLabel2, new AbsoluteConstraints(10, 60, 100, 30));
        this.printersCombo.setEditable(true);
        this.jPanel1.add((Component)this.printersCombo, new AbsoluteConstraints(130, 60, 220, -1));
        this.refreshButton.setText("Refresh printers");
        this.refreshButton.setBorder(new EtchedBorder());
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintDialog.this.refreshButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add((Component)this.refreshButton, new AbsoluteConstraints(240, 20, 110, 30));
        this.jLabel3.setText("Number of copies:");
        this.jPanel1.add((Component)this.jLabel3, new AbsoluteConstraints(10, 180, -1, 40));
        this.numberOfCopies.setName("");
        this.numberOfCopies.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PrintDialog.this.numberOfCopiesStateChanged(changeEvent);
            }
        });
        this.jPanel1.add((Component)this.numberOfCopies, new AbsoluteConstraints(130, 190, 60, 20));
        this.printTwoSided.setSelected(true);
        this.printTwoSided.setText("Print two sided    ");
        this.printTwoSided.setHorizontalTextPosition(2);
        this.jPanel1.add((Component)this.printTwoSided, new AbsoluteConstraints(220, 180, 160, 40));
        this.jLabel4.setText("Print pages");
        this.jPanel1.add((Component)this.jLabel4, new AbsoluteConstraints(10, 230, -1, 20));
        this.rangeFrom.setEditable(false);
        this.jPanel1.add((Component)this.rangeFrom, new AbsoluteConstraints(240, 260, 40, -1));
        this.printAll.setSelected(true);
        this.printAll.setText("All");
        this.rangesGroup.add(this.printAll);
        this.printAll.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PrintDialog.this.printAllStateChanged(changeEvent);
            }
        });
        this.jPanel1.add((Component)this.printAll, new AbsoluteConstraints(130, 230, -1, -1));
        this.printRange.setText("Pages");
        this.rangesGroup.add(this.printRange);
        this.jPanel1.add((Component)this.printRange, new AbsoluteConstraints(130, 260, -1, -1));
        this.jLabel5.setText("from:");
        this.jPanel1.add((Component)this.jLabel5, new AbsoluteConstraints(200, 260, -1, 20));
        this.jLabel6.setText("to:");
        this.jPanel1.add((Component)this.jLabel6, new AbsoluteConstraints(290, 260, -1, 20));
        this.rangeTo.setEditable(false);
        this.jPanel1.add((Component)this.rangeTo, new AbsoluteConstraints(310, 260, 40, -1));
        this.printButton.setText("Print");
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintDialog.this.printButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add((Component)this.printButton, new AbsoluteConstraints(80, 300, -1, -1));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add((Component)this.cancelButton, new AbsoluteConstraints(230, 300, -1, -1));
        this.printToFile.setText("Print to file     ");
        this.printToFile.setHorizontalTextPosition(2);
        this.jPanel1.add((Component)this.printToFile, new AbsoluteConstraints(240, 100, 120, 40));
        this.jLabel7.setText("Direction :");
        this.jPanel1.add((Component)this.jLabel7, new AbsoluteConstraints(10, 100, -1, 40));
        this.directionLandscape.setText("Landscape");
        this.directionGroup.add(this.directionLandscape);
        this.jPanel1.add((Component)this.directionLandscape, new AbsoluteConstraints(130, 110, -1, -1));
        this.directionPortrait.setSelected(true);
        this.directionPortrait.setText("Portrait");
        this.directionGroup.add(this.directionPortrait);
        this.jPanel1.add((Component)this.directionPortrait, new AbsoluteConstraints(130, 140, -1, -1));
        this.getContentPane().add((Component)this.jPanel1, new AbsoluteConstraints(0, -10, 380, 340));
        this.pack();
    }

    private void printButtonActionPerformed(ActionEvent actionEvent) {
        int n;
        String string = this.getPrinterName();
        if (string.compareTo("") == 0 && !this.isPrintToFile()) {
            this.settingsCorrect = false;
            JOptionPane.showMessageDialog(null, "Printer name cannot be empty", "Error", 0);
            return;
        }
        if (!PrintUtil.checkPrinter(string) && !this.isPrintToFile()) {
            this.settingsCorrect = false;
            JOptionPane.showMessageDialog(null, "Printer does not exist", "Error", 0);
            return;
        }
        if (!this.isAllPagePrint()) {
            if (this.rangeFrom.getText().compareTo("") == 0 || this.rangeTo.getText().compareTo("") == 0) {
                this.settingsCorrect = false;
                JOptionPane.showMessageDialog(null, "Page range cannot be empty", "Error", 0);
                return;
            }
            try {
                int n2 = this.getRangeFrom();
                n = this.getRangeTo();
                if (n2 < 1 || n < 1 || n2 > n) {
                    this.settingsCorrect = false;
                    JOptionPane.showMessageDialog(null, "Page range is not correct", "Error", 0);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.settingsCorrect = false;
                JOptionPane.showMessageDialog(null, "Page range is not correct", "Error", 0);
                return;
            }
        }
        if (this.isPrintToFile()) {
            JFileChooser jFileChooser = new JFileChooser();
            n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                this.fileToPrint = jFileChooser.getSelectedFile();
            } else {
                this.settingsCorrect = false;
                return;
            }
        }
        this.settingsCorrect = true;
        this.closeDialog(null);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.closeDialog(null);
    }

    private void numberOfCopiesStateChanged(ChangeEvent changeEvent) {
        if ((Integer)this.numberOfCopies.getValue() < 1) {
            this.numberOfCopies.setValue(new Integer(1));
        }
    }

    private void printAllStateChanged(ChangeEvent changeEvent) {
        if (this.printAll.isSelected()) {
            this.rangeFrom.setEditable(false);
            this.rangeTo.setEditable(false);
        } else {
            this.rangeFrom.setEditable(true);
            this.rangeTo.setEditable(true);
        }
    }

    private void buildingNumberKeyReleased(KeyEvent keyEvent) {
        this.refreshButtonActionPerformed(null);
    }

    private void refreshButtonActionPerformed(ActionEvent actionEvent) {
        try {
            boolean bl;
            String string = DefaultPrinterDialog.getDefaultPrinterName();
            String[] stringArray = PrintUtil.getPrintersInBuilding(this.buildingNumber.getText());
            this.printersCombo.removeAllItems();
            boolean bl2 = bl = string == null;
            if (string != null) {
                string = string.toLowerCase();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.printersCombo.addItem(stringArray[i]);
                if (bl || !stringArray[i].equals(string)) continue;
                this.printersCombo.setSelectedItem(stringArray[i]);
                bl = true;
            }
            if (!bl && string != null) {
                this.printersCombo.addItem(string);
                this.printersCombo.setSelectedItem(string);
            }
        }
        catch (Exception exception) {
            System.out.println("Problem with obtaining printers!");
        }
    }

    private void formWindowOpened(WindowEvent windowEvent) {
        boolean bl;
        String string = DefaultPrinterDialog.getDefaultPrinterName();
        String string2 = PrintUtil.getBuildingNumber();
        this.buildingNumber.setText(string2);
        boolean bl2 = bl = string == null;
        if (string != null) {
            string = string.toLowerCase();
        }
        try {
            String[] stringArray = PrintUtil.getPrintersInThisBuilding();
            for (int i = 0; i < stringArray.length; ++i) {
                this.printersCombo.addItem(stringArray[i]);
                if (bl || !stringArray[i].equals(string)) continue;
                this.printersCombo.setSelectedItem(stringArray[i]);
                bl = true;
            }
            if (!bl && string != null) {
                this.printersCombo.addItem(string);
                this.printersCombo.setSelectedItem(string);
            }
        }
        catch (Exception exception) {
            System.out.println("Problem with obtaining printers!");
        }
        this.numberOfCopies.setValue(new Integer(1));
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public String getPrinterName() {
        return this.printersCombo.getSelectedItem().toString();
    }

    public int getNumberOfCopies() {
        return new Integer(this.numberOfCopies.getValue().toString());
    }

    public boolean isTwoSidedPrint() {
        return this.printTwoSided.isSelected();
    }

    public boolean isAllPagePrint() {
        return this.printAll.isSelected();
    }

    public boolean isRangePagePrint() {
        return this.printRange.isSelected();
    }

    public int getRangeFrom() {
        if (this.rangeFrom.getText().compareTo("") == 0) {
            return -1;
        }
        return new Integer(this.rangeFrom.getText());
    }

    public int getRangeTo() {
        if (this.rangeTo.getText().compareTo("") == 0) {
            return -1;
        }
        return new Integer(this.rangeTo.getText());
    }

    public boolean isPrintToFile() {
        return this.printToFile.isSelected();
    }

    public File getFileToPrint() {
        return this.fileToPrint;
    }

    public boolean areSettingsOK() {
        return this.settingsCorrect;
    }

    public boolean isLandscape() {
        return this.directionLandscape.isSelected();
    }

    public static void main(String[] stringArray) {
        new PrintDialog((Frame)new JFrame(), true).show();
    }
}

