/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.printing;

import cern.laser.console.LaserConsoleException;
import cern.laser.console.User;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.LogFactory;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class DefaultPrinterDialog
extends JDialog {
    protected static Logger logger = LogFactory.getLogger(DefaultPrinterDialog.class.getName());
    private JButton cancelButton;
    private JTextField defaultPrinterTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JButton saveButton;

    public DefaultPrinterDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    private void initComponents() {
        this.defaultPrinterTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        this.setTitle("Default Printer Configuration");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DefaultPrinterDialog.this.closeDialog(windowEvent);
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                DefaultPrinterDialog.this.formWindowOpened(windowEvent);
            }
        });
        this.getContentPane().add((Component)this.defaultPrinterTextField, new AbsoluteConstraints(170, 30, 210, 20));
        this.jLabel1.setText("Default printer name");
        this.getContentPane().add((Component)this.jLabel1, new AbsoluteConstraints(20, 30, -1, -1));
        this.jLabel2.setFont(new Font("Dialog", 0, 12));
        this.jLabel2.setText("i.e. 936-r030-tek");
        this.getContentPane().add((Component)this.jLabel2, new AbsoluteConstraints(260, 60, -1, -1));
        this.saveButton.setText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultPrinterDialog.this.saveButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add((Component)this.saveButton, new AbsoluteConstraints(20, 100, 90, -1));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultPrinterDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add((Component)this.cancelButton, new AbsoluteConstraints(290, 100, 90, -1));
        this.pack();
    }

    private void saveButtonActionPerformed(ActionEvent actionEvent) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Connection problem. The printer will not be saved.", 0);
        User user = AppRegister.getInstance().getRegisteredUser();
        if (user == null) {
            logger.debug((Object)"User in AppRegister is empty");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            this.closeDialog(null);
            return;
        }
        try {
            user.setDefaultPrinter(this.defaultPrinterTextField.getText());
            logger.debug((Object)"default printer stored");
        }
        catch (LaserConsoleException laserConsoleException) {
            logger.debug((Object)"Cannot save user's default printer");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        this.closeDialog(null);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.closeDialog(null);
    }

    private void formWindowOpened(WindowEvent windowEvent) {
        User user = AppRegister.getInstance().getRegisteredUser();
        if (user == null) {
            return;
        }
        try {
            String string = user.getDefaultPrinter();
            this.defaultPrinterTextField.setText(string);
        }
        catch (LaserConsoleException laserConsoleException) {
            logger.debug((Object)"Cannot get user's default printer");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)("Connection problem [" + ((Object)((Object)laserConsoleException)).getClass().getName() + "]"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            this.closeDialog(null);
        }
    }

    public static String getDefaultPrinterName() {
        User user = AppRegister.getInstance().getRegisteredUser();
        if (user != null) {
            try {
                logger.debug((Object)"got user's default printer");
                return user.getDefaultPrinter();
            }
            catch (LaserConsoleException laserConsoleException) {
                logger.debug((Object)"Cannot get user's default printer");
            }
        }
        return null;
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        new DefaultPrinterDialog((Frame)new JFrame(), true).show();
    }
}

