/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.explorer;

import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.alarms.AlarmBeanNode;
import cern.laser.guiplatform.alarms.AlarmNodeManagerImpl;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.LogFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RepaintManager;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.log4j.Logger;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;

public class ACTreeTableView
extends TreeTableView
implements Printable {
    private Node nodes;
    private static Logger logger = LogFactory.getLogger(AlarmNodeManagerImpl.class.getName());

    public ACTreeTableView(Node node) {
        this.nodes = node;
        logger.debug((Object)"constructor VIEW");
        this.treeTable.setOpaque(true);
        this.treeTable.setSelectionBackground(Color.BLACK);
        this.treeTable.setSelectionForeground(Color.YELLOW);
        this.treeTable.setBackground(Color.BLACK);
        this.treeTable.setForeground(new Color(155, 155, 155));
        this.treeTable.setFocusable(true);
        this.treeTable.setGridColor(new Color(70, 92, 113));
        this.treeTable.setRowHeight(50);
    }

    public void setRenderers() {
        logger.debug((Object)"setRenderer()");
        try {
            this.treeTable.getColumnModel().getColumn(0).setMinWidth(30);
            this.treeTable.getColumnModel().getColumn(0).setMaxWidth(150);
            this.treeTable.getColumnModel().getColumn(0).setPreferredWidth(50);
            this.treeTable.getColumnModel().getColumn(1).setMinWidth(50);
            this.treeTable.getColumnModel().getColumn(1).setMaxWidth(150);
            this.treeTable.getColumnModel().getColumn(1).setPreferredWidth(80);
            this.treeTable.getColumnModel().getColumn(2).setMinWidth(50);
            this.treeTable.getColumnModel().getColumn(2).setMaxWidth(150);
            this.treeTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        for (int i = 0; i < this.treeTable.getColumnModel().getColumnCount(); ++i) {
            this.treeTable.getColumnModel().getColumn(i).setCellRenderer(new MyTableCellRenderer(Color.LIGHT_GRAY, this));
            this.treeTable.getColumnModel().getColumn(i).setHeaderRenderer(new MyTableHeaderRenderer(Color.GRAY, this));
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JTextField());
            defaultCellEditor.setClickCountToStart(8);
            this.treeTable.getColumnModel().getColumn(i).setCellEditor(defaultCellEditor);
        }
        this.setRowHeight(AppRegister.getInstance().getFontSize() + 4);
    }

    public void setRowHeight(final int n) {
        new Thread(){

            @Override
            public void run() {
                ACTreeTableView.this.treeTable.setRowHeight(n);
            }
        }.start();
    }

    public Node getNodes() {
        return this.nodes;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        RepaintManager.currentManager((JComponent)((Object)this)).setDoubleBufferingEnabled(false);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.black);
        graphics2D.setFont(new Font("Arial", 0, 10));
        int n2 = graphics2D.getFontMetrics().getHeight();
        int n3 = graphics2D.getFontMetrics().getDescent();
        double d = pageFormat.getImageableHeight() - (double)n2;
        double d2 = pageFormat.getImageableWidth();
        double d3 = this.treeTable.getColumnModel().getTotalColumnWidth();
        double d4 = 1.0;
        if (d3 >= d2) {
            d4 = d2 / d3;
        }
        double d5 = (double)this.treeTable.getTableHeader().getHeight() * d4;
        double d6 = d3 * d4;
        double d7 = (double)(this.treeTable.getRowHeight() + this.treeTable.getRowMargin()) * d4;
        int n4 = (int)((d - d5) / d7);
        double d8 = d7 * (double)n4;
        int n5 = (int)Math.ceil((double)this.treeTable.getRowCount() / (double)n4);
        if (n >= n5) {
            return 1;
        }
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.drawString("Page: " + (n + 1) + "of " + n5, (int)d2 / 2 - 35, (int)(d + (double)n2 - (double)n3));
        graphics2D.translate(0.0, d5);
        graphics2D.translate(0.0, (double)(-n) * d8);
        if (n + 1 == n5) {
            int n6 = n4 * n;
            int n7 = this.treeTable.getRowCount() - n6;
            graphics2D.setClip(0, (int)(d8 * (double)n), (int)Math.ceil(d6), (int)Math.ceil(d7 * (double)n7));
        } else {
            graphics2D.setClip(0, (int)(d8 * (double)n), (int)Math.ceil(d6), (int)Math.ceil(d8));
        }
        graphics2D.scale(d4, d4);
        this.treeTable.paint(graphics2D);
        graphics2D.scale(1.0 / d4, 1.0 / d4);
        graphics2D.translate(0.0, (double)n * d8);
        graphics2D.translate(0.0, -d5);
        graphics2D.setClip(0, 0, (int)Math.ceil(d6), (int)Math.ceil(d5));
        graphics2D.scale(d4, d4);
        this.treeTable.getTableHeader().paint(graphics2D);
        RepaintManager.currentManager((JComponent)((Object)this)).setDoubleBufferingEnabled(true);
        return 0;
    }

    class MyTableHeaderRenderer
    extends DefaultTableCellRenderer {
        Color backgroundColor;
        ACTreeTableView view;

        public MyTableHeaderRenderer(ACTreeTableView aCTreeTableView2) {
            this.backgroundColor = Color.GRAY;
            this.setOpaque(true);
            this.view = aCTreeTableView2;
        }

        public MyTableHeaderRenderer(Color color, ACTreeTableView aCTreeTableView2) {
            this.backgroundColor = color;
            this.setOpaque(true);
            this.view = aCTreeTableView2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setEnabled(jTable == null || jTable.isEnabled());
            this.setOpaque(true);
            this.setBackground(new Color(188, 188, 188));
            this.setForeground(Color.BLACK);
            this.setVerticalTextPosition(0);
            return this;
        }

        @Override
        public void setValue(Object object) {
            try {
                PropertySupport.Reflection reflection = (PropertySupport.Reflection)object;
                try {
                    if (reflection != null) {
                        this.setText(reflection.getValue().toString());
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
            catch (ClassCastException classCastException) {
                super.setValue(object);
            }
        }
    }

    class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        Color backgroundColor;
        ACTreeTableView view;

        public MyTableCellRenderer(ACTreeTableView aCTreeTableView2) {
            this.backgroundColor = Color.GRAY;
            this.setOpaque(true);
            this.view = aCTreeTableView2;
        }

        public MyTableCellRenderer(Color color, ACTreeTableView aCTreeTableView2) {
            this.backgroundColor = color;
            this.setOpaque(true);
            this.view = aCTreeTableView2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setEnabled(true);
            if (n >= 0) {
                try {
                    AlarmBeanNode alarmBeanNode = (AlarmBeanNode)this.view.getNodes().getChildren().getNodes()[n];
                    try {
                        AlarmBean alarmBean = (AlarmBean)alarmBeanNode.getBean();
                        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                        switch (n2) {
                            case 0: {
                                this.setIcon(new ImageIcon(alarmBean.getNodeIcon(bl)));
                                this.setBackground(alarmBean.getStandardBackgroundColor());
                                this.setForeground(alarmBean.getForegroundColor());
                                this.setFont(alarmBean.getFont());
                                break;
                            }
                            case 1: {
                                if (alarmBean.isNew()) {
                                    object = "   N";
                                    this.setBackground(alarmBean.getStandardForegroundColor());
                                    this.setForeground(alarmBean.getStandardBackgroundColor());
                                    super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                                    this.setFont(alarmBean.getFont());
                                    break;
                                }
                                this.setBackground(alarmBean.getBackgroundColor());
                                this.setForeground(alarmBean.getForegroundColor());
                                this.setFont(alarmBean.getFont());
                                break;
                            }
                            default: {
                                this.setBackground(alarmBean.getBackgroundColor());
                                this.setForeground(alarmBean.getForegroundColor());
                                this.setFont(alarmBean.getFont());
                                break;
                            }
                        }
                    }
                    catch (ClassCastException classCastException) {
                        logger.debug((Object)("ClassCastException obj=" + alarmBeanNode.getBean()));
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    logger.debug((Object)("IndexOutOfBoundsException, row=" + n));
                }
            }
            return this;
        }

        @Override
        public void setValue(Object object) {
            try {
                PropertySupport.Reflection reflection = (PropertySupport.Reflection)object;
                try {
                    if (reflection != null) {
                        this.setText(reflection.getValue().toString());
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            catch (ClassCastException classCastException) {
                super.setValue(object);
            }
        }
    }
}

