/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.alarms.helpers;

import cern.laser.client.data.Status;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;

public class StatusImpl
implements Status,
Cloneable {
    private static long timeMillis = -1L;
    private boolean active;
    private boolean masked;
    private boolean reduced;
    private Timestamp sourceTimestamp;
    private String sourceHostname;
    private Timestamp userTimestamp;
    private Timestamp systemTimestamp;
    private Properties userProperties;

    public StatusImpl(boolean bl, boolean bl2, boolean bl3) {
        this.active = bl;
        this.reduced = bl3;
        this.masked = bl2;
        this.sourceTimestamp = new Timestamp(timeMillis);
        this.sourceHostname = "sourceHostname";
        this.userTimestamp = new Timestamp(timeMillis);
        this.systemTimestamp = new Timestamp(timeMillis);
        this.userProperties = new Properties();
        this.userProperties.put("property1", "property1");
        this.userProperties.put("property2", "");
        this.userProperties.put("property3", "property3");
        this.userProperties.put("property4", "");
    }

    public StatusImpl(boolean bl) {
        this(bl, false, false);
    }

    private StatusImpl(Status status) {
        if (status == null) {
            throw new IllegalArgumentException("parameter can not be null");
        }
        this.active = status.isActive();
        this.masked = status.isMasked();
        this.reduced = status.isReduced();
        this.sourceHostname = new String(status.getSourceHostname());
        this.sourceTimestamp = (Timestamp)status.getSourceTimestamp().clone();
        this.userTimestamp = (Timestamp)status.getUserTimestamp().clone();
        this.systemTimestamp = (Timestamp)status.getSystemTimestamp().clone();
        this.userProperties = new Properties(status.getUserProperties());
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isMasked() {
        return this.masked;
    }

    public boolean isReduced() {
        return this.reduced;
    }

    public String getSourceHostname() {
        return this.sourceHostname;
    }

    public Timestamp getSourceTimestamp() {
        return this.sourceTimestamp;
    }

    public Timestamp getUserTimestamp() {
        return this.userTimestamp;
    }

    public Timestamp getSystemTimestamp() {
        return this.systemTimestamp;
    }

    public Properties getUserProperties() {
        return this.userProperties;
    }

    public Object clone() throws CloneNotSupportedException {
        return new StatusImpl(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nACTIVE : ");
        stringBuffer.append(this.isActive());
        stringBuffer.append("\nMASKED : ");
        stringBuffer.append(this.isMasked());
        stringBuffer.append("\nREDUCED : ");
        stringBuffer.append(this.isReduced());
        stringBuffer.append("\nSOURCE HOSTNAME : ");
        stringBuffer.append(this.getSourceHostname());
        stringBuffer.append("\nSOURCE TIMESTAMP : ");
        stringBuffer.append(this.getSourceTimestamp());
        stringBuffer.append("\nUSER TIMESTAMP : ");
        stringBuffer.append(this.getUserTimestamp());
        stringBuffer.append("\nSYSTEM TIMESTAMP : ");
        stringBuffer.append(this.getSystemTimestamp());
        stringBuffer.append("\nUSER PROPERTIES : \n");
        stringBuffer.append(this.getUserProperties());
        return stringBuffer.toString();
    }

    static {
        Calendar calendar = Calendar.getInstance();
        timeMillis = calendar.getTime().getTime();
    }
}

