/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.alarms.helpers;

import cern.laser.client.data.Alarm;
import cern.laser.client.data.Category;
import cern.laser.client.data.Location;
import cern.laser.client.data.ResponsiblePerson;
import cern.laser.client.data.Source;
import cern.laser.client.data.Status;
import cern.laser.client.data.Triplet;
import cern.laser.guiplatform.alarms.helpers.LocationImpl;
import cern.laser.guiplatform.alarms.helpers.ResponsiblePersonImpl;
import cern.laser.guiplatform.alarms.helpers.SourceImpl;
import cern.laser.guiplatform.alarms.helpers.StatusImpl;
import cern.laser.guiplatform.alarms.helpers.TripletImpl;
import cern.laser.guiplatform.category.helpers.CategoryImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class AlarmImpl
implements Alarm,
Cloneable {
    private String alarmId;
    private Triplet triplet;
    private String problemDescription;
    private Integer priority;
    private Source source;
    private Location location;
    private URL helpURL;
    private ResponsiblePerson responsiblePerson;
    private Collection categories;
    private Status status;
    private boolean instant;
    private boolean nodeParent;
    private boolean multiplicityParent;
    private boolean nodeChild;
    private boolean multiplicityChild;
    private String systemName;
    private String identifier;
    private String consequence;
    private String action;
    private String cause;

    public AlarmImpl(String string, boolean bl, String string2, String string3, int n) {
        this(string, bl, false, false, string2, string3, n);
    }

    public AlarmImpl(String string, boolean bl, boolean bl2, boolean bl3, String string2, String string3, int n) {
        this.alarmId = string;
        this.triplet = new TripletImpl(string2, string3, n);
        this.problemDescription = "problem Description";
        this.source = new SourceImpl();
        this.location = new LocationImpl();
        this.helpURL = null;
        this.responsiblePerson = new ResponsiblePersonImpl();
        this.categories = new ArrayList();
        this.categories.add(new CategoryImpl("category1", "category1 description"));
        this.categories.add(new CategoryImpl("category2", "category2 description"));
        this.categories.add(new CategoryImpl("category3", "category3 description"));
        this.categories.add(new CategoryImpl("category4", "category4 description"));
        this.status = new StatusImpl(bl, bl3, bl2);
        this.instant = false;
        this.nodeParent = false;
        this.multiplicityParent = false;
        this.nodeChild = false;
        this.multiplicityChild = false;
        this.systemName = "systemName";
        this.identifier = "system identifier";
        this.consequence = "consequence";
        this.action = "action";
        this.cause = "cause";
    }

    private AlarmImpl(Alarm alarm) throws CloneNotSupportedException {
        if (alarm == null) {
            throw new IllegalArgumentException("parameter can not be null");
        }
        this.alarmId = alarm.getAlarmId();
        this.triplet = (Triplet)alarm.getTriplet().clone();
        this.problemDescription = new String(alarm.getProblemDescription());
        this.priority = alarm.getPriority();
        this.source = (Source)alarm.getSource().clone();
        this.location = (Location)alarm.getLocation().clone();
        try {
            this.helpURL = alarm.getHelpURL() == null ? null : new URL(alarm.getHelpURL().toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            this.helpURL = null;
        }
        this.responsiblePerson = (ResponsiblePerson)alarm.getResponsiblePerson().clone();
        this.categories = new ArrayList();
        Iterator iterator = alarm.getCategories().iterator();
        while (iterator.hasNext()) {
            this.categories.add(((Category)iterator.next()).clone());
        }
        this.status = (Status)alarm.getStatus().clone();
        this.instant = alarm.isInstant();
        this.systemName = alarm.getSystemName();
        this.identifier = alarm.getIdentifier();
        this.consequence = alarm.getConsequence();
        this.action = alarm.getAction();
        this.cause = alarm.getCause();
    }

    public String getAlarmId() {
        return this.alarmId;
    }

    public Triplet getTriplet() {
        return this.triplet;
    }

    public String getProblemDescription() {
        return this.problemDescription;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = new Integer(n);
    }

    public Source getSource() {
        return this.source;
    }

    public Location getLocation() {
        return this.location;
    }

    public URL getHelpURL() {
        return this.helpURL;
    }

    public Collection getCategories() {
        return this.categories;
    }

    public ResponsiblePerson getResponsiblePerson() {
        return this.responsiblePerson;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isInstant() {
        return this.instant;
    }

    public void setIsInstant(boolean bl) {
        this.instant = bl;
    }

    public boolean isNodeParent() {
        return this.nodeParent;
    }

    public boolean isMultiplicityParent() {
        return this.multiplicityParent;
    }

    public boolean isNodeChild() {
        return this.nodeChild;
    }

    public boolean isMultiplicityChild() {
        return this.multiplicityChild;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getConsequence() {
        return this.consequence;
    }

    public String getAction() {
        return this.action;
    }

    public String getCause() {
        return this.cause;
    }

    public String getPiquetEmail() {
        return "piquetEmail";
    }

    public String getPiquetGSM() {
        return "piquetGSM";
    }

    public boolean equals(Object object) {
        if (!(object instanceof Alarm)) {
            return false;
        }
        Alarm alarm = (Alarm)object;
        return this.getAlarmId() == alarm.getAlarmId();
    }

    public Object clone() throws CloneNotSupportedException {
        return new AlarmImpl(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nALARM :");
        stringBuffer.append("\nID : ");
        stringBuffer.append(this.getAlarmId());
        stringBuffer.append("\nTRIPLET : ");
        stringBuffer.append(this.getTriplet());
        stringBuffer.append("\nPROBLEM DESCRIPTION : ");
        stringBuffer.append(this.getProblemDescription());
        stringBuffer.append("\nPRIORITY : ");
        stringBuffer.append(this.getPriority());
        stringBuffer.append("\nHELP URL : ");
        stringBuffer.append(this.getHelpURL());
        stringBuffer.append("\nINSTANT : ");
        stringBuffer.append(this.isInstant());
        stringBuffer.append("\nNODE PARENT : ");
        stringBuffer.append(this.isNodeParent());
        stringBuffer.append("\nMULTIPLICITY PARENT : ");
        stringBuffer.append(this.isMultiplicityParent());
        stringBuffer.append("\nLOCATION : ");
        stringBuffer.append(this.getLocation());
        stringBuffer.append("\nSOURCE : ");
        stringBuffer.append(this.getSource());
        stringBuffer.append("\nRESPONSIBLE : ");
        stringBuffer.append(this.getResponsiblePerson());
        stringBuffer.append("\nSTATUS : ");
        stringBuffer.append(this.getStatus());
        stringBuffer.append("\nCATEGORIES : ");
        stringBuffer.append(this.getCategories());
        return stringBuffer.toString();
    }
}

