/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.actions.configuration;

import cern.laser.client.LaserException;
import cern.laser.guiplatform.actions.support.CallableSystemAction;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import cern.laser.guiplatform.windows.configuration.ConsoleConfigurationWindow;
import java.awt.EventQueue;
import java.beans.IntrospectionException;
import org.apache.log4j.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class ConfigurationWindowAction
extends CallableSystemAction {
    private static Logger logger = LogFactory.getLogger(ConfigurationWindowAction.class.getName());

    @Override
    public void performAction() {
        String string = NbBundle.getMessage(ConsoleConfigurationWindow.class, (String)"LBL_ConsoleConfigurationWindow_component_name");
        TopComponent topComponent = AcWindowManager.findTopComponent(string);
        if (topComponent != null) {
            logger.debug((Object)("TopComponent: " + string + " found"));
            topComponent.requestFocus();
        } else {
            try {
                final ConsoleConfigurationWindow consoleConfigurationWindow = new ConsoleConfigurationWindow(AppRegister.getInstance().getRegisteredUser(), AppRegister.getInstance().getLoadedConfiguration());
                consoleConfigurationWindow.open();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ((ConsoleConfigurationWindow)consoleConfigurationWindow).loadAllCategoriesInTreeExplorer();
                        }
                        catch (IntrospectionException introspectionException) {
                            logger.error((Object)introspectionException.getMessage(), (Throwable)introspectionException);
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Unable to create configuration window", 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            logger.error((Object)cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Unable to create configuration window", 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        }
                    }
                };
                EventQueue.invokeLater(runnable);
            }
            catch (LaserException laserException) {
                logger.error((Object)laserException.getMessage(), (Throwable)laserException);
                logger.error((Object)laserException.getRootCause().getMessage(), laserException.getRootCause());
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Unable to create configuration window", 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        }
    }

    @Override
    public String getName() {
        return "Configuration";
    }

    protected String iconResource() {
        return "org/openide/resources/actions/addWatch.gif";
    }

    @Override
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void initialize() {
        super.initialize();
    }
}

