/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.actions.configuration;

import cern.gp.actions.support.NodeAction;
import cern.gp.nodes.GPNode;
import cern.gp.nodes.children.NodeList;
import cern.laser.client.LaserException;
import cern.laser.console.Configuration;
import cern.laser.console.LaserConfigurationDuplicationException;
import cern.laser.console.LaserConfigurationNotFoundException;
import cern.laser.console.LaserConsoleException;
import cern.laser.console.User;
import cern.laser.guiplatform.configuration.ConfigurationBean;
import cern.laser.guiplatform.user.UserHandlerFactory;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import cern.laser.guiplatform.windows.configuration.ConsoleConfigurationWindow;
import java.beans.IntrospectionException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class ConfigurationSetAsDefaultAction
extends NodeAction {
    static final Logger logger = LogFactory.getLogger(ConfigurationSetAsDefaultAction.class.getName());
    private static final String setAsDefaultStr = NbBundle.getMessage(ConfigurationSetAsDefaultAction.class, (String)"LBL_ConfigurationSetAsDefaultAction_name");

    public String getName() {
        return setAsDefaultStr;
    }

    protected String iconResource() {
        return "org/openide/resources/actions/default.gif";
    }

    protected void performAction(GPNode[] gPNodeArray) {
        String string = gPNodeArray[0].getName();
        String string2 = gPNodeArray[0].getPeerNode().getParentNode().getName();
        logger.debug((Object)("selected configuration name: " + string));
        logger.debug((Object)("configuration user name: " + string2));
        try {
            User user = AppRegister.getInstance().getRegisteredUser();
            if (!user.getName().equals(string2)) {
                this.copyAndSetAsDefaultConfiguration(string, string2);
            } else {
                user.setDefaultConfiguration(string);
                Iterator iterator = ((NodeList)gPNodeArray[0].getParent().getNodeCollection()).iterator();
                while (iterator.hasNext()) {
                    ConfigurationBean configurationBean = (ConfigurationBean)((Object)((GPNode)iterator.next()).getBean());
                    if (!configurationBean.getIsDefault()) continue;
                    configurationBean.setIsDefault(false);
                    break;
                }
                ((ConfigurationBean)((Object)gPNodeArray[0].getBean())).setIsDefault(true);
            }
        }
        catch (LaserConfigurationNotFoundException laserConfigurationNotFoundException) {
            logger.warn((Object)laserConfigurationNotFoundException, laserConfigurationNotFoundException.fillInStackTrace());
            this.copyAndSetAsDefaultConfiguration(string, string2);
        }
        catch (LaserConfigurationDuplicationException laserConfigurationDuplicationException) {
            logger.warn((Object)laserConfigurationDuplicationException, laserConfigurationDuplicationException.fillInStackTrace());
        }
        catch (LaserConsoleException laserConsoleException) {
            logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
            AcWindowManager.notifyError("Internal error.\nSee log files or contact console developers.");
        }
    }

    protected boolean enable(Node[] nodeArray) {
        return nodeArray.length == 1 && ((GPNode)nodeArray[0]).getBean() instanceof ConfigurationBean && super.enable(nodeArray);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private void copyAndSetAsDefaultConfiguration(String string, String string2) {
        try {
            User user = AppRegister.getInstance().getRegisteredUser();
            User user2 = UserHandlerFactory.getHandler().getUser(string2);
            Configuration configuration = user2.getConfiguration(string);
            boolean bl = false;
            String string3 = configuration.getName();
            while (!bl) {
                Object object;
                try {
                    Configuration configuration2 = user.createConfiguration(string3);
                    configuration2.setBehaviour(configuration.getBehaviour());
                    configuration2.setSelection(configuration.getSelection());
                    configuration2.setHighlighted(configuration.getHighlighted());
                    configuration2.setAutoHighlighted(configuration.getAutoHighlighted());
                    configuration2.setAutoKlaxoned(configuration.getAutoKlaxoned());
                    configuration2.setInhibited(configuration.getInhibited());
                    configuration2.setMasked(configuration.getMasked());
                    user.setDefaultConfiguration(configuration2.getName());
                    object = new ConfigurationBean(configuration2);
                    TopComponent.Registry registry = TopComponent.getRegistry();
                    ConsoleConfigurationWindow consoleConfigurationWindow = (ConsoleConfigurationWindow)registry.getActivated();
                    if (consoleConfigurationWindow == null) {
                        throw new NullPointerException("Configuratrion window not found");
                    }
                    consoleConfigurationWindow.addConfigurationToList((ConfigurationBean)((Object)object));
                    bl = true;
                }
                catch (LaserConfigurationDuplicationException laserConfigurationDuplicationException) {
                    object = new NotifyDescriptor.InputLine(NbBundle.getMessage(ConfigurationSetAsDefaultAction.class, (String)"New_Configuration_name_string"), NbBundle.getMessage(ConfigurationSetAsDefaultAction.class, (String)"Configuration_Already_Exists_string", (Object)string3), 2, 0);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)object) == NotifyDescriptor.OK_OPTION) {
                        string3 = object.getInputText();
                        continue;
                    }
                    bl = true;
                }
            }
        }
        catch (LaserConsoleException laserConsoleException) {
            logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
            AcWindowManager.notifyError("Internal error.\nSee log files or contact console developers.");
        }
        catch (LaserException laserException) {
            logger.error((Object)laserException, laserException.fillInStackTrace());
            AcWindowManager.notifyError("Internal error.\nSee log files or contact console developers.");
        }
        catch (IntrospectionException introspectionException) {
            logger.error((Object)introspectionException, introspectionException.fillInStackTrace());
            AcWindowManager.notifyError("Internal error.\nSee log files or contact console developers.");
        }
    }
}

