/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.actions.category;

import cern.gp.actions.support.NodeAction;
import cern.gp.nodes.GPNode;
import cern.laser.client.LaserException;
import cern.laser.client.data.Alarm;
import cern.laser.client.services.browsing.AlarmBrowsingHandler;
import cern.laser.console.CommentedAlarm;
import cern.laser.guiplatform.alarms.AlarmBrowsingHandlerFactory;
import cern.laser.guiplatform.alarms.InfoAlarmBean;
import cern.laser.guiplatform.category.CategoryBean;
import cern.laser.guiplatform.util.Constants;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import cern.laser.guiplatform.windows.alarms.AlarmInfoExplorer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class ShowAlarmByCategoryAction
extends NodeAction {
    private static final String name = NbBundle.getMessage(ShowAlarmByCategoryAction.class, (String)"LBL_Action_ShowAlarmByCategoryAction_action_name");
    private static final Logger logger = LogFactory.getLogger(ShowAlarmByCategoryAction.class.getName());

    protected void performAction(GPNode[] gPNodeArray) {
        AcWindowManager.setStatusText("Show alarm by category action is running .......");
        CategoryBean categoryBean = (CategoryBean)gPNodeArray[0].getBean();
        logger.debug((Object)("cateogory Id: " + categoryBean.getCategoryId()));
        AlarmBrowsingHandler alarmBrowsingHandler = null;
        AlarmInfoExplorer alarmInfoExplorer = null;
        ArrayList<InfoAlarmBean> arrayList = new ArrayList<InfoAlarmBean>();
        try {
            alarmBrowsingHandler = AlarmBrowsingHandlerFactory.getHandler();
            Collection collection = alarmBrowsingHandler.getAlarmsByCategory(categoryBean.getCategoryId());
            GPNode[] gPNodeArray2 = new GPNode[collection.size()];
            boolean bl = false;
            for (Alarm alarm : collection) {
                CommentedAlarm commentedAlarm = new CommentedAlarm(alarm, null);
                InfoAlarmBean infoAlarmBean = new InfoAlarmBean(commentedAlarm);
                infoAlarmBean.setInfoMode(true);
                arrayList.add(infoAlarmBean);
            }
            TopComponent topComponent = AcWindowManager.findTopComponent(NbBundle.getMessage(AlarmInfoExplorer.class, (String)"LBL_AlarmInfoExplorer_component_name"));
            if (topComponent != null) {
                alarmInfoExplorer = (AlarmInfoExplorer)topComponent;
                alarmInfoExplorer.update(arrayList, "Alarms belonging to " + categoryBean.getPath() + " category");
                logger.debug((Object)"expl found");
            } else {
                logger.debug((Object)"expl not found");
                alarmInfoExplorer = new AlarmInfoExplorer(arrayList, "Alarms belonging to " + categoryBean.getPath() + " category", Constants.getColumnsToDisplay());
                alarmInfoExplorer.open();
            }
            alarmInfoExplorer.requestFocus();
        }
        catch (LaserException laserException) {
            logger.error((Object)laserException.getMessage(), (Throwable)laserException);
            logger.error((Object)laserException.getRootCause().getMessage(), laserException.getRootCause());
            AcWindowManager.notifyError("Can't dispaly alarms.\nAlrmBrowsinHandler can't be found.\nCan't connect to database.");
        }
        AcWindowManager.setStatusText("Show alarm by category action finished");
    }

    protected boolean enable(Node[] nodeArray) {
        return nodeArray.length == 1;
    }

    public String getName() {
        return name;
    }

    protected String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

