/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.actions.category;

import cern.gp.actions.support.NodeAction;
import cern.gp.nodes.GPNode;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windows.configuration.ConsoleConfigurationWindow;
import cern.laser.guiplatform.windows.search.CategorySelectorWindow;
import java.beans.IntrospectionException;
import org.apache.log4j.Logger;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class DeleteChoosenCategoryAction
extends NodeAction {
    static final Logger logger = LogFactory.getLogger(DeleteChoosenCategoryAction.class.getName());
    private final String deleteStr = NbBundle.getMessage(DeleteChoosenCategoryAction.class, (String)"LBL_DeleteChoosenCategoryAction_name");

    protected boolean enable(Node[] nodeArray) {
        return nodeArray.length > 0 && super.enable(nodeArray);
    }

    protected void performAction(GPNode[] gPNodeArray) {
        for (int i = 0; i < gPNodeArray.length; ++i) {
            logger.debug((Object)gPNodeArray[i].getName());
        }
        TopComponent.Registry registry = TopComponent.getRegistry();
        if (registry.getActivated() instanceof ConsoleConfigurationWindow) {
            ConsoleConfigurationWindow consoleConfigurationWindow = (ConsoleConfigurationWindow)registry.getActivated();
            if (consoleConfigurationWindow == null) {
                throw new NullPointerException("Configuratrion window not found");
            }
            for (int i = 0; i < gPNodeArray.length; ++i) {
                try {
                    consoleConfigurationWindow.removeCategory(gPNodeArray[i]);
                    consoleConfigurationWindow.updateCategoryTreeExplorer();
                    continue;
                }
                catch (IntrospectionException introspectionException) {
                    introspectionException.printStackTrace();
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
            }
        } else if (registry.getActivated() instanceof CategorySelectorWindow) {
            CategorySelectorWindow categorySelectorWindow = (CategorySelectorWindow)registry.getActivated();
            if (categorySelectorWindow == null) {
                throw new NullPointerException("Configuratrion window not found");
            }
            for (int i = 0; i < gPNodeArray.length; ++i) {
                try {
                    categorySelectorWindow.removeCategory(gPNodeArray[i]);
                    categorySelectorWindow.updateCategoryTreeExplorer();
                    continue;
                }
                catch (IntrospectionException introspectionException) {
                    introspectionException.printStackTrace();
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public String getName() {
        return this.deleteStr;
    }

    protected String iconResource() {
        return "org/openide/resources/actions/delete.gif";
    }

    protected boolean surviveFocusChange() {
        return false;
    }
}

