/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.actions.category;

import cern.gp.actions.support.NodeAction;
import cern.gp.nodes.GPNode;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windows.configuration.ConsoleConfigurationWindow;
import cern.laser.guiplatform.windows.search.CategorySelectorWindow;
import java.beans.IntrospectionException;
import org.apache.log4j.Logger;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class CategoryCopyOverNodesAction
extends NodeAction {
    protected static final Logger logger = LogFactory.getLogger(CategoryCopyOverNodesAction.class.getName());
    private static final String addStr = NbBundle.getMessage(CategoryCopyOverNodesAction.class, (String)"LBL_CategoryCopyOverNodesAction_name");

    protected boolean enable(Node[] nodeArray) {
        return super.enable(nodeArray);
    }

    protected void performAction(GPNode[] gPNodeArray, Object object) {
    }

    public String getName() {
        return addStr;
    }

    protected String iconResource() {
        return "org/openide/resources/actions/save.gif";
    }

    protected void performAction(GPNode[] gPNodeArray) {
        TopComponent.Registry registry = TopComponent.getRegistry();
        logger.debug((Object)("registry=" + registry + " activated=" + registry.getActivated().getClass().getName()));
        if (registry.getActivated() instanceof ConsoleConfigurationWindow) {
            ConsoleConfigurationWindow consoleConfigurationWindow = (ConsoleConfigurationWindow)registry.getActivated();
            logger.debug((Object)("confWindow=" + (Object)((Object)consoleConfigurationWindow)));
            if (consoleConfigurationWindow == null) {
                throw new NullPointerException("Configuratrion window not found");
            }
            for (int i = 0; i < gPNodeArray.length; ++i) {
                try {
                    GPNode gPNode = gPNodeArray[i];
                    consoleConfigurationWindow.addCategory(gPNode);
                    consoleConfigurationWindow.updateCategoryTreeExplorer();
                    continue;
                }
                catch (IntrospectionException introspectionException) {
                    introspectionException.printStackTrace();
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
            }
        } else if (registry.getActivated() instanceof CategorySelectorWindow) {
            CategorySelectorWindow categorySelectorWindow = (CategorySelectorWindow)registry.getActivated();
            logger.debug((Object)("confWindow=" + (Object)((Object)categorySelectorWindow)));
            if (categorySelectorWindow == null) {
                throw new NullPointerException("Configuratrion window not found");
            }
            for (int i = 0; i < gPNodeArray.length; ++i) {
                try {
                    GPNode gPNode = gPNodeArray[i];
                    categorySelectorWindow.addCategory(gPNode);
                    categorySelectorWindow.updateCategoryTreeExplorer();
                    continue;
                }
                catch (IntrospectionException introspectionException) {
                    introspectionException.printStackTrace();
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected boolean surviveFocusChange() {
        return false;
    }
}

