/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.actions.alarms;

import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.alarms.AlarmBeanNode;
import cern.laser.guiplatform.alarms.AlarmContainer;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import cern.laser.guiplatform.windows.ActiveListExplorerPanel;
import org.apache.log4j.Logger;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class UninhibitAction
extends NodeAction {
    private static final String name = NbBundle.getMessage(UninhibitAction.class, (String)"LBL_Action_Uninhibit_action_name");
    private static final Logger logger = LogFactory.getLogger(UninhibitAction.class.getName());

    protected String iconResource() {
        return null;
    }

    public String getName() {
        return name;
    }

    protected boolean enable(Node[] nodeArray) {
        boolean bl = false;
        for (int i = 0; i < nodeArray.length; ++i) {
            try {
                AlarmBean alarmBean = (AlarmBean)((AlarmBeanNode)nodeArray[i]).getBean();
                logger.debug((Object)("inhibited=" + alarmBean.isAlarmNodeInhibited()));
                logger.debug((Object)("on highlighted list=" + alarmBean.isOnHighlightedList()));
                if (!alarmBean.isAlarmNodeInhibited() || alarmBean.isOnHighlightedList()) continue;
                bl = true;
                break;
            }
            catch (ClassCastException classCastException) {
                logger.debug((Object)("ClassCastException obj=" + nodeArray[i]));
                return false;
            }
        }
        return bl;
    }

    protected void performAction(Node[] nodeArray) {
        AcWindowManager.setStatusText("Uninhibit action is running ..........");
        AlarmBean[] alarmBeanArray = new AlarmBean[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            alarmBeanArray[i] = (AlarmBean)((AlarmBeanNode)nodeArray[i]).getBean();
        }
        AlarmContainer.getDefault().uninhibit(alarmBeanArray);
        AcWindowManager.setZeroSelectedNodes(NbBundle.getMessage(ActiveListExplorerPanel.class, (String)"LBL_Inhibit_list_component_name"));
        AcWindowManager.setStatusText("Uninhibit action finished");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

