/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.actions.alarms;

import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.alarms.AlarmBeanNode;
import cern.laser.guiplatform.alarms.AlarmContainer;
import cern.laser.guiplatform.util.LogFactory;
import org.apache.log4j.Logger;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class UnhighlightAction
extends NodeAction {
    private static final String name = NbBundle.getMessage(UnhighlightAction.class, (String)"LBL_Action_Unhighlight_action_name");
    private static final Logger logger = LogFactory.getLogger(UnhighlightAction.class.getName());

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < nodeArray.length; ++i) {
            try {
                AlarmBean alarmBean = (AlarmBean)((AlarmBeanNode)nodeArray[i]).getBean();
                if (alarmBean.isAlarmNodeActive() && alarmBean.isAlarmNodeHighlighted()) continue;
                bl = false;
                break;
            }
            catch (ClassCastException classCastException) {
                logger.debug((Object)("ClassCastException obj=" + nodeArray[i]));
                return false;
            }
        }
        return bl;
    }

    public String getName() {
        return name;
    }

    protected String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void performAction(Node[] nodeArray) {
        AlarmBean[] alarmBeanArray = new AlarmBean[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            alarmBeanArray[i] = (AlarmBean)((AlarmBeanNode)nodeArray[i]).getBean();
        }
        AlarmContainer.getDefault().highlight(alarmBeanArray, false);
    }
}

