/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.actions.alarms;

import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.alarms.AlarmBeanNode;
import cern.laser.guiplatform.alarms.AlarmContainer;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import org.apache.log4j.Logger;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class UnacknowledgeAction
extends NodeAction {
    private static final String name = NbBundle.getMessage(UnacknowledgeAction.class, (String)"LBL_UnacknowledgeAction_action_name");
    private static final Logger logger = LogFactory.getLogger(UnacknowledgeAction.class.getName());

    public String getName() {
        return name;
    }

    protected boolean enable(Node[] nodeArray) {
        boolean bl = false;
        for (int i = 0; i < nodeArray.length; ++i) {
            try {
                AlarmBean alarmBean = (AlarmBean)((AlarmBeanNode)nodeArray[i]).getBean();
                if (!alarmBean.isAlarmNodeAcknowledged() || alarmBean.isOnHighlightedList() || alarmBean.isAlarmNodeInhibited()) continue;
                bl = true;
                break;
            }
            catch (ClassCastException classCastException) {
                logger.debug((Object)("ClassCastException obj=" + nodeArray[i]));
                return false;
            }
        }
        return bl;
    }

    protected void performAction(Node[] nodeArray) {
        AcWindowManager.setStatusText("Unacknowledge action is running .......");
        AlarmBean[] alarmBeanArray = new AlarmBean[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            alarmBeanArray[i] = (AlarmBean)((AlarmBeanNode)nodeArray[i]).getBean();
        }
        AlarmContainer.getDefault().acknowledge(alarmBeanArray, false, null);
        AcWindowManager.setStatusText("Unacknowledge action finished");
    }

    protected String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

