/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.actions.alarms;

import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.alarms.AlarmBeanNode;
import cern.laser.guiplatform.util.BrowserLauncher;
import cern.laser.guiplatform.util.LogFactory;
import java.net.URL;
import org.apache.log4j.Logger;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class ShowHelpUrlInBrowserAction
extends NodeAction {
    private static final String name = NbBundle.getMessage(ShowHelpUrlInBrowserAction.class, (String)"LBL_Action_ShowHelpUrlInBrowser_action_name");
    private static final Logger logger = LogFactory.getLogger(ShowHelpUrlInBrowserAction.class.getName());

    protected boolean enable(Node[] nodeArray) {
        boolean bl = true;
        for (int i = 0; i < nodeArray.length; ++i) {
            try {
                AlarmBean alarmBean = (AlarmBean)((AlarmBeanNode)nodeArray[i]).getBean();
                if (alarmBean.getCommentedAlarm().getAlarm().getHelpURL() != null) continue;
                bl = false;
                break;
            }
            catch (ClassCastException classCastException) {
                logger.debug((Object)("ClassCastException obj=" + nodeArray[i]));
                return false;
            }
        }
        return bl;
    }

    public String getName() {
        return name;
    }

    protected String iconResource() {
        return "cern/laser/guiplatform/images/url.gif";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void performAction(Node[] nodeArray) {
        try {
            for (int i = 0; i < nodeArray.length; ++i) {
                URL uRL = ((AlarmBean)((AlarmBeanNode)nodeArray[i]).getBean()).getCommentedAlarm().getAlarm().getHelpURL();
                BrowserLauncher.openURL(uRL.toExternalForm());
            }
        }
        catch (Exception exception) {
            logger.debug((Object)exception.getMessage());
        }
    }
}

