/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.actions.alarms;

import cern.laser.console.Comment;
import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.alarms.AlarmBeanNode;
import cern.laser.guiplatform.alarms.AlarmContainer;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import cern.laser.guiplatform.windows.ActiveListExplorerPanel;
import cern.laser.guiplatform.windows.alarms.AlarmCommentPanel;
import java.beans.PropertyVetoException;
import org.apache.log4j.Logger;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class InhibitAction
extends NodeAction {
    private static final String name = NbBundle.getMessage(InhibitAction.class, (String)"LBL_Action_Inhibit_action_name");
    private static final Logger logger = LogFactory.getLogger(InhibitAction.class.getName());

    public String getName() {
        return name;
    }

    protected String iconResource() {
        return null;
    }

    protected boolean enable(Node[] nodeArray) {
        boolean bl = false;
        for (int i = 0; i < nodeArray.length; ++i) {
            try {
                AlarmBeanNode alarmBeanNode = (AlarmBeanNode)nodeArray[i];
                logger.debug((Object)("enable(), alarmBeanNode has bean=" + alarmBeanNode.getBean()));
                AlarmBean alarmBean = (AlarmBean)alarmBeanNode.getBean();
                logger.debug((Object)("active=" + alarmBean.isAlarmNodeActive()));
                logger.debug((Object)("on highlighted list=" + alarmBean.isOnHighlightedList()));
                if (!alarmBean.isAlarmNodeActive() || alarmBean.isOnHighlightedList()) continue;
                bl = true;
                break;
            }
            catch (ClassCastException classCastException) {
                logger.debug((Object)("ClassCastException obj=" + nodeArray[i]));
                return false;
            }
        }
        return bl;
    }

    protected void performAction(Node[] nodeArray) {
        String string = AppRegister.getInstance().getRegisteredUserName();
        String string2 = null;
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)new AlarmCommentPanel(string, string2), NbBundle.getMessage(AlarmCommentPanel.class, (String)"LBL_COMMENT_ON_INHIBITED_ALARM_display_name"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        AcWindowManager.setStatusText("Inhibit action is running .........");
        AlarmCommentPanel alarmCommentPanel = (AlarmCommentPanel)dialogDescriptor.getMessage();
        Comment comment = new Comment(alarmCommentPanel.getOperatorName(), alarmCommentPanel.getCommnet());
        AlarmBean[] alarmBeanArray = new AlarmBean[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            alarmBeanArray[i] = (AlarmBean)((AlarmBeanNode)nodeArray[i]).getBean();
        }
        AlarmContainer.getDefault().inhibit(alarmBeanArray, comment);
        ActiveListExplorerPanel activeListExplorerPanel = (ActiveListExplorerPanel)AcWindowManager.findTopComponent(NbBundle.getMessage(ActiveListExplorerPanel.class, (String)"LBL_Active_list_component_name"));
        if (activeListExplorerPanel != null) {
            logger.debug((Object)"inhibit list panel found");
            try {
                activeListExplorerPanel.getExplorerManager().setSelectedNodes(new Node[0]);
            }
            catch (PropertyVetoException propertyVetoException) {
                logger.error((Object)propertyVetoException, propertyVetoException.fillInStackTrace());
            }
        }
        AcWindowManager.setStatusText("Inhibit action finished");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

