/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.actions.alarms;

import cern.laser.console.Comment;
import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.alarms.AlarmBeanNode;
import cern.laser.guiplatform.alarms.AlarmContainer;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import cern.laser.guiplatform.windows.alarms.AlarmCommentPanel;
import cern.laser.guiplatform.windows.alarms.ChooseHighlightOrKlaxonPanel;
import org.apache.log4j.Logger;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class HighlightedAndKlaxonAction
extends NodeAction {
    private static final String name = NbBundle.getMessage(HighlightedAndKlaxonAction.class, (String)"LBL_Action_HighlightAndKlaxon_action_name");
    private static final Logger logger = LogFactory.getLogger(HighlightedAndKlaxonAction.class.getName());

    public String getName() {
        return name;
    }

    protected String iconResource() {
        return null;
    }

    protected boolean enable(Node[] nodeArray) {
        boolean bl = false;
        for (int i = 0; i < nodeArray.length; ++i) {
            try {
                AlarmBean alarmBean = (AlarmBean)((AlarmBeanNode)nodeArray[i]).getBean();
                if (alarmBean.isAlarmNodeHighlightedAndKlaxon()) continue;
                bl = true;
                break;
            }
            catch (ClassCastException classCastException) {
                logger.debug((Object)("ClassCastException obj=" + nodeArray[i]));
                return false;
            }
        }
        return bl;
    }

    protected void performAction(Node[] nodeArray) {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)new ChooseHighlightOrKlaxonPanel(), NbBundle.getMessage(ChooseHighlightOrKlaxonPanel.class, (String)"LBL_HIGHLIGHT_OR_KLAXON_dialog_title"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (!dialogDescriptor.getValue().equals(NotifyDescriptor.OK_OPTION)) {
            return;
        }
        String string = AppRegister.getInstance().getRegisteredUserName();
        String string2 = null;
        DialogDescriptor dialogDescriptor2 = new DialogDescriptor((Object)new AlarmCommentPanel(string, string2), NbBundle.getMessage(AlarmCommentPanel.class, (String)"LBL_COMMENT_ON_HIGHLIGHTED_AND_KLAXON_ALARM_display_name"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor2) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        AcWindowManager.setStatusText("Highlight And Klaxon action is running .......");
        AlarmCommentPanel alarmCommentPanel = (AlarmCommentPanel)dialogDescriptor2.getMessage();
        Comment comment = new Comment(alarmCommentPanel.getOperatorName(), alarmCommentPanel.getCommnet());
        AlarmBean[] alarmBeanArray = new AlarmBean[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            alarmBeanArray[i] = (AlarmBean)((AlarmBeanNode)nodeArray[i]).getBean();
        }
        ChooseHighlightOrKlaxonPanel chooseHighlightOrKlaxonPanel = (ChooseHighlightOrKlaxonPanel)dialogDescriptor.getMessage();
        int n = chooseHighlightOrKlaxonPanel.getHighlightedOrKlaxon();
        AlarmContainer.getDefault().highlightAndKlaxon(alarmBeanArray, comment, n);
        AcWindowManager.setStatusText("Highlight And Klaxon action finished");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

