/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.actions;

import cern.laser.guiplatform.actions.support.CallableSystemAction;
import cern.laser.guiplatform.printing.PrintUtil;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import cern.laser.guiplatform.windows.ActiveListExplorerPanel;
import org.apache.log4j.Logger;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PrintActiveListAction
extends CallableSystemAction {
    private static Logger logger = LogFactory.getLogger(PrintActiveListAction.class.getName());

    @Override
    public void performAction() {
        PrintUtil printUtil = new PrintUtil();
        ActiveListExplorerPanel activeListExplorerPanel = AppRegister.getInstance().getRegisteredActiveListExplorerPanel();
        printUtil.setPrintable(activeListExplorerPanel.getView());
        try {
            if (printUtil.printDialog()) {
                AcWindowManager.setStatusText("Print action is running .......");
                printUtil.print();
                AcWindowManager.setStatusText("Print action is finished .......");
            }
        }
        catch (PrintUtil.MissingPrintableObjectException missingPrintableObjectException) {
            missingPrintableObjectException.printStackTrace();
        }
        catch (PrintUtil.SettingsNotCorrectException settingsNotCorrectException) {
            settingsNotCorrectException.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(PrintActiveListAction.class, (String)"LBL_PrintActiveListAction");
    }

    protected String iconResource() {
        return "org/openide/resources/actions/print.gif";
    }

    @Override
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

