/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.status;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.jk.status.AbstractJkStatusTask;
import org.apache.tools.ant.BuildException;

public class JkStatusUpdateWorkerTask
extends AbstractJkStatusTask {
    private static final String info = "org.apache.jk.status.JkStatusUpdateWorkerTask/1.0";
    protected String loadbalancer;
    protected String worker;
    protected int loadfactor = -1;
    protected String route;
    protected int distance = -1;
    protected String redirect;
    protected String domain;
    protected int activationCode = -1;
    protected String activation;

    public String getInfo() {
        return info;
    }

    public JkStatusUpdateWorkerTask() {
        this.setUrl("http://localhost/jkstatus");
    }

    public String getActivation() {
        return this.activation;
    }

    public void setActivation(String activation) {
        this.activation = activation;
    }

    public int getActivationCode() {
        return this.activationCode;
    }

    public void setActivationCode(int activationCode) {
        this.activationCode = activationCode;
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getLoadbalancer() {
        return this.loadbalancer;
    }

    public void setLoadbalancer(String loadbalancer) {
        this.loadbalancer = loadbalancer;
    }

    public int getLoadfactor() {
        return this.loadfactor;
    }

    public void setLoadfactor(int loadfactor) {
        this.loadfactor = loadfactor;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    public String getRoute() {
        return this.route;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public String getWorker() {
        return this.worker;
    }

    public void setWorker(String worker) {
        this.worker = worker;
    }

    protected StringBuffer createLink() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("?cmd=update&mime=txt");
            sb.append("&w=");
            sb.append(URLEncoder.encode(this.loadbalancer, this.getCharset()));
            sb.append("&sw=");
            sb.append(URLEncoder.encode(this.worker, this.getCharset()));
            if (this.loadfactor >= 0) {
                sb.append("&wf=");
                sb.append(this.loadfactor);
            }
            if (this.route != null) {
                sb.append("&wn=");
                sb.append(URLEncoder.encode(this.route, this.getCharset()));
            }
            if (this.activation == null && this.activationCode > 0 && this.activationCode < 4) {
                sb.append("&wa=");
                sb.append(this.activation);
            }
            if (this.activation != null) {
                sb.append("&wa=");
                sb.append(URLEncoder.encode(this.activation, this.getCharset()));
            }
            if (this.distance >= 0) {
                sb.append("&wd=");
                sb.append(this.distance);
            }
            if (this.redirect != null) {
                sb.append("&wr=");
                sb.append(URLEncoder.encode(this.redirect, this.getCharset()));
            }
            if (this.domain != null) {
                sb.append("&wc=");
                sb.append(URLEncoder.encode(this.domain, this.getCharset()));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new BuildException("Invalid 'charset' attribute: " + this.getCharset());
        }
        return sb;
    }

    protected void checkParameter() {
        if (this.worker == null) {
            throw new BuildException("Must specify 'worker' attribute");
        }
        if (this.loadbalancer == null) {
            throw new BuildException("Must specify 'loadbalancer' attribute");
        }
    }
}

