/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import oracle.net.jdbc.nl.RepConversion;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class Packet
implements SQLnetDef {
    private int buffer2send;
    protected int sdu;
    protected int tdu;
    protected int length;
    public int type;
    protected int flags;
    protected int dataLen;
    protected int dataOff;
    protected String data;
    protected byte[] buffer;
    protected byte[] header = new byte[8];
    public SessionAtts sAtts;

    public Packet(SessionAtts sessionAtts) {
        this.sAtts = sessionAtts;
        this.sdu = sessionAtts.getSDU();
        this.tdu = sessionAtts.getTDU();
    }

    public Packet(SessionAtts sessionAtts, int n2) {
        this(sessionAtts);
        this.createBuffer(n2);
    }

    public Packet(SessionAtts sessionAtts, int n2, int n3, int n4) {
        this(sessionAtts);
        this.createBuffer(n2, n3, n4);
    }

    public Packet(Packet packet) {
        this(packet.sAtts);
        this.length = packet.length;
        this.type = packet.type;
        this.flags = packet.flags;
        this.dataLen = packet.dataLen;
        this.dataOff = packet.dataOff;
        this.buffer = packet.buffer;
    }

    protected void createBuffer(int n2) {
        this.buffer = new byte[n2];
        this.buffer[0] = (byte)(n2 / 256);
        this.buffer[1] = (byte)(n2 % 256);
    }

    protected void createBuffer(int n2, int n3, int n4) {
        this.buffer = new byte[n2];
        this.buffer[0] = (byte)(n2 / 256);
        this.buffer[1] = (byte)(n2 % 256);
        this.buffer[5] = (byte)n4;
        this.buffer[4] = (byte)n3;
    }

    protected void receive() throws IOException, NetException {
        int n2 = 0;
        while (n2 < this.header.length) {
            try {
                if ((n2 += this.sAtts.ntInputStream.read(this.header, n2, this.header.length - n2)) > 0) continue;
                throw new NetException(0);
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new NetException(504);
            }
        }
        this.length = this.header[0] & 0xFF;
        this.length <<= 8;
        this.length |= this.header[1] & 0xFF;
        this.type = this.header[4];
        this.flags = this.header[5];
        if (this.type > 19) {
            throw new NetException(204);
        }
        if (this.length > Short.MAX_VALUE || this.length > this.sdu) {
            throw new NetException(203);
        }
        if (this.length < 8) {
            throw new NetException(207);
        }
        this.buffer[5] = (byte)this.flags;
        this.buffer[4] = (byte)this.type;
        while (n2 < this.length) {
            try {
                if ((n2 += this.sAtts.ntInputStream.read(this.buffer, n2, this.length - n2)) > 0) continue;
                throw new NetException(0);
            }
            catch (InterruptedIOException interruptedIOException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send() throws IOException {
        OutputStream outputStream = this.sAtts.ntOutputStream;
        synchronized (outputStream) {
            this.sAtts.ntOutputStream.write(this.buffer, 0, this.buffer.length);
        }
    }

    protected void extractData() throws IOException, NetException {
        if (this.dataLen <= 0) {
            this.data = new String();
        } else if (this.length > this.dataOff) {
            this.data = new String(this.buffer, 0, this.dataOff, this.dataLen);
        } else {
            byte[] byArray = new byte[this.dataLen];
            if (this.sAtts.nsInputStream.read(byArray) < 0) {
                throw new NetException(0);
            }
            this.data = new String(byArray, 0);
        }
    }

    protected String getData() {
        return this.data;
    }

    protected void dump(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        System.out.println("Packet dump");
        System.out.println("buffer.length=" + byArray.length);
        System.out.println("offset       =" + n2);
        System.out.println("len          =" + n3);
        for (int i2 = n2; i2 < n3; i2 += 8) {
            System.out.print("|");
            for (int i3 = 0; i3 < 8 && n4 < n3 - 1; ++i3) {
                n4 = i2 + i3;
                RepConversion.printInHex(byArray[n4]);
                System.out.print(" ");
            }
            System.out.println("|");
        }
        System.out.println("finish dump");
    }
}

