/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.ngasLogger;

import alma.acs.logging.AcsLogLevel;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class NgasLog {
    public static final SimpleDateFormat df = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'.'SSS");
    public static final MessageFormat ngaslogformat = new MessageFormat("{0} [{1}] {2} [{3}:{4}:{5}:{6}:{7}]");
    public static final MessageFormat ngasfirstlogmesformat = new MessageFormat("NG/AMS Local Log File Rotated ({0})");
    public static final MessageFormat ngaslastlogmesformat = new MessageFormat("Rotating log file: {0} -> {1}");
    long utctimestamp;
    Level level;
    String message;
    String src_file;
    String src_function;
    Long src_lineno;
    String pid;
    String threadname;

    public NgasLog(String string) throws ParseException {
        Object[] objectArray = ngaslogformat.parse(string);
        this.utctimestamp = df.parse((String)objectArray[0]).getTime();
        this.level = AcsLogLevel.parse((String)((String)objectArray[1]));
        this.message = (String)objectArray[2];
        this.src_file = (String)objectArray[3];
        this.src_function = (String)objectArray[4];
        this.src_lineno = new Long((String)objectArray[5]);
        this.pid = (String)objectArray[6];
        this.threadname = (String)objectArray[7];
    }

    public LogRecord get_LogRecord() throws UnknownHostException {
        LogRecord logRecord = new LogRecord(this.level, this.message);
        logRecord.setMillis(this.utctimestamp);
        logRecord.setLoggerName("NGAS");
        logRecord.setSourceClassName(this.src_file);
        logRecord.setSourceMethodName(this.src_function);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Line", this.src_lineno);
        hashMap.put("isAcsPropertiesMap", Boolean.TRUE);
        hashMap.put("HostName", InetAddress.getLocalHost().getHostName());
        hashMap.put("Context", new String("PID-" + this.pid));
        hashMap.put("ThreadName", this.threadname);
        logRecord.setParameters(new Object[]{hashMap});
        return logRecord;
    }

    public static String createNgasLog(long l, Level level, String string, String string2, String string3, Long l2, String string4, String string5) {
        Object[] objectArray = new Object[]{df.format(new Date(l)), level, string, string2, string3, l2, string4, string5};
        return ngaslogformat.format(objectArray);
    }

    public static String createNgasFirstLog(long l, String string, Long l2, String string2) {
        Object[] objectArray = new Object[]{string};
        String string3 = ngasfirstlogmesformat.format(objectArray);
        return NgasLog.createNgasLog(l, Level.INFO, string3, "threading.py", "run", l2, string2, "JANITOR-THREAD");
    }

    public static String createNgasLastLog(long l, String string, String string2, Long l2, String string3) {
        Object[] objectArray = new Object[]{string, string2};
        String string4 = ngaslastlogmesformat.format(objectArray);
        return NgasLog.createNgasLog(l, Level.INFO, string4, "threading.py", "run", l2, string3, "JANITOR-THREAD");
    }

    public Boolean isLastLog() {
        if (this.message.startsWith("Rotating log file")) {
            return true;
        }
        return false;
    }

    public String getRotatedFile() throws ParseException {
        if (this.isLastLog().booleanValue()) {
            Object[] objectArray = ngaslastlogmesformat.parse(this.message);
            return (String)objectArray[1];
        }
        return "";
    }
}

