/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.launch;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.Locale;

public final class Locator {
    private static final int NIBBLE = 4;
    private static final int NIBBLE_MASK = 15;
    private static final int ASCII_SIZE = 128;
    private static final int BYTE_SIZE = 256;
    private static final int WORD = 16;
    private static final int SPACE = 32;
    private static final int DEL = 127;
    public static final String URI_ENCODING = "UTF-8";
    private static boolean[] gNeedEscaping = new boolean[128];
    private static char[] gAfterEscaping1 = new char[128];
    private static char[] gAfterEscaping2 = new char[128];
    private static char[] gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String ERROR_NOT_FILE_URI = "Can only handle valid file: URIs, not ";

    private Locator() {
    }

    public static File getClassSource(Class clazz) {
        String string = clazz.getName().replace('.', '/') + ".class";
        return Locator.getResourceSource(clazz.getClassLoader(), string);
    }

    public static File getResourceSource(ClassLoader classLoader, String string) {
        if (classLoader == null) {
            classLoader = Locator.class.getClassLoader();
        }
        URL uRL = null;
        uRL = classLoader == null ? ClassLoader.getSystemResource(string) : classLoader.getResource(string);
        if (uRL != null) {
            String string2 = uRL.toString();
            try {
                if (string2.startsWith("jar:file:")) {
                    int n = string2.indexOf("!");
                    String string3 = string2.substring("jar:".length(), n);
                    return new File(Locator.fromURI(string3));
                }
                if (string2.startsWith("file:")) {
                    int n = string2.indexOf(string);
                    String string4 = string2.substring(0, n);
                    return new File(Locator.fromURI(string4));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return null;
    }

    public static String fromURI(String string) {
        String string2 = null;
        if (string2 == null) {
            string2 = Locator.fromURIJava13(string);
        }
        return string2;
    }

    private static String fromUriJava14(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.net.URI");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        if (clazz != null && string.startsWith("file:/")) {
            try {
                Method method = clazz.getMethod("create", String.class);
                Object object = method.invoke(null, Locator.encodeURI(string));
                Constructor constructor = File.class.getConstructor(clazz);
                File file = (File)constructor.newInstance(object);
                return Locator.decodeUri(file.getAbsolutePath());
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof IllegalArgumentException) {
                    throwable.printStackTrace();
                } else {
                    throwable.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    static String fromURIJava13(String string) {
        String string2;
        int n;
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL == null || !"file".equals(uRL.getProtocol())) {
            throw new IllegalArgumentException(ERROR_NOT_FILE_URI + string);
        }
        StringBuffer stringBuffer = new StringBuffer(uRL.getHost());
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, File.separatorChar).insert(0, File.separatorChar);
        }
        stringBuffer.append((n = (string2 = uRL.getFile()).indexOf(63)) < 0 ? string2 : string2.substring(0, n));
        string = stringBuffer.toString().replace('/', File.separatorChar);
        if (File.pathSeparatorChar == ';' && string.startsWith("\\") && string.length() > 2 && Character.isLetter(string.charAt(1)) && string.lastIndexOf(58) > -1) {
            string = string.substring(1);
        }
        String string3 = null;
        try {
            string3 = Locator.decodeUri(string);
            String string4 = System.getProperty("user.dir");
            int n2 = string4.indexOf(":");
            if (n2 > 0 && string3.startsWith(File.separator)) {
                string3 = string4.substring(0, n2 + 1) + string3;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Could not convert URI " + string + " to path: " + unsupportedEncodingException.getMessage());
        }
        return string3;
    }

    public static String decodeUri(String string) throws UnsupportedEncodingException {
        if (string.indexOf(37) == -1) {
            return string;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '%') {
                char c2 = stringCharacterIterator.next();
                if (c2 != '\uffff') {
                    int n = Character.digit(c2, 16);
                    char c3 = stringCharacterIterator.next();
                    if (c3 != '\uffff') {
                        int n2 = Character.digit(c3, 16);
                        byteArrayOutputStream.write((char)((n << 4) + n2));
                    }
                }
            } else {
                byteArrayOutputStream.write(c);
            }
            c = stringCharacterIterator.next();
        }
        return byteArrayOutputStream.toString(URI_ENCODING);
    }

    public static String encodeURI(String string) throws UnsupportedEncodingException {
        int n;
        int n2 = string.length();
        int n3 = 0;
        StringBuffer stringBuffer = null;
        for (n = 0; n < n2 && (n3 = string.charAt(n)) < 128; ++n) {
            if (gNeedEscaping[n3]) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.substring(0, n));
                }
                stringBuffer.append('%');
                stringBuffer.append(gAfterEscaping1[n3]);
                stringBuffer.append(gAfterEscaping2[n3]);
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append((char)n3);
        }
        if (n < n2) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string.substring(0, n));
            }
            byte[] byArray = null;
            for (byte by : string.substring(n).getBytes(URI_ENCODING)) {
                if (by < 0) {
                    n3 = by + 256;
                    stringBuffer.append('%');
                    stringBuffer.append(gHexChs[n3 >> 4]);
                    stringBuffer.append(gHexChs[n3 & 0xF]);
                    continue;
                }
                if (gNeedEscaping[by]) {
                    stringBuffer.append('%');
                    stringBuffer.append(gAfterEscaping1[by]);
                    stringBuffer.append(gAfterEscaping2[by]);
                    continue;
                }
                stringBuffer.append((char)by);
            }
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    public static URL fileToURL(File file) throws MalformedURLException {
        try {
            return new URL(Locator.encodeURI(file.toURL().toString()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MalformedURLException(unsupportedEncodingException.toString());
        }
    }

    public static File getToolsJar() {
        boolean bl = false;
        try {
            Class.forName("com.sun.tools.javac.Main");
            bl = true;
        }
        catch (Exception exception) {
            try {
                Class.forName("sun.tools.javac.Main");
                bl = true;
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if (bl) {
            return null;
        }
        String string = File.separator + "lib" + File.separator + "tools.jar";
        String string2 = System.getProperty("java.home");
        File file = new File(string2 + string);
        if (file.exists()) {
            return file;
        }
        if (string2.toLowerCase(Locale.US).endsWith(File.separator + "jre")) {
            string2 = string2.substring(0, string2.length() - "/jre".length());
            file = new File(string2 + string);
        }
        if (!file.exists()) {
            System.out.println("Unable to locate tools.jar. Expected to find it in " + file.getPath());
            return null;
        }
        return file;
    }

    public static URL[] getLocationURLs(File file) throws MalformedURLException {
        return Locator.getLocationURLs(file, new String[]{".jar"});
    }

    public static URL[] getLocationURLs(File file, final String[] stringArray) throws MalformedURLException {
        URL[] uRLArray = new URL[]{};
        if (!file.exists()) {
            return uRLArray;
        }
        if (!file.isDirectory()) {
            uRLArray = new URL[1];
            String string = file.getPath();
            String string2 = string.toLowerCase(Locale.US);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.endsWith(stringArray[i])) continue;
                uRLArray[0] = Locator.fileToURL(file);
                break;
            }
            return uRLArray;
        }
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                String string2 = string.toLowerCase(Locale.US);
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string2.endsWith(stringArray[i])) continue;
                    return true;
                }
                return false;
            }
        });
        uRLArray = new URL[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            uRLArray[i] = Locator.fileToURL(fileArray[i]);
        }
        return uRLArray;
    }

    static {
        for (int i = 0; i < 32; ++i) {
            Locator.gNeedEscaping[i] = true;
            Locator.gAfterEscaping1[i] = gHexChs[i >> 4];
            Locator.gAfterEscaping2[i] = gHexChs[i & 0xF];
        }
        Locator.gNeedEscaping[127] = true;
        Locator.gAfterEscaping1[127] = 55;
        Locator.gAfterEscaping2[127] = 70;
        for (char c : new char[]{' ', '<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'}) {
            Locator.gNeedEscaping[c] = true;
            Locator.gAfterEscaping1[c] = gHexChs[c >> 4];
            Locator.gAfterEscaping2[c] = gHexChs[c & 0xF];
        }
    }
}

