/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.commands;

import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;

public class SchemaManagerXML {
    private SchemaManager smanager;
    private static SchemaManagerXML _instance = null;
    private static int access_count = 0;

    public static SchemaManagerXML instance(String string, InternalIF internalIF) throws ArchiveException, ModuleCriticalException {
        if (_instance == null) {
            _instance = new SchemaManagerXML(string, internalIF);
        }
        ++access_count;
        return _instance;
    }

    public void close() throws DatabaseException {
        if (--access_count == 0) {
            this.smanager.close();
            _instance = null;
        }
    }

    public void refresh() throws DatabaseException, ModuleCriticalException {
        this.smanager.refresh();
    }

    private SchemaManagerXML(String string, InternalIF internalIF) throws ArchiveException, ModuleCriticalException {
        this.smanager = internalIF.getSchemaManager(string);
    }

    public Element getElement() throws DatabaseException, ModuleCriticalException, ArchiveException {
        Element element = new Element("schemaManager");
        Element element2 = new Element("namespaces");
        element.addContent((Content)element2);
        Element element3 = new Element("schemas");
        element.addContent((Content)element3);
        HashMap hashMap = this.smanager.namespaces();
        this.addNamespaceElements(element2, hashMap);
        List list = this.smanager.listSchema();
        Collections.sort(list);
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Element element4 = new Element("schema");
            String string = (String)listIterator.next();
            element4.setAttribute("name", string);
            URI uRI = this.smanager.getSchemaURI(string);
            element4.setAttribute("uri", uRI.toASCIIString());
            HashMap hashMap2 = this.smanager.getSchemaNamespaces(uRI);
            this.addNamespaceElements(element4, hashMap2);
            element3.addContent((Content)element4);
        }
        return element;
    }

    private void addNamespaceElements(Element element, HashMap hashMap) {
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Element element2 = new Element("namespace");
            String string = (String)iterator.next();
            String string2 = (String)hashMap.get(string);
            element2.setAttribute("name", string);
            element2.setAttribute("URI", string2);
            element.addContent((Content)element2);
        }
    }

    public void register(String string, URI uRI) throws ModuleCriticalException, ArchiveException {
        this.smanager.registerNamespace(string, uRI);
    }

    public void removeNamespace(String string) throws ModuleCriticalException, ArchiveException {
        this.smanager.removeNamespace(string);
    }

    public void addNamespace(String string, URI uRI) throws ModuleCriticalException, ArchiveException {
        this.smanager.registerNamespace(string, uRI);
    }

    public void assign(String string, String string2) throws ModuleCriticalException, ArchiveException {
        URI uRI = this.smanager.getSchemaURI(string2);
        this.smanager.assignNamespace(string, uRI);
    }

    public void withdraw(String string, String string2) throws ModuleCriticalException, ArchiveException {
        URI uRI = this.smanager.getSchemaURI(string2);
        this.smanager.withdrawNamespace(string, uRI);
    }
}

