/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.commands;

import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.wrappers.ArchiveTimeStamp;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;

public class ArchiveReader
extends Reader {
    StringReader reader = null;
    HashMap namespaces = null;

    public ArchiveReader(URI uRI, ArchiveTimeStamp archiveTimeStamp, String string) throws ArchiveException, ModuleCriticalException {
        InternalIF internalIF = InternalIFFactory.getInternalIF((Logger)Logger.getAnonymousLogger());
        SchemaManager schemaManager = internalIF.getSchemaManager(string);
        this.namespaces = schemaManager.namespaces();
        this.namespaces = this.reverse(this.namespaces);
        schemaManager.close();
        String string2 = internalIF.get(uRI, archiveTimeStamp, string);
        internalIF.close();
        this.reader = new StringReader(this.filter(string2));
    }

    public ArchiveReader(URI uRI, String string) throws ArchiveException, ModuleCriticalException {
        InternalIF internalIF = InternalIFFactory.getInternalIF((Logger)Logger.getAnonymousLogger());
        SchemaManager schemaManager = internalIF.getSchemaManager(string);
        this.namespaces = schemaManager.namespaces();
        this.namespaces = this.reverse(this.namespaces);
        schemaManager.close();
        String string2 = internalIF.get(uRI, string);
        internalIF.close();
        this.reader = new StringReader(this.filter(string2));
    }

    private HashMap reverse(HashMap hashMap) {
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        Set set = hashMap.keySet();
        for (String string : set) {
            String string2 = (String)hashMap.get(string);
            hashMap2.put(string2, string);
        }
        return hashMap2;
    }

    private String filter(String string) {
        String[] stringArray = string.split("xmlns:");
        for (int i = 1; i < stringArray.length; ++i) {
            int n;
            int n2 = stringArray[i].indexOf("=");
            String string2 = stringArray[i].substring(0, n2);
            int n3 = stringArray[i].indexOf("\"", n2);
            String string3 = stringArray[i].substring(n3 + 1, n = stringArray[i].indexOf("\"", n3 + 1));
            String string4 = (String)this.namespaces.get(string3);
            if (string4 == null) continue;
            string = string.replaceAll(string2, string4);
        }
        return string;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public boolean equals(Object object) {
        return this.reader.equals(object);
    }

    public int hashCode() {
        return this.reader.hashCode();
    }

    @Override
    public void mark(int n) throws IOException {
        this.reader.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.reader.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.reader.read();
    }

    @Override
    public int read(char[] cArray) throws IOException {
        return this.reader.read(cArray);
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        return this.reader.read(cArray, n, n2);
    }

    @Override
    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    @Override
    public void reset() throws IOException {
        this.reader.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.reader.skip(l);
    }

    public String toString() {
        return this.reader.toString();
    }
}

