/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.browser;

import alma.acs.container.archive.Range;
import alma.archive.database.interfaces.IdentifierManager;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.wrappers.ArchiveTimeStamp;
import alma.archive.wrappers.DocumentData;
import alma.archive.wrappers.Permissions;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;

public class putdoc
extends HttpServlet {
    private InternalIF internalif = null;
    private SchemaManager smanager = null;
    private IdentifierManager imanager = null;
    private Range range;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("uri");
        String string2 = httpServletRequest.getParameter("type");
        URI uRI = null;
        if (string == null) {
            if (string2.equalsIgnoreCase("Update")) {
                throw new ServletException("Cannot update without an id");
            }
        } else {
            try {
                uRI = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
        List list = null;
        String string3 = "";
        try {
            if (string2.equalsIgnoreCase("Update")) {
                DocumentData documentData = this.internalif.status(uRI, "browser");
                URI uRI2 = documentData.getSchema();
                string3 = this.smanager.getSchemaName(uRI2);
            } else if (string2.equalsIgnoreCase("Store")) {
                uRI = this.range.next();
                list = this.smanager.listSchema();
            } else if (string2.equalsIgnoreCase("Store Schema")) {
                uRI = this.range.next();
            }
        }
        catch (ArchiveException archiveException) {
            archiveException.printStackTrace();
        }
        catch (ModuleCriticalException moduleCriticalException) {
            moduleCriticalException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.showHtmlPage(httpServletResponse, uRI, string2, string3, list);
    }

    private void showHtmlPage(HttpServletResponse httpServletResponse, URI uRI, String string, String string2, List list) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        httpServletResponse.setContentType("text/html");
        printWriter.println("<html><head><title>putform.html</title><link rel=stylesheet href=\"pages/styles.css\" type=\"text/css\"/></head>");
        printWriter.println("<body>");
        printWriter.println("<table border=\"0\" width=\"100%\">");
        printWriter.println("<tr>");
        printWriter.println("<td width=\"100%\" class=\"head\" colspan=\"3\">" + string + "</td>");
        printWriter.println("</tr>");
        printWriter.print("<form ");
        printWriter.print("method=\"POST\" ");
        printWriter.print("ENCTYPE=\"multipart/form-data\" ");
        printWriter.print("action=\"/ArchiveManager/putdoc\"");
        printWriter.println(">");
        printWriter.println("<tr>");
        if (string.equalsIgnoreCase("Update")) {
            printWriter.println("<input type=\"hidden\" name=\"schema\" value=\"" + string2 + "\"");
            printWriter.println("<td width=\"50%\" class=\"ver\">" + string2 + "</td>");
        } else if (string.equalsIgnoreCase("Store")) {
            printWriter.println("<td width=\"50%\">");
            printWriter.println("<select name=\"schema\">");
            for (String string3 : list) {
                printWriter.println("<option>" + string3 + "</option>");
            }
            printWriter.println("</select>");
            printWriter.println("</td>");
        } else if (string.equalsIgnoreCase("Store Schema")) {
            printWriter.println("<td width=\"50%\">");
            printWriter.println("<input type=\"text\" name=\"schema\"");
        }
        printWriter.println("<td width=\"50%\" class=\"ver\" colspan=\"2\">" + uRI.toASCIIString() + "</td>");
        printWriter.println("</tr>");
        printWriter.println("<tr>");
        printWriter.println("<td nowrap>Filename:</td>");
        printWriter.println("<input type=\"hidden\" name=\"uri\" value=\"" + uRI.toASCIIString() + "\"");
        printWriter.println("<input type=\"hidden\" name=\"type\" value=\"" + string + "\"");
        printWriter.println("<td><input type=\"file\" name=\"fileUpload\"/> </td>");
        printWriter.println("<td align=\"right\"><input type=\"submit\" value=\"" + string + "\"> </td>");
        printWriter.println("</tr>");
        printWriter.println("</form>");
        printWriter.println("</body>");
        printWriter.println("</html>");
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        HashMap hashMap = this.getParameters(httpServletRequest);
        String string = (String)hashMap.get("uri");
        String string2 = (String)hashMap.get("type");
        String string3 = (String)hashMap.get("schema");
        String string4 = (String)hashMap.get("fileUpload");
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        try {
            if (string2.equalsIgnoreCase("Update")) {
                DocumentData documentData = this.internalif.status(uRI, "browser");
                ArchiveTimeStamp archiveTimeStamp = documentData.getTimestamp();
                this.internalif.update(uRI, archiveTimeStamp, string4, documentData.getSchema(), false, "browser");
            } else if (string2.equalsIgnoreCase("Store")) {
                URI uRI2 = this.smanager.getSchemaURI(string3);
                this.internalif.store(uRI, string4, uRI2, string3, "browser", new Permissions(), "browser", true);
            } else if (string2.equalsIgnoreCase("Store Schema")) {
                this.smanager.addSchema(string3, string4, "", uRI, "browser", new Permissions());
            }
        }
        catch (ArchiveException archiveException) {
            archiveException.printStackTrace();
        }
        catch (ModuleCriticalException moduleCriticalException) {
            moduleCriticalException.printStackTrace();
        }
    }

    private HashMap getParameters(HttpServletRequest httpServletRequest) {
        DiskFileUpload diskFileUpload = new DiskFileUpload();
        diskFileUpload.setSizeMax(1000000L);
        diskFileUpload.setSizeThreshold(4096);
        diskFileUpload.setRepositoryPath("/tmp");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            List list = diskFileUpload.parseRequest(httpServletRequest);
            for (FileItem fileItem : list) {
                String string = fileItem.getFieldName();
                String string2 = fileItem.getString();
                hashMap.put(string, string2);
            }
        }
        catch (FileUploadException fileUploadException) {
            fileUploadException.printStackTrace();
        }
        return hashMap;
    }

    public void init() throws ServletException {
        try {
            this.internalif = InternalIFFactory.getInternalIF((Logger)Logger.getAnonymousLogger());
            this.internalif.init();
            this.smanager = this.internalif.getSchemaManager("browser");
            this.imanager = InternalIFFactory.getIdentifierManager((Logger)Logger.getAnonymousLogger());
            this.range = new Range(this.imanager.getNewRange());
        }
        catch (ArchiveException archiveException) {
            throw new ServletException(archiveException.getMessage());
        }
        catch (ModuleCriticalException moduleCriticalException) {
            throw new ServletException(moduleCriticalException.getMessage());
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    public void destroy() {
        try {
            this.smanager.close();
            this.imanager.close();
            this.internalif.close();
        }
        catch (DatabaseException databaseException) {
            this.log("Problems closong the internal interface", databaseException);
        }
        catch (ModuleCriticalException moduleCriticalException) {
            this.log("Problems closong the internal interface", moduleCriticalException);
        }
        super.destroy();
    }
}

