/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.browser;

import alma.archive.commands.ArchiveReader;
import alma.archive.database.helpers.Hierarchy;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.wrappers.ArchiveTimeStamp;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class getdoc
extends HttpServlet {
    private Templates xmlToHtml;
    private Templates entityGroup;
    private InternalIF internalif = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("uri");
        String string2 = httpServletRequest.getParameter("path");
        if (string2 == null) {
            string2 = "/nothing";
        }
        String string3 = httpServletRequest.getParameter("timeStamp");
        String string4 = httpServletRequest.getParameter("format");
        String string5 = httpServletRequest.getParameter("project");
        if (string == null) throw new ServletException("Must define a value for uri");
        try {
            URI uRI = new URI(string);
            if (string5 != null) {
                Hierarchy hierarchy = new Hierarchy(uRI, "browser");
                Reader reader = hierarchy.generate();
                if (string4.equalsIgnoreCase("html")) {
                    this.showHtmlPage(httpServletResponse, this.entityGroup, reader, string2);
                    return;
                } else {
                    if (!string4.equalsIgnoreCase("xml")) return;
                    this.showXmlPage(httpServletResponse, reader);
                }
                return;
            } else {
                ArchiveTimeStamp archiveTimeStamp = null;
                ArchiveReader archiveReader = null;
                if (string3 != null) {
                    archiveTimeStamp = new ArchiveTimeStamp(string3);
                    archiveReader = new ArchiveReader(uRI, archiveTimeStamp, "browser");
                } else {
                    archiveReader = new ArchiveReader(uRI, "browser");
                }
                if (string4.equalsIgnoreCase("html")) {
                    this.showHtmlPage(httpServletResponse, this.xmlToHtml, archiveReader, string2);
                    return;
                } else {
                    if (!string4.equalsIgnoreCase("xml")) return;
                    this.showXmlPage(httpServletResponse, archiveReader);
                }
            }
            return;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ServletException("uri is not a valid URI", (Throwable)uRISyntaxException);
        }
        catch (DatabaseException databaseException) {
            throw new ServletException("Invalid timestamp " + string3, (Throwable)databaseException);
        }
        catch (ArchiveException archiveException) {
            this.showError(httpServletResponse, "Document not available");
            return;
        }
        catch (ModuleCriticalException moduleCriticalException) {
            throw new ServletException("Problem creating an ArchiveReader", (Throwable)moduleCriticalException);
        }
    }

    private void showError(HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("<link rel=\"stylesheet\" href=\"pages/styles.css\" type=\"text/css\"/>");
        printWriter.println("</head>");
        printWriter.println("<body><h2 class=\"head\">" + string + "</h2></body>");
    }

    private void showHtmlPage(HttpServletResponse httpServletResponse, Templates templates, Reader reader, String string) throws IOException {
        StreamSource streamSource = new StreamSource(reader);
        PrintWriter printWriter = httpServletResponse.getWriter();
        httpServletResponse.setContentType("text/html");
        try {
            Transformer transformer = templates.newTransformer();
            if (string != null) {
                transformer.setParameter("path", string);
            }
            transformer.transform(streamSource, new StreamResult(printWriter));
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
        }
    }

    private void showXmlPage(HttpServletResponse httpServletResponse, Reader reader) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        httpServletResponse.setContentType("text/html");
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = "";
        while ((string = bufferedReader.readLine()) != null) {
            printWriter.println(string);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
    }

    public void init() throws ServletException {
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        String string = null;
        try {
            string = "/WEB-INF/xslt/xml2html.xslt";
            URL uRL = this.getServletContext().getResource(string);
            if (uRL == null) {
                throw new MalformedURLException();
            }
            String string2 = uRL.toExternalForm();
            this.xmlToHtml = transformerFactory.newTemplates(new StreamSource(string2));
            string = "/WEB-INF/xslt/EntityGroup.xslt";
            uRL = this.getServletContext().getResource(string);
            if (uRL == null) {
                throw new MalformedURLException();
            }
            string2 = uRL.toExternalForm();
            this.entityGroup = transformerFactory.newTemplates(new StreamSource(string2));
            try {
                this.internalif = InternalIFFactory.getInternalIF((Logger)Logger.getAnonymousLogger());
                this.internalif.init();
            }
            catch (DatabaseException databaseException) {
                throw new ServletException(databaseException.getMessage());
            }
            catch (ModuleCriticalException moduleCriticalException) {
                throw new ServletException(moduleCriticalException.getMessage());
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.log("Unable to compile stylesheet", transformerConfigurationException);
            throw new UnavailableException("Unable to compile stylesheet");
        }
        catch (MalformedURLException malformedURLException) {
            this.log("Unable to locate XSLT file: " + string);
            throw new UnavailableException("Unable to locate XSLT file: " + string);
        }
    }

    public void destroy() {
        try {
            this.internalif.close();
        }
        catch (DatabaseException databaseException) {
            this.log("Couldn't close the internalif", databaseException);
        }
        catch (ModuleCriticalException moduleCriticalException) {
            this.log("Couldn't close the internalif", moduleCriticalException);
        }
        super.destroy();
    }
}

