/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.browser;

import alma.archive.commands.SchemaManagerXML;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GetNamespace
extends HttpServlet {
    private Templates nsTemplate;
    private Templates scTemplate;
    private InternalIF internalif = null;
    private SchemaManagerXML smanagerx = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("action");
        String string2 = httpServletRequest.getParameter("page");
        String string3 = httpServletRequest.getParameter("name");
        String string4 = httpServletRequest.getParameter("schemaname");
        String string5 = httpServletRequest.getParameter("namespace");
        String string6 = httpServletRequest.getParameter("format");
        if (string == null) throw new UnavailableException("No action defined");
        try {
            if (string.equalsIgnoreCase("add")) {
                try {
                    URI uRI = new URI(string5);
                    this.smanagerx.addNamespace(string3, uRI);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new ArchiveException((Throwable)uRISyntaxException);
                }
            } else if (string.equalsIgnoreCase("remove")) {
                this.smanagerx.removeNamespace(string3);
            } else if (string.equalsIgnoreCase("assign")) {
                this.smanagerx.assign(string3, string4);
            } else if (string.equalsIgnoreCase("withdraw")) {
                this.smanagerx.withdraw(string3, string4);
            } else if (string.equalsIgnoreCase("redraw")) {
                this.smanagerx.refresh();
            }
            if (string6.equalsIgnoreCase("html")) {
                if (string2.equalsIgnoreCase("namespace")) {
                    this.showHtmlPage(this.smanagerx.getElement(), this.nsTemplate, httpServletResponse);
                    return;
                } else {
                    if (!string2.equalsIgnoreCase("schema")) return;
                    this.showHtmlPage(this.smanagerx.getElement(), this.scTemplate, httpServletResponse);
                }
                return;
            } else {
                if (!string6.equalsIgnoreCase("xml")) return;
                this.showXmlPage(this.smanagerx.getElement(), httpServletResponse);
            }
            return;
        }
        catch (ArchiveException archiveException) {
            throw new UnavailableException("Problems accessing the Archive");
        }
        catch (ModuleCriticalException moduleCriticalException) {
            throw new UnavailableException("Problems accessing the Archive");
        }
    }

    private void showHtmlPage(Element element, Templates templates, HttpServletResponse httpServletResponse) throws IOException {
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
        String string = xMLOutputter.outputString(element);
        StreamSource streamSource = new StreamSource(new StringReader(string));
        PrintWriter printWriter = httpServletResponse.getWriter();
        httpServletResponse.setContentType("text/html");
        try {
            Transformer transformer = templates.newTransformer();
            transformer.transform(streamSource, new StreamResult(printWriter));
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
        }
    }

    private void showXmlPage(Element element, HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
        printWriter.print(xMLOutputter.outputString(element));
    }

    public void init() throws ServletException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        try {
            String string = "/WEB-INF/xslt/namespaces.xslt";
            URL uRL = this.getServletContext().getResource(string);
            if (uRL == null) {
                throw new MalformedURLException();
            }
            this.nsTemplate = transformerFactory.newTemplates(new StreamSource(uRL.toExternalForm()));
            String string2 = "/WEB-INF/xslt/schemas.xslt";
            URL uRL2 = this.getServletContext().getResource(string2);
            if (uRL2 == null) {
                throw new MalformedURLException();
            }
            this.scTemplate = transformerFactory.newTemplates(new StreamSource(uRL2.toExternalForm()));
            try {
                this.internalif = InternalIFFactory.getInternalIF((Logger)Logger.getAnonymousLogger());
                this.internalif.init();
                this.smanagerx = SchemaManagerXML.instance("browser", this.internalif);
            }
            catch (ArchiveException archiveException) {
                throw new ServletException(archiveException.getMessage());
            }
            catch (ModuleCriticalException moduleCriticalException) {
                throw new ServletException(moduleCriticalException.getMessage());
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.log("Unable to compile stylesheet", transformerConfigurationException);
            throw new UnavailableException("Unable to compile stylesheet");
        }
        catch (MalformedURLException malformedURLException) {
            this.log("Unable to locate XSLT file");
            throw new UnavailableException("Unable to locate XSLT file");
        }
    }

    public void destroy() {
        try {
            this.smanagerx.close();
            this.internalif.close();
        }
        catch (DatabaseException databaseException) {
            this.log("Problems closong the internal interface", databaseException);
        }
        catch (ModuleCriticalException moduleCriticalException) {
            this.log("Problems closong the internal interface", moduleCriticalException);
        }
        super.destroy();
    }
}

