/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.logging;

import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import java.util.Collection;
import java.util.logging.Logger;

public class ArchiveLoggingQuery {
    private final long maximalStorageTime = 2000L;
    private InternalIF internal;
    private final short maxLogType = (short)99;
    Logger m_logger;

    public ArchiveLoggingQuery(Logger logger) throws ArchiveException {
        this.m_logger = logger != null ? logger : Logger.getLogger("ArchiveLoggingQuery");
        try {
            this.internal = InternalIFFactory.getInternalIF((Logger)this.m_logger);
        }
        catch (Exception exception) {
            throw new ArchiveException("Archive internal error", (Throwable)exception);
        }
    }

    public Collection<String> getLog(String string, String string2, int n) throws ArchiveException {
        return this.getLog(string, string2, (short)0, (short)99, null, null, null, n);
    }

    public Collection<String> getLog(String string, String string2, String string3, int n) throws ArchiveException {
        return this.getLog(string, string2, (short)0, (short)99, null, null, string3, n);
    }

    public Collection<String> getLog(String string, String string2, short s, String string3, int n) throws ArchiveException {
        return this.getLog(string, string2, s, s, null, null, string3, n);
    }

    public Collection<String> getLog(String string, String string2, short s, short s2, int n) throws ArchiveException {
        return this.getLog(string, string2, s, s2, null, null, null, n);
    }

    public Collection<String> getLog(String string, String string2, short s, short s2, String string3, int n) throws ArchiveException {
        return this.getLog(string, string2, s, s2, null, null, string3, n);
    }

    public Collection<String> getLog(String string, String string2, short s, short s2, String string3, String string4, String string5, int n) throws ArchiveException {
        try {
            return this.internal.getLog(string, string2, s, s2, string3, string4, string5, n);
        }
        catch (ModuleCriticalException moduleCriticalException) {
            throw new ArchiveException(moduleCriticalException.getCause());
        }
    }
}

